/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wct;

import appeng.api.features.Locatables;
import appeng.api.implementations.blockentities.IWirelessAccessPoint;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.upgrades.IUpgradeableItem;
import appeng.api.util.DimensionalBlockPos;
import appeng.blockentity.networking.WirelessBlockEntity;
import appeng.items.tools.powered.WirelessTerminalItem;
import appeng.menu.locator.MenuLocator;
import de.mari_023.ae2wtlib.AE2wtlib;
import de.mari_023.ae2wtlib.AE2wtlibConfig;
import de.mari_023.ae2wtlib.Platform;
import de.mari_023.ae2wtlib.wut.WUTHandler;
import java.util.HashMap;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class CraftingTerminalHandler {
    private static final HashMap<UUID, CraftingTerminalHandler> players = new HashMap();
    private final class_1657 player;
    private class_1799 craftingTerminal = class_1799.field_8037;
    private IActionHost securityStation;
    private IGrid targetGrid;
    private MenuLocator locator;
    private IWirelessAccessPoint myWap;
    private double sqRange = Double.MAX_VALUE;
    private HashMap<class_1792, Long> restockAbleItems = new HashMap();

    private CraftingTerminalHandler(class_1657 player) {
        this.player = player;
    }

    public static CraftingTerminalHandler getCraftingTerminalHandler(class_1657 player) {
        if (players.containsKey(player.method_5667())) {
            if (player == CraftingTerminalHandler.players.get((Object)player.method_5667()).player || !(player instanceof class_3222) && CraftingTerminalHandler.players.get((Object)player.method_5667()).player instanceof class_3222) {
                return players.get(player.method_5667());
            }
            CraftingTerminalHandler.removePlayer(player);
        }
        CraftingTerminalHandler handler = new CraftingTerminalHandler(player);
        players.put(player.method_5667(), handler);
        return handler;
    }

    public static void removePlayer(class_1657 player) {
        players.remove(player.method_5667());
    }

    public void invalidateCache() {
        this.craftingTerminal = class_1799.field_8037;
        this.locator = null;
        this.securityStation = null;
        this.targetGrid = null;
        this.myWap = null;
        this.sqRange = Double.MAX_VALUE;
        this.restockAbleItems.clear();
    }

    public class_1799 getCraftingTerminal() {
        class_1661 inv = this.player.method_31548();
        if (!this.craftingTerminal.method_7960() && (inv.method_7379(this.craftingTerminal) || AE2wtlibConfig.INSTANCE.allowTrinket() && Platform.isStillPresentTrinkets(this.player, this.craftingTerminal))) {
            return this.craftingTerminal;
        }
        this.locator = WUTHandler.findTerminal(this.player, "crafting");
        this.craftingTerminal = this.locator == null ? class_1799.field_8037 : WUTHandler.getItemStackFromLocator(this.player, this.locator);
        if (this.craftingTerminal.method_7960()) {
            this.invalidateCache();
        } else {
            this.securityStation = null;
            this.targetGrid = null;
        }
        return this.craftingTerminal;
    }

    @Nullable
    public MenuLocator getLocator() {
        if (this.getCraftingTerminal().method_7960()) {
            return null;
        }
        return this.locator;
    }

    @Nullable
    public IActionHost getSecurityStation() {
        if (this.getCraftingTerminal().method_7960()) {
            this.securityStation = null;
            return null;
        }
        if (this.securityStation != null) {
            return this.securityStation;
        }
        OptionalLong unParsedKey = ((WirelessTerminalItem)this.craftingTerminal.method_7909()).getGridKey(this.craftingTerminal);
        if (unParsedKey.isEmpty()) {
            this.securityStation = null;
            return null;
        }
        long parsedKey = unParsedKey.getAsLong();
        this.securityStation = (IActionHost)Locatables.securityStations().get(this.player.field_6002, parsedKey);
        return this.securityStation;
    }

    @Nullable
    public IGrid getTargetGrid() {
        if (this.getSecurityStation() == null) {
            this.targetGrid = null;
            return null;
        }
        IGridNode n = this.securityStation.getActionableNode();
        if (n == null) {
            this.targetGrid = null;
            return null;
        }
        this.targetGrid = n.getGrid();
        return this.targetGrid;
    }

    public boolean inRange() {
        class_1799 is = this.getCraftingTerminal();
        if (is.method_7960()) {
            return false;
        }
        if (((IUpgradeableItem)is.method_7909()).getUpgrades(is).isInstalled((class_1935)AE2wtlib.INFINITY_BOOSTER)) {
            return true;
        }
        this.sqRange = Double.MAX_VALUE;
        if (this.getTargetGrid() == null) {
            return false;
        }
        if (this.myWap != null && this.myWap.getGrid() == this.targetGrid && this.testWap(this.myWap)) {
            return true;
        }
        Set tw = this.targetGrid.getMachines(WirelessBlockEntity.class);
        this.myWap = null;
        for (WirelessBlockEntity n : tw) {
            if (!this.testWap((IWirelessAccessPoint)n)) continue;
            this.myWap = n;
        }
        return this.myWap != null;
    }

    private boolean testWap(IWirelessAccessPoint wap) {
        double offZ;
        double offY;
        double rangeLimit = wap.getRange();
        rangeLimit *= rangeLimit;
        DimensionalBlockPos dc = wap.getLocation();
        if (dc.getLevel() != this.player.field_6002) {
            return false;
        }
        double offX = (double)dc.getPos().method_10263() - this.player.method_23317();
        double r = offX * offX + (offY = (double)dc.getPos().method_10264() - this.player.method_23318()) * offY + (offZ = (double)dc.getPos().method_10260() - this.player.method_23321()) * offZ;
        if (r < rangeLimit && this.sqRange > r && wap.isActive()) {
            this.sqRange = r;
            return true;
        }
        return false;
    }

    public long getAccessibleAmount(class_1799 stack) {
        return (long)stack.method_7947() + (this.restockAbleItems.get(stack.method_7909()) == null ? 0L : this.restockAbleItems.get(stack.method_7909()));
    }

    public void setRestockAbleItems(HashMap<class_1792, Long> items) {
        this.restockAbleItems = items;
    }
}

