/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.networking.c2s;

import appeng.menu.locator.MenuLocator;
import de.mari_023.ae2wtlib.TextConstants;
import de.mari_023.ae2wtlib.networking.AE2wtlibPacket;
import de.mari_023.ae2wtlib.terminal.ItemWT;
import de.mari_023.ae2wtlib.wct.CraftingTerminalHandler;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetHandler;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetMode;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetSettings;
import de.mari_023.ae2wtlib.wut.WUTHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class HotkeyPacket
extends AE2wtlibPacket {
    public static final String NAME = "hotkey";

    public HotkeyPacket(class_2540 buf) {
        super(buf);
    }

    public HotkeyPacket(String type) {
        super(HotkeyPacket.createBuffer());
        this.buf.method_10814(type);
    }

    @Override
    public void processPacketData(class_1657 player) {
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        String terminalName = this.buf.method_10800(Short.MAX_VALUE);
        if (terminalName.equalsIgnoreCase("toggleRestock")) {
            CraftingTerminalHandler craftingTerminalHandler = CraftingTerminalHandler.getCraftingTerminalHandler((class_1657)serverPlayer);
            class_1799 terminal = craftingTerminalHandler.getCraftingTerminal();
            if (terminal.method_7960()) {
                return;
            }
            ItemWT.setBoolean(terminal, !ItemWT.getBoolean(terminal, "restock"), "restock");
            MenuLocator locator = craftingTerminalHandler.getLocator();
            if (locator != null) {
                WUTHandler.updateClientTerminal(serverPlayer, locator, terminal.method_7969());
            }
            if (ItemWT.getBoolean(terminal, "restock")) {
                serverPlayer.method_7353((class_2561)TextConstants.RESTOCK_ON, true);
            } else {
                serverPlayer.method_7353((class_2561)TextConstants.RESTOCK_OFF, true);
            }
        } else if (terminalName.equalsIgnoreCase("toggleMagnet")) {
            class_1799 terminal = CraftingTerminalHandler.getCraftingTerminalHandler((class_1657)serverPlayer).getCraftingTerminal();
            if (terminal.method_7960()) {
                return;
            }
            MagnetSettings settings = MagnetHandler.getMagnetSettings(terminal);
            switch (settings.magnetMode) {
                case OFF: {
                    serverPlayer.method_7353((class_2561)TextConstants.HOTKEY_MAGNETCARD_INVENTORY, true);
                    settings.magnetMode = MagnetMode.PICKUP_INVENTORY;
                    break;
                }
                case PICKUP_INVENTORY: {
                    serverPlayer.method_7353((class_2561)TextConstants.HOTKEY_MAGNETCARD_ME, true);
                    settings.magnetMode = MagnetMode.PICKUP_ME;
                    break;
                }
                case PICKUP_ME: {
                    serverPlayer.method_7353((class_2561)TextConstants.HOTKEY_MAGNETCARD_OFF, true);
                    settings.magnetMode = MagnetMode.OFF;
                }
            }
            MagnetHandler.saveMagnetSettings(terminal, settings);
        } else {
            MenuLocator locator = WUTHandler.findTerminal((class_1657)serverPlayer, terminalName);
            if (locator == null) {
                return;
            }
            class_1799 terminal = WUTHandler.getItemStackFromLocator((class_1657)serverPlayer, locator);
            WUTHandler.setCurrentTerminal((class_1657)serverPlayer, locator, terminal, terminalName);
            WUTHandler.wirelessTerminals.get(terminalName).item().tryOpen((class_1657)serverPlayer, locator, terminal);
        }
    }

    @Override
    public String getPacketName() {
        return NAME;
    }
}

