/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.core.component;

import com.mojang.blaze3d.systems.RenderSystem;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_757;

public class HealthComponent
implements ITooltipComponent {
    private final float health;
    private final float maxHealth;
    private final int heartsPerLine;
    private final int lineCount;

    public HealthComponent(float health, float maxHealth) {
        this.health = health;
        this.maxHealth = maxHealth;
        float maxHearts = IWailaConfig.get().getGeneral().getMaxHeartsPerLine();
        this.heartsPerLine = (int)Math.min((double)maxHearts, Math.ceil(maxHealth));
        this.lineCount = (int)Math.ceil(maxHealth / maxHearts);
    }

    @Override
    public int getWidth() {
        return 8 * this.heartsPerLine;
    }

    @Override
    public int getHeight() {
        return 10 * this.lineCount;
    }

    @Override
    public void render(class_4587 matrices, int x, int y, float delta) {
        int xOffset = 0;
        for (int i = 1; i <= class_3532.method_15386((float)this.maxHealth); ++i) {
            if (i <= class_3532.method_15375((float)this.health)) {
                Texture.HEART.render(matrices, x + xOffset, y);
                xOffset += 8;
            }
            if ((float)i > this.health && (float)i < this.health + 1.0f) {
                Texture.HALF_HEART.render(matrices, x + xOffset, y);
                xOffset += 8;
            }
            if ((float)i >= this.health + 1.0f) {
                Texture.EMPTY_HEART.render(matrices, x + xOffset, y);
                xOffset += 8;
            }
            if (i % this.heartsPerLine != 0) continue;
            y += 10;
            xOffset = 0;
        }
    }

    static enum Texture {
        HEART(52, 0, 9, 9, 16, 0, 9, 9, "a"),
        HALF_HEART(61, 0, 9, 9, 16, 0, 9, 9, "b"),
        EMPTY_HEART(16, 0, 9, 9, -1, -1, -1, -1, "c");

        final int u;
        final int v;
        final int su;
        final int sv;
        final int bu;
        final int bv;
        final int bsu;
        final int bsv;
        final String symbol;

        private Texture(int u, int v, int su, int sv, int bu, int bv, int bsu, int bsv, String symbol) {
            this.u = u;
            this.v = v;
            this.su = su;
            this.sv = sv;
            this.bu = bu;
            this.bv = bv;
            this.bsu = bsu;
            this.bsv = bsv;
            this.symbol = symbol;
        }

        void render(class_4587 matrices, int x, int y) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)class_332.field_22737);
            RenderSystem.enableBlend();
            if (this.bu != -1) {
                class_332.method_25293((class_4587)matrices, (int)x, (int)y, (int)8, (int)8, (float)this.bu, (float)this.bv, (int)this.bsu, (int)this.bsv, (int)256, (int)256);
            }
            class_332.method_25293((class_4587)matrices, (int)x, (int)y, (int)8, (int)8, (float)this.u, (float)this.v, (int)this.su, (int)this.sv, (int)256, (int)256);
            RenderSystem.disableBlend();
        }
    }
}

