/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.config;

import com.google.common.base.Preconditions;
import com.google.gson.JsonPrimitive;
import net.minecraft.class_2960;

public class ConfigEntry<T> {
    public static final Type<Boolean> BOOLEAN = (e, d) -> e.getAsBoolean();
    public static final Type<Integer> INTEGER = (e, d) -> e.getAsInt();
    public static final Type<Double> DOUBLE = (e, d) -> e.getAsDouble();
    public static final Type<String> STRING = (e, d) -> e.getAsString();
    public static final Type<Enum<? extends Enum>> ENUM = (e, d) -> Enum.valueOf(d.getDeclaringClass(), e.getAsString());
    private final class_2960 id;
    private final T defaultValue;
    private final boolean synced;
    private final Type<T> type;
    private T value;

    private ConfigEntry(class_2960 id, T defaultValue, boolean synced, Type<T> type) {
        this.id = id;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.synced = synced;
        this.type = type;
    }

    public Type<T> getType() {
        return this.type;
    }

    public class_2960 getId() {
        return this.id;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isSynced() {
        return this.synced;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        Preconditions.checkArgument((value.getClass() == this.defaultValue.getClass() ? 1 : 0) != 0, (Object)("Tried to assign " + this.defaultValue.getClass() + " with " + value.getClass()));
        this.value = value;
    }

    public static interface Type<T> {
        public T parseValue(JsonPrimitive var1, T var2);

        default public ConfigEntry<T> create(class_2960 id, T defaultValue, boolean synced) {
            return new ConfigEntry<T>(id, defaultValue, synced, this);
        }
    }
}

