/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.api.block;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.energy.BalmEnergyStorageProvider;
import net.blay09.mods.balm.api.energy.EnergyStorage;
import net.blay09.mods.balm.api.fluid.BalmFluidTankProvider;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.balm.api.provider.BalmProvider;
import net.blay09.mods.balm.api.provider.BalmProviderHolder;
import net.minecraft.class_1263;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_3218;

public interface BalmBlockEntityContract
extends BalmProviderHolder {
    default public void writeUpdateTag(class_2487 tag) {
    }

    default public void sync() {
        class_2586 self = (class_2586)this;
        if (self.method_10997() != null && !self.method_10997().field_9236) {
            ((class_3218)self.method_10997()).method_14178().method_14128(self.method_11016());
        }
    }

    default public class_2596<class_2602> createUpdatePacket() {
        return class_2622.method_39026((class_2586)((class_2586)this), BalmBlockEntityContract::createUpdateTag);
    }

    default public class_2487 createUpdateTag() {
        class_2586 self = (class_2586)this;
        return BalmBlockEntityContract.createUpdateTag(self);
    }

    private static class_2487 createUpdateTag(class_2586 blockEntity) {
        class_2487 tag = new class_2487();
        if (blockEntity instanceof BalmBlockEntityContract) {
            BalmBlockEntityContract balmBlockEntity = (BalmBlockEntityContract)blockEntity;
            balmBlockEntity.writeUpdateTag(tag);
        }
        return tag;
    }

    default public void buildProviders(List<BalmProviderHolder> providers) {
        providers.add(this);
        BalmBlockEntityContract balmBlockEntityContract = this;
        if (balmBlockEntityContract instanceof BalmContainerProvider) {
            final BalmContainerProvider containerProvider = (BalmContainerProvider)((Object)balmBlockEntityContract);
            providers.add(new BalmProviderHolder(){

                @Override
                public List<BalmProvider<?>> getProviders() {
                    class_1263 container = containerProvider.getContainer();
                    if (container != null) {
                        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider<class_1263>(class_1263.class, container)});
                    }
                    return Collections.emptyList();
                }

                @Override
                public List<Pair<class_2350, BalmProvider<?>>> getSidedProviders() {
                    ArrayList providers = new ArrayList();
                    for (class_2350 direction : class_2350.values()) {
                        class_1263 container = containerProvider.getContainer(direction);
                        if (container == null) continue;
                        providers.add(Pair.of((Object)direction, new BalmProvider<class_1263>(class_1263.class, container)));
                    }
                    return providers;
                }
            });
        }
        if ((balmBlockEntityContract = this) instanceof BalmFluidTankProvider) {
            final BalmFluidTankProvider fluidTankProvider = (BalmFluidTankProvider)((Object)balmBlockEntityContract);
            providers.add(new BalmProviderHolder(){

                @Override
                public List<BalmProvider<?>> getProviders() {
                    FluidTank fluidTank = fluidTankProvider.getFluidTank();
                    if (fluidTank != null) {
                        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider<FluidTank>(FluidTank.class, fluidTank)});
                    }
                    return Collections.emptyList();
                }

                @Override
                public List<Pair<class_2350, BalmProvider<?>>> getSidedProviders() {
                    ArrayList providers = new ArrayList();
                    for (class_2350 direction : class_2350.values()) {
                        FluidTank fluidTank = fluidTankProvider.getFluidTank(direction);
                        if (fluidTank == null) continue;
                        providers.add(Pair.of((Object)direction, new BalmProvider<FluidTank>(FluidTank.class, fluidTank)));
                    }
                    return providers;
                }
            });
        }
        if ((balmBlockEntityContract = this) instanceof BalmEnergyStorageProvider) {
            final BalmEnergyStorageProvider energyStorageProvider = (BalmEnergyStorageProvider)((Object)balmBlockEntityContract);
            providers.add(new BalmProviderHolder(){

                @Override
                public List<BalmProvider<?>> getProviders() {
                    EnergyStorage energyStorage = energyStorageProvider.getEnergyStorage();
                    if (energyStorage != null) {
                        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider<EnergyStorage>(EnergyStorage.class, energyStorage)});
                    }
                    return Collections.emptyList();
                }

                @Override
                public List<Pair<class_2350, BalmProvider<?>>> getSidedProviders() {
                    ArrayList providers = new ArrayList();
                    for (class_2350 direction : class_2350.values()) {
                        EnergyStorage energyStorage = energyStorageProvider.getEnergyStorage(direction);
                        if (energyStorage == null) continue;
                        providers.add(Pair.of((Object)direction, new BalmProvider<EnergyStorage>(EnergyStorage.class, energyStorage)));
                    }
                    return providers;
                }
            });
        }
    }
}

