/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.reeses_sodium_options.client.gui.frame.tab;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.AbstractFrame;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.components.ScrollBarComponent;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.tab.Tab;
import me.jellysquid.mods.sodium.client.gui.widgets.AbstractWidget;
import me.jellysquid.mods.sodium.client.gui.widgets.FlatButtonWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.class_4587;
import org.apache.commons.lang3.Validate;

public class TabFrame
extends AbstractFrame {
    private ScrollBarComponent tabSectionScrollBar = null;
    private final boolean tabSectionCanScroll;
    private final Dim2i tabSection;
    private final Dim2i frameSection;
    private Tab<?> selectedTab;
    private final List<Tab<?>> tabs = new ArrayList();

    public TabFrame(Dim2i dim, List<Function<Dim2i, Tab<?>>> functions) {
        super(dim);
        this.tabSection = new Dim2i(this.dim.x(), this.dim.y(), (int)((double)this.dim.width() * 0.35), this.dim.height());
        this.frameSection = new Dim2i(this.tabSection.getLimitX(), this.dim.y(), this.dim.width() - this.tabSection.width(), this.dim.height());
        functions.forEach(function -> this.tabs.add((Tab)function.apply(this.frameSection)));
        int tabSectionY = this.tabs.size() * 18;
        boolean bl = this.tabSectionCanScroll = tabSectionY > this.tabSection.height();
        if (this.tabSectionCanScroll) {
            this.tabSectionScrollBar = new ScrollBarComponent(new Dim2i(this.tabSection.getLimitX() - 11, this.tabSection.y(), 10, this.tabSection.height()), ScrollBarComponent.Mode.VERTICAL, tabSectionY, this.dim.height(), this::buildFrame, this.dim);
        }
        this.buildFrame();
    }

    public TabFrame(Dim2i dim, List<Function<Dim2i, Tab<?>>> functions, boolean renderOutline) {
        this(dim, functions);
        this.renderOutline = renderOutline;
    }

    public void setTab(Tab<?> tab) {
        this.selectedTab = tab;
        this.buildFrame();
    }

    @Override
    public void buildFrame() {
        this.children.clear();
        this.drawable.clear();
        this.controlElements.clear();
        if (this.selectedTab == null && this.tabs != null && !this.tabs.isEmpty()) {
            this.selectedTab = this.tabs.get(0);
        }
        this.rebuildTabFrame();
        this.rebuildTabs();
        if (this.tabSectionCanScroll) {
            this.tabSectionScrollBar.updateThumbPosition();
        }
        super.buildFrame();
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.applyScissor(this.dim.x(), this.dim.y(), this.dim.width(), this.dim.height(), () -> {
            for (AbstractWidget widget : this.children) {
                if (widget == this.selectedTab.getFrame()) continue;
                widget.method_25394(matrices, mouseX, mouseY, delta);
            }
        });
        ((AbstractFrame)((Object)this.selectedTab.getFrame())).method_25394(matrices, mouseX, mouseY, delta);
        if (this.tabSectionCanScroll) {
            this.tabSectionScrollBar.method_25394(matrices, mouseX, mouseY, delta);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.dim.containsCursor(mouseX, mouseY) && super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.tabSectionCanScroll && this.tabSection.containsCursor(mouseX, mouseY)) {
            return this.tabSectionScrollBar.method_25402(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (this.tabSectionCanScroll && this.tabSection.containsCursor(mouseX, mouseY)) {
            return this.tabSectionScrollBar.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (super.method_25406(mouseX, mouseY, button)) {
            return true;
        }
        if (this.tabSectionCanScroll && this.tabSection.containsCursor(mouseX, mouseY)) {
            return this.tabSectionScrollBar.method_25406(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (super.method_25401(mouseX, mouseY, amount)) {
            return true;
        }
        if (this.tabSectionCanScroll && this.tabSection.containsCursor(mouseX, mouseY)) {
            return this.tabSectionScrollBar.method_25401(mouseX, mouseY, amount);
        }
        return false;
    }

    private void rebuildTabs() {
        if (this.tabs == null) {
            return;
        }
        int offsetY = 0;
        for (Tab<?> tab : this.tabs) {
            int x = this.tabSection.x();
            int y = this.tabSection.y() + offsetY - (this.tabSectionCanScroll ? this.tabSectionScrollBar.getOffset() : 0);
            int width = this.tabSection.width() - (this.tabSectionCanScroll ? 12 : 4);
            int height = 18;
            Dim2i tabDim = new Dim2i(x, y, width, height);
            FlatButtonWidget button = new FlatButtonWidget(tabDim, tab.getText(), () -> this.setTab(tab));
            button.setSelected(this.selectedTab == tab);
            this.children.add(button);
            offsetY += 18;
        }
    }

    private void rebuildTabFrame() {
        if (this.selectedTab == null) {
            return;
        }
        Object frame = this.selectedTab.getFrame();
        if (frame != null) {
            ((AbstractFrame)((Object)frame)).buildFrame();
            this.children.add(frame);
        }
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final List<Function<Dim2i, Tab<?>>> functions = new ArrayList();
        private boolean renderOutline = false;
        private Dim2i dim = null;

        public Builder setDimension(Dim2i dim) {
            this.dim = dim;
            return this;
        }

        public Builder shouldRenderOutline(boolean state) {
            this.renderOutline = state;
            return this;
        }

        public Builder addTab(Function<Dim2i, Tab<?>> function) {
            this.functions.add(function);
            return this;
        }

        public Builder addTabs(List<Function<Dim2i, Tab<?>>> functions) {
            this.functions.addAll(functions);
            return this;
        }

        public Builder addTabs(Consumer<List<Function<Dim2i, Tab<?>>>> tabs) {
            tabs.accept(this.functions);
            return this;
        }

        public TabFrame build() {
            Validate.notNull((Object)this.dim, (String)"Dimension must be specified", (Object[])new Object[0]);
            return new TabFrame(this.dim, this.functions, this.renderOutline);
        }
    }
}

