/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.reeses_sodium_options.client.gui.frame.components;

import me.jellysquid.mods.sodium.client.gui.widgets.AbstractWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;

public class ScrollBarComponent
extends AbstractWidget {
    protected final Dim2i dim;
    private final Mode mode;
    private final int frameLength;
    private final int viewPortLength;
    private final int maxScrollBarOffset;
    private final Runnable onSetOffset;
    private int offset = 0;
    private Dim2i scrollThumb = null;
    private int scrollThumbClickOffset = -1;
    private Dim2i extendedScrollArea = null;

    public ScrollBarComponent(Dim2i scrollBarArea, Mode mode, int frameLength, int viewPortLength, Runnable onSetOffset) {
        this.dim = scrollBarArea;
        this.mode = mode;
        this.frameLength = frameLength;
        this.viewPortLength = viewPortLength;
        this.onSetOffset = onSetOffset;
        this.maxScrollBarOffset = this.frameLength - this.viewPortLength;
    }

    public ScrollBarComponent(Dim2i scrollBarArea, Mode mode, int frameLength, int viewPortLength, Runnable onSetOffset, Dim2i extendedScrollArea) {
        this.dim = scrollBarArea;
        this.mode = mode;
        this.frameLength = frameLength;
        this.viewPortLength = viewPortLength;
        this.extendedScrollArea = extendedScrollArea;
        this.onSetOffset = onSetOffset;
        this.maxScrollBarOffset = this.frameLength - this.viewPortLength;
    }

    public void updateThumbPosition() {
        int scrollThumbLength = this.viewPortLength * (this.mode == Mode.VERTICAL ? this.dim.height() : this.dim.width() - 6) / this.frameLength;
        int maximumScrollThumbOffset = this.viewPortLength - scrollThumbLength;
        int scrollThumbOffset = this.offset * maximumScrollThumbOffset / this.maxScrollBarOffset;
        this.scrollThumb = new Dim2i(this.dim.x() + 2 + (this.mode == Mode.HORIZONTAL ? scrollThumbOffset : 0), this.dim.y() + 2 + (this.mode == Mode.VERTICAL ? scrollThumbOffset : 0), (this.mode == Mode.VERTICAL ? this.dim.width() : scrollThumbLength) - 4, (this.mode == Mode.VERTICAL ? scrollThumbLength : this.dim.height()) - 4);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.drawRectOutline(this.dim.x(), this.dim.y(), this.dim.getLimitX(), this.dim.getLimitY(), -5592406);
        this.drawRect(this.scrollThumb.x(), this.scrollThumb.y(), this.scrollThumb.getLimitX(), this.scrollThumb.getLimitY(), -5592406);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.dim.containsCursor(mouseX, mouseY)) {
            if (this.scrollThumb.containsCursor(mouseX, mouseY)) {
                this.scrollThumbClickOffset = this.mode == Mode.VERTICAL ? (int)mouseY - this.scrollThumb.y() : (int)mouseX - this.scrollThumb.x();
            } else {
                int value = this.mode == Mode.VERTICAL ? (int)mouseY - this.dim.y() : (int)mouseX - this.dim.x();
                this.setOffset(value);
            }
            return true;
        }
        this.scrollThumbClickOffset = -1;
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrollThumbClickOffset > -1) {
            int value = this.mode == Mode.VERTICAL ? (int)mouseY - this.scrollThumbClickOffset : (int)mouseX - this.scrollThumbClickOffset;
            this.setOffset(value);
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if ((this.dim.containsCursor(mouseX, mouseY) || this.extendedScrollArea != null && this.extendedScrollArea.containsCursor(mouseX, mouseY)) && this.offset <= this.maxScrollBarOffset && this.offset >= 0) {
            int value = (int)((double)this.offset - amount * 6.0);
            this.setOffset(value);
            return true;
        }
        return false;
    }

    private void setOffset(int value) {
        this.offset = class_3532.method_15340((int)value, (int)0, (int)this.maxScrollBarOffset);
        this.updateThumbPosition();
        this.onSetOffset.run();
    }

    public int getOffset() {
        return this.offset;
    }

    protected void drawRectOutline(double x, double y, double w, double h, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        this.drawQuads(vertices -> {
            ScrollBarComponent.addQuad((class_4588)vertices, (double)x, (double)y, (double)w, (double)(y + 1.0), (float)a, (float)r, (float)g, (float)b);
            ScrollBarComponent.addQuad((class_4588)vertices, (double)x, (double)(h - 1.0), (double)w, (double)h, (float)a, (float)r, (float)g, (float)b);
            ScrollBarComponent.addQuad((class_4588)vertices, (double)x, (double)y, (double)(x + 1.0), (double)h, (float)a, (float)r, (float)g, (float)b);
            ScrollBarComponent.addQuad((class_4588)vertices, (double)(w - 1.0), (double)y, (double)w, (double)h, (float)a, (float)r, (float)g, (float)b);
        });
    }

    public static enum Mode {
        HORIZONTAL,
        VERTICAL;

    }
}

