/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.reeses_sodium_options.client.gui;

import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlValueFormatter;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_768;

public class SliderControlElement
extends ControlElement<Integer> {
    private static final int THUMB_WIDTH = 2;
    private static final int TRACK_HEIGHT = 1;
    private final class_768 sliderBounds;
    private final ControlValueFormatter formatter;
    private final int min;
    private final int max;
    private final int range;
    private final int interval;
    private double thumbPosition;

    public SliderControlElement(Option<Integer> option, Dim2i dim, int min, int max, int interval, ControlValueFormatter formatter) {
        super(option, dim);
        this.min = min;
        this.max = max;
        this.range = max - min;
        this.interval = interval;
        this.thumbPosition = this.getThumbPositionForValue((Integer)option.getValue());
        this.formatter = formatter;
        this.sliderBounds = new class_768(dim.getLimitX() - 96, dim.getCenterY() - 5, 90, 10);
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float delta) {
        super.method_25394(matrixStack, mouseX, mouseY, delta);
        if (this.option.isAvailable() && this.hovered) {
            this.renderSlider(matrixStack);
        } else {
            this.renderStandaloneValue(matrixStack);
        }
    }

    private void renderStandaloneValue(class_4587 matrixStack) {
        int sliderX = this.sliderBounds.method_3321();
        int sliderY = this.sliderBounds.method_3322();
        int sliderWidth = this.sliderBounds.method_3319();
        int sliderHeight = this.sliderBounds.method_3320();
        String label = this.formatter.format(((Integer)this.option.getValue()).intValue());
        int labelWidth = this.font.method_1727(label);
        this.drawString(matrixStack, label, sliderX + sliderWidth - labelWidth, sliderY + sliderHeight / 2 - 4, -1);
    }

    private void renderSlider(class_4587 matrixStack) {
        int sliderX = this.sliderBounds.method_3321();
        int sliderY = this.sliderBounds.method_3322();
        int sliderWidth = this.sliderBounds.method_3319();
        int sliderHeight = this.sliderBounds.method_3320();
        this.thumbPosition = this.getThumbPositionForValue((Integer)this.option.getValue());
        double thumbOffset = class_3532.method_15350((double)((double)(this.getIntValue() - this.min) / (double)this.range * (double)sliderWidth), (double)0.0, (double)sliderWidth);
        double thumbX = (double)sliderX + thumbOffset - 2.0;
        double trackY = (double)sliderY + (double)sliderHeight / 2.0 - 0.5;
        this.drawRect(thumbX, sliderY, thumbX + 4.0, sliderY + sliderHeight, -1);
        this.drawRect(sliderX, trackY, sliderX + sliderWidth, trackY + 1.0, -1);
        String label = String.valueOf(this.getIntValue());
        int labelWidth = this.font.method_1727(label);
        this.drawString(matrixStack, label, sliderX - labelWidth - 6, sliderY + sliderHeight / 2 - 4, -1);
    }

    public int getIntValue() {
        return this.min + this.interval * (int)Math.round(this.getSnappedThumbPosition() / (double)this.interval);
    }

    public double getSnappedThumbPosition() {
        return this.thumbPosition / (1.0 / (double)this.range);
    }

    public double getThumbPositionForValue(int value) {
        return (double)(value - this.min) * (1.0 / (double)this.range);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.option.isAvailable() && button == 0 && this.sliderBounds.method_3318((int)mouseX, (int)mouseY)) {
            this.setValueFromMouse(mouseX);
            return true;
        }
        return false;
    }

    private void setValueFromMouse(double d) {
        this.setValue((d - (double)(this.sliderBounds.method_3321() + 4)) / (double)(this.sliderBounds.method_3319() - 8));
    }

    private void setValueFromMouseScroll(double amount) {
        if ((Integer)this.option.getValue() + this.interval * (int)amount <= this.max && (Integer)this.option.getValue() + this.interval * (int)amount >= this.min) {
            this.option.setValue((Object)((Integer)this.option.getValue() + this.interval * (int)amount));
            this.thumbPosition = this.getThumbPositionForValue((Integer)this.option.getValue());
        }
    }

    private void setValue(double d) {
        this.thumbPosition = class_3532.method_15350((double)d, (double)0.0, (double)1.0);
        int value = this.getIntValue();
        if ((Integer)this.option.getValue() != value) {
            this.option.setValue((Object)value);
        }
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.option.isAvailable() && button == 0) {
            this.setValueFromMouse(mouseX);
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.option.isAvailable() && this.sliderBounds.method_3318((int)mouseX, (int)mouseY) && class_437.method_25442()) {
            this.setValueFromMouseScroll(amount);
            return true;
        }
        return false;
    }
}

