/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.class_1767;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2521;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4917;
import net.minecraft.class_4918;
import net.minecraft.class_4922;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.AlfPortalState;
import vazkii.botania.api.state.enums.CratePattern;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.BlockAltGrass;
import vazkii.botania.common.block.BlockAltar;
import vazkii.botania.common.block.BlockModDoubleFlower;
import vazkii.botania.common.block.BlockModFlower;
import vazkii.botania.common.block.BlockSpecialFlower;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.block.decor.BlockBuriedPetals;
import vazkii.botania.common.block.decor.BlockFloatingFlower;
import vazkii.botania.common.block.decor.BlockModMushroom;
import vazkii.botania.common.block.decor.BlockMotifFlower;
import vazkii.botania.common.block.decor.BlockPetalBlock;
import vazkii.botania.common.block.decor.panes.BlockModPane;
import vazkii.botania.common.block.string.BlockRedString;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.mixin.AccessorBlockModelGenerators;
import vazkii.botania.mixin.AccessorTextureSlot;

public class BlockstateProvider
implements class_2405 {
    private final class_2403 generator;
    private final List<class_4917> blockstates = new ArrayList<class_4917>();
    private final Map<class_2960, Supplier<JsonElement>> models = new HashMap<class_2960, Supplier<JsonElement>>();
    private final BiConsumer<class_2960, Supplier<JsonElement>> modelOutput = this.models::put;

    public BlockstateProvider(class_2403 generator) {
        this.generator = generator;
    }

    @Nonnull
    public String method_10321() {
        return "Botania Blockstates and Models";
    }

    public void method_10319(class_2408 hashCache) throws IOException {
        Path path;
        try {
            this.registerStatesAndModels();
        }
        catch (Exception e) {
            Botania.LOGGER.error("Error registering states and models", (Throwable)e);
        }
        Path root = this.generator.method_10313();
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        for (class_4917 class_49172 : this.blockstates) {
            class_2960 id = class_2378.field_11146.method_10221((Object)class_49172.method_25743());
            path = root.resolve("assets/" + id.method_12836() + "/blockstates/" + id.method_12832() + ".json");
            try {
                class_2405.method_10320((Gson)gson, (class_2408)hashCache, (JsonElement)((JsonElement)class_49172.get()), (Path)path);
            }
            catch (IOException ex) {
                Botania.LOGGER.error("Error generating blockstate file for {}", (Object)id, (Object)ex);
            }
        }
        for (Map.Entry entry : this.models.entrySet()) {
            class_2960 modelId = (class_2960)entry.getKey();
            path = root.resolve("assets/" + modelId.method_12836() + "/models/" + modelId.method_12832() + ".json");
            try {
                class_2405.method_10320((Gson)gson, (class_2408)hashCache, (JsonElement)((JsonElement)((Supplier)entry.getValue()).get()), (Path)path);
            }
            catch (IOException ex) {
                Botania.LOGGER.error("Error generating model file {}", (Object)modelId, (Object)ex);
            }
        }
    }

    private void registerStatesAndModels() {
        Set<class_2248> remainingBlocks = class_2378.field_11146.method_10220().filter(b -> "botania".equals(class_2378.field_11146.method_10221(b).method_12836())).collect(Collectors.toSet());
        remainingBlocks.remove(ModBlocks.ghostRail);
        remainingBlocks.remove(ModBlocks.solidVines);
        this.manualModel(remainingBlocks, ModBlocks.cocoon);
        this.manualModel(remainingBlocks, ModBlocks.corporeaCrystalCube);
        this.manualModel(remainingBlocks, ModBlocks.distributor);
        this.manualModel(remainingBlocks, ModBlocks.prism);
        this.manualModel(remainingBlocks, ModBlocks.runeAltar);
        this.manualModel(remainingBlocks, ModBlocks.spawnerClaw);
        class_2960 alfPortalModel = class_4943.field_22972.method_25852(class_4941.method_25842((class_2248)ModBlocks.alfPortal), class_4944.method_25864((class_2248)ModBlocks.alfPortal), this.modelOutput);
        class_2960 alfPortalActivatedModel = class_4943.field_22972.method_25852(class_4941.method_25843((class_2248)ModBlocks.alfPortal, (String)"_activated"), class_4944.method_25875((class_2960)class_4941.method_25843((class_2248)ModBlocks.alfPortal, (String)"_activated")), this.modelOutput);
        this.blockstates.add((class_4917)class_4925.method_25769((class_2248)ModBlocks.alfPortal).method_25775((class_4926)class_4926.method_25783(BotaniaStateProps.ALFPORTAL_STATE).method_25793((Comparable)((Object)AlfPortalState.OFF), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)alfPortalModel)).method_25793((Comparable)((Object)AlfPortalState.ON_X), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)alfPortalActivatedModel)).method_25793((Comparable)((Object)AlfPortalState.ON_Z), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)alfPortalActivatedModel))));
        remainingBlocks.remove(ModBlocks.alfPortal);
        this.singleVariantBlockState(ModBlocks.bifrostPerm, class_4943.field_22972.method_25852(class_4941.method_25842((class_2248)ModBlocks.bifrostPerm), class_4944.method_25864((class_2248)ModBlocks.bifrost), this.modelOutput));
        remainingBlocks.remove(ModBlocks.bifrostPerm);
        this.singleVariantBlockState(ModBlocks.cacophonium, class_4943.field_22976.method_25846(ModBlocks.cacophonium, new class_4944().method_25868(class_4945.field_23018, class_4944.method_25860((class_2248)class_2246.field_10179)).method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)ModBlocks.cacophonium, (String)"_top")), this.modelOutput));
        remainingBlocks.remove(ModBlocks.cacophonium);
        class_4942 crateTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/crate")), Optional.empty(), new class_4945[]{class_4945.field_23014, class_4945.field_23018});
        class_2960 craftCrateBottomTex = class_4944.method_25866((class_2248)ModBlocks.craftCrate, (String)"_bottom");
        class_4926.class_4927 crateDispatch = class_4926.method_25783(BotaniaStateProps.CRATE_PATTERN);
        for (CratePattern pattern : CratePattern.values()) {
            String suffix = pattern == CratePattern.NONE ? "" : "_" + pattern.method_15434().substring("crafty_".length());
            class_2960 model = crateTemplate.method_25852(class_4941.method_25843((class_2248)ModBlocks.craftCrate, (String)suffix), new class_4944().method_25868(class_4945.field_23014, craftCrateBottomTex).method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)ModBlocks.craftCrate, (String)suffix)), this.modelOutput);
            crateDispatch = crateDispatch.method_25793((Comparable)((Object)pattern), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model));
        }
        this.blockstates.add((class_4917)class_4925.method_25769((class_2248)ModBlocks.craftCrate).method_25775((class_4926)crateDispatch));
        remainingBlocks.remove(ModBlocks.craftCrate);
        class_2960 corpSlabSide = ResourceLocationHelper.prefix("block/corporea_slab_side");
        class_2960 corpBlock = class_4944.method_25860((class_2248)ModBlocks.corporeaBlock);
        class_2960 corpSlabBottomModel = class_4943.field_22909.method_25846((class_2248)ModBlocks.corporeaSlab, new class_4944().method_25868(class_4945.field_23014, corpBlock).method_25868(class_4945.field_23015, corpBlock).method_25868(class_4945.field_23018, corpBlock), this.modelOutput);
        class_2960 corpSlabTopModel = class_4943.field_22910.method_25852(class_4941.method_25843((class_2248)ModBlocks.corporeaSlab, (String)"_top"), new class_4944().method_25868(class_4945.field_23014, corpBlock).method_25868(class_4945.field_23015, corpBlock).method_25868(class_4945.field_23018, corpBlock), this.modelOutput);
        class_2960 corpSlabDoubleModel = class_4943.field_22977.method_25852(ResourceLocationHelper.prefix("block/corporea_double_slab"), new class_4944().method_25868(class_4945.field_23018, corpSlabSide).method_25868(class_4945.field_23014, corpBlock).method_25868(class_4945.field_23015, corpBlock), this.modelOutput);
        this.blockstates.add(AccessorBlockModelGenerators.makeSlabState((class_2248)ModBlocks.corporeaSlab, corpSlabBottomModel, corpSlabTopModel, corpSlabDoubleModel));
        remainingBlocks.remove(ModBlocks.corporeaSlab);
        this.stairsBlock((class_2248)ModBlocks.corporeaStairs, corpBlock, corpBlock, corpBlock);
        remainingBlocks.remove(ModBlocks.corporeaStairs);
        this.wallBlock(ModBlocks.corporeaBrickWall, class_4944.method_25860((class_2248)ModBlocks.corporeaBrick));
        remainingBlocks.remove(ModBlocks.corporeaBrickWall);
        this.blockstates.add((class_4917)class_4925.method_25771((class_2248)ModBlocks.elfGlass, (class_4935[])((class_4935[])IntStream.rangeClosed(0, 3).mapToObj(i -> {
            class_2960 model = class_4943.field_22972.method_25852(class_4941.method_25843((class_2248)ModBlocks.elfGlass, (String)("_" + i)), class_4944.method_25875((class_2960)class_4944.method_25866((class_2248)ModBlocks.elfGlass, (String)("_" + i))), this.modelOutput);
            return class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model);
        }).toArray(class_4935[]::new))));
        remainingBlocks.remove(ModBlocks.elfGlass);
        this.singleVariantBlockState(ModBlocks.enchantedSoil, class_4943.field_22977.method_25846(ModBlocks.enchantedSoil, class_4944.method_25898((class_2248)ModBlocks.enchantedSoil).method_25868(class_4945.field_23014, class_4944.method_25860((class_2248)class_2246.field_10566)), this.modelOutput));
        remainingBlocks.remove(ModBlocks.enchantedSoil);
        class_2960 pumpkinModel = class_4943.field_22978.method_25846(ModBlocks.felPumpkin, new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)class_2246.field_10261, (String)"_side")).method_25868(class_4945.field_23016, class_4944.method_25860((class_2248)ModBlocks.felPumpkin)).method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)class_2246.field_10261, (String)"_top")), this.modelOutput);
        this.blockstates.add((class_4917)class_4925.method_25770((class_2248)ModBlocks.felPumpkin, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)pumpkinModel)).method_25775(AccessorBlockModelGenerators.horizontalDispatch()));
        remainingBlocks.remove(ModBlocks.felPumpkin);
        class_4942 eightByEightTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/eightbyeight")), Optional.empty(), new class_4945[]{class_4945.field_23014, class_4945.field_23015, class_4945.field_23019, class_4945.field_23020, class_4945.field_23022, class_4945.field_23021});
        this.singleVariantBlockState(ModBlocks.forestEye, eightByEightTemplate.method_25846(ModBlocks.forestEye, new class_4944().method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)ModBlocks.forestEye, (String)"_bottom")).method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)ModBlocks.forestEye, (String)"_top")).method_25868(class_4945.field_23019, class_4944.method_25866((class_2248)ModBlocks.forestEye, (String)"_north")).method_25868(class_4945.field_23020, class_4944.method_25866((class_2248)ModBlocks.forestEye, (String)"_south")).method_25868(class_4945.field_23022, class_4944.method_25866((class_2248)ModBlocks.forestEye, (String)"_west")).method_25868(class_4945.field_23021, class_4944.method_25866((class_2248)ModBlocks.forestEye, (String)"_east")), this.modelOutput));
        remainingBlocks.remove(ModBlocks.forestEye);
        class_2960 plateFile = class_4941.method_25842((class_2248)ModBlocks.incensePlate);
        this.blockstates.add((class_4917)class_4925.method_25770((class_2248)ModBlocks.incensePlate, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)plateFile)).method_25775(AccessorBlockModelGenerators.horizontalDispatch()));
        remainingBlocks.remove(ModBlocks.incensePlate);
        class_4942 fourHighBottomTopTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/four_high_bottom_top")), Optional.empty(), new class_4945[]{class_4945.field_23014, class_4945.field_23015, class_4945.field_23018});
        this.singleVariantBlockState(ModBlocks.lightLauncher, fourHighBottomTopTemplate.method_25846(ModBlocks.lightLauncher, new class_4944().method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)ModBlocks.lightLauncher, (String)"_end")).method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)ModBlocks.lightLauncher, (String)"_end")).method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)ModBlocks.lightLauncher, (String)"_side")), this.modelOutput));
        remainingBlocks.remove(ModBlocks.lightLauncher);
        this.singleVariantBlockState(ModBlocks.openCrate, crateTemplate.method_25846(ModBlocks.openCrate, new class_4944().method_25868(class_4945.field_23018, class_4944.method_25860((class_2248)ModBlocks.openCrate)).method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)ModBlocks.openCrate, (String)"_bottom")), this.modelOutput));
        remainingBlocks.remove(ModBlocks.openCrate);
        class_4942 threeHighBottomTopTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/three_high_bottom_top")), Optional.empty(), new class_4945[]{class_4945.field_23014, class_4945.field_23015, class_4945.field_23018});
        this.singleVariantBlockState(ModBlocks.sparkChanger, threeHighBottomTopTemplate.method_25846(ModBlocks.sparkChanger, class_4944.method_25898((class_2248)ModBlocks.sparkChanger), this.modelOutput));
        remainingBlocks.remove(ModBlocks.sparkChanger);
        this.singleVariantBlockState(ModBlocks.starfield, fourHighBottomTopTemplate.method_25846(ModBlocks.starfield, class_4944.method_25898((class_2248)ModBlocks.starfield), this.modelOutput));
        remainingBlocks.remove(ModBlocks.starfield);
        this.singleVariantBlockState(ModBlocks.terraPlate, threeHighBottomTopTemplate.method_25846(ModBlocks.terraPlate, class_4944.method_25898((class_2248)ModBlocks.terraPlate), this.modelOutput));
        remainingBlocks.remove(ModBlocks.terraPlate);
        class_4942 tenByTenAllTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/tenbyten_all")), Optional.empty(), new class_4945[]{class_4945.field_23010});
        this.singleVariantBlockState(ModBlocks.tinyPlanet, tenByTenAllTemplate.method_25846(ModBlocks.tinyPlanet, class_4944.method_25864((class_2248)ModBlocks.tinyPlanet), this.modelOutput));
        remainingBlocks.remove(ModBlocks.tinyPlanet);
        this.singleVariantBlockState(ModBlocks.turntable, class_4943.field_22977.method_25846(ModBlocks.turntable, class_4944.method_25898((class_2248)ModBlocks.turntable), this.modelOutput));
        remainingBlocks.remove(ModBlocks.turntable);
        this.wallBlock(ModFluffBlocks.dreamwoodWall, class_4944.method_25860((class_2248)ModBlocks.dreamwood));
        this.wallBlock(ModFluffBlocks.livingrockWall, class_4944.method_25860((class_2248)ModBlocks.livingrock));
        this.wallBlock(ModFluffBlocks.livingrockBrickWall, class_4944.method_25860((class_2248)ModBlocks.livingrockBrick));
        this.wallBlock(ModFluffBlocks.livingrockBrickMossyWall, class_4944.method_25860((class_2248)ModBlocks.livingrockBrickMossy));
        this.wallBlock(ModFluffBlocks.livingwoodWall, class_4944.method_25860((class_2248)ModBlocks.livingwood));
        remainingBlocks.remove(ModFluffBlocks.dreamwoodWall);
        remainingBlocks.remove(ModFluffBlocks.livingrockWall);
        remainingBlocks.remove(ModFluffBlocks.livingrockBrickWall);
        remainingBlocks.remove(ModFluffBlocks.livingrockBrickMossyWall);
        remainingBlocks.remove(ModFluffBlocks.livingwoodWall);
        this.fenceBlock(ModFluffBlocks.dreamwoodFence, class_4944.method_25860((class_2248)ModBlocks.dreamwoodPlanks));
        this.fenceGateBlock(ModFluffBlocks.dreamwoodFenceGate, class_4944.method_25860((class_2248)ModBlocks.dreamwoodPlanks));
        this.fenceBlock(ModFluffBlocks.livingwoodFence, class_4944.method_25860((class_2248)ModBlocks.livingwoodPlanks));
        this.fenceGateBlock(ModFluffBlocks.livingwoodFenceGate, class_4944.method_25860((class_2248)ModBlocks.livingwoodPlanks));
        remainingBlocks.remove(ModFluffBlocks.dreamwoodFence);
        remainingBlocks.remove(ModFluffBlocks.dreamwoodFenceGate);
        remainingBlocks.remove(ModFluffBlocks.livingwoodFence);
        remainingBlocks.remove(ModFluffBlocks.livingwoodFenceGate);
        this.particleOnly(remainingBlocks, ModBlocks.animatedTorch, class_4944.method_25860((class_2248)class_2246.field_10523));
        this.particleOnly(remainingBlocks, ModBlocks.avatar, class_4944.method_25860((class_2248)ModBlocks.livingwood));
        this.particleOnly(remainingBlocks, ModBlocks.bellows, class_4944.method_25860((class_2248)ModBlocks.livingwood));
        this.particleOnly(remainingBlocks, ModBlocks.brewery, class_4944.method_25860((class_2248)ModBlocks.livingrock));
        this.particleOnly(remainingBlocks, ModBlocks.corporeaIndex, class_4944.method_25860((class_2248)ModBlocks.corporeaBlock));
        this.particleOnly(remainingBlocks, ModBlocks.lightRelayDetector, class_4944.method_25860((class_2248)ModBlocks.lightRelayDetector));
        this.singleVariantBlockState(ModBlocks.fakeAir, new class_4942(Optional.empty(), Optional.empty(), new class_4945[0]).method_25846(ModBlocks.fakeAir, new class_4944(), this.modelOutput));
        remainingBlocks.remove(ModBlocks.fakeAir);
        this.particleOnly(remainingBlocks, ModBlocks.lightRelayFork, class_4944.method_25860((class_2248)ModBlocks.lightRelayFork));
        this.particleOnly(remainingBlocks, ModBlocks.gaiaHead, class_4944.method_25860((class_2248)class_2246.field_10114));
        this.particleOnly(remainingBlocks, ModBlocks.gaiaHeadWall, class_4944.method_25860((class_2248)class_2246.field_10114));
        this.particleOnly(remainingBlocks, ModBlocks.gaiaPylon, class_4944.method_25860((class_2248)ModBlocks.elementiumBlock));
        this.particleOnly(remainingBlocks, ModBlocks.hourglass, class_4944.method_25860((class_2248)ModBlocks.manaGlass));
        this.particleOnly(remainingBlocks, ModBlocks.lightRelayDefault, class_4944.method_25860((class_2248)ModBlocks.lightRelayDefault));
        this.particleOnly(remainingBlocks, ModBlocks.manaFlame, new class_2960("block/fire_0"));
        this.particleOnly(remainingBlocks, ModBlocks.manaPylon, class_4944.method_25860((class_2248)ModBlocks.manasteelBlock));
        this.particleOnly(remainingBlocks, ModBlocks.naturaPylon, class_4944.method_25860((class_2248)ModBlocks.terrasteelBlock));
        this.particleOnly(remainingBlocks, ModBlocks.teruTeruBozu, class_4944.method_25860((class_2248)class_2246.field_10446));
        this.particleOnly(remainingBlocks, ModBlocks.lightRelayToggle, class_4944.method_25860((class_2248)ModBlocks.lightRelayToggle));
        Predicate<class_2248> flowers = b -> b instanceof BlockSpecialFlower || b instanceof BlockModMushroom || b instanceof BlockModFlower;
        class_4942 crossTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/cross")), Optional.empty(), new class_4945[]{class_4945.field_23025});
        BlockstateProvider.takeAll(remainingBlocks, flowers).forEach(b -> this.singleVariantBlockState((class_2248)b, crossTemplate.method_25846(b, class_4944.method_25877((class_2248)b), this.modelOutput)));
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockMotifFlower).forEach(b -> {
            String name = class_2378.field_11146.method_10221(b).method_12832().replace("_motif", "");
            this.singleVariantBlockState((class_2248)b, crossTemplate.method_25846(b, new class_4944().method_25868(class_4945.field_23025, ResourceLocationHelper.prefix("block/" + name)), this.modelOutput));
        });
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.corporeaFunnel, ModBlocks.corporeaInterceptor, ModBlocks.corporeaRetainer).forEach(b -> this.singleVariantBlockState((class_2248)b, class_4943.field_22974.method_25846(b, class_4944.method_25870((class_2960)class_4944.method_25866((class_2248)b, (String)"_side"), (class_2960)class_4944.method_25866((class_2248)b, (String)"_end")), this.modelOutput)));
        class_4942 drumModelTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/drum")), Optional.empty(), new class_4945[]{class_4945.field_23015, class_4945.field_23018});
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.gatheringDrum, ModBlocks.canopyDrum, ModBlocks.wildDrum).forEach(b -> this.singleVariantBlockState((class_2248)b, drumModelTemplate.method_25846(b, new class_4944().method_25868(class_4945.field_23015, ResourceLocationHelper.prefix("block/drum_top")).method_25868(class_4945.field_23018, class_4944.method_25860((class_2248)b)), this.modelOutput)));
        class_4945 materialSlot = AccessorTextureSlot.make("material");
        class_4945 insideSlot = AccessorTextureSlot.make("inside");
        class_4942 spreaderTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/spreader")), Optional.empty(), new class_4945[]{class_4945.field_23018, materialSlot});
        class_4942 spreaderInsideTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/spreader_inside")), Optional.of("_inside"), new class_4945[]{insideSlot});
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.manaSpreader, ModBlocks.redstoneSpreader, ModBlocks.gaiaSpreader, ModBlocks.elvenSpreader).forEach(b -> {
            class_2960 material = b == ModBlocks.elvenSpreader ? class_4944.method_25860((class_2248)ModBlocks.dreamwood) : (b == ModBlocks.gaiaSpreader ? class_4944.method_25866((class_2248)b, (String)"_material") : class_4944.method_25860((class_2248)ModBlocks.livingwood));
            this.singleVariantBlockState((class_2248)b, spreaderTemplate.method_25846(b, new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)b, (String)"_side")).method_25868(materialSlot, material), this.modelOutput));
            spreaderInsideTemplate.method_25846(b, new class_4944().method_25868(insideSlot, class_4944.method_25866((class_2248)b, (String)"_inside")), this.modelOutput);
        });
        class_4945 liquidSlot = AccessorTextureSlot.make("liquid");
        class_4942 poolTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/pool")), Optional.empty(), new class_4945[]{class_4945.field_23010});
        class_4942 poolFullTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/pool_full")), Optional.of("_full"), new class_4945[]{class_4945.field_23010, liquidSlot});
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.manaPool, ModBlocks.dilutedPool, ModBlocks.fabulousPool, ModBlocks.creativePool).forEach(b -> {
            class_2960 tex = b == ModBlocks.manaPool || b == ModBlocks.fabulousPool ? class_4944.method_25860((class_2248)ModBlocks.livingrock) : class_4944.method_25860((class_2248)b);
            poolFullTemplate.method_25846(b, class_4944.method_25875((class_2960)tex).method_25868(liquidSlot, ResourceLocationHelper.prefix("block/mana_water")), this.modelOutput);
            this.singleVariantBlockState((class_2248)b, poolTemplate.method_25846(b, class_4944.method_25875((class_2960)tex), this.modelOutput));
        });
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.pump, ModBlocks.tinyPotato).forEach(b -> this.blockstates.add((class_4917)class_4925.method_25770((class_2248)b, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4941.method_25842((class_2248)b))).method_25775(AccessorBlockModelGenerators.horizontalDispatch())));
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.enderEye, ModBlocks.manaDetector).forEach(b -> {
            class_2960 offModel = class_4943.field_22972.method_25846(b, class_4944.method_25864((class_2248)b), this.modelOutput);
            class_2960 onModel = class_4943.field_22972.method_25852(class_4941.method_25843((class_2248)b, (String)"_powered"), class_4944.method_25875((class_2960)class_4944.method_25866((class_2248)b, (String)"_powered")), this.modelOutput);
            this.blockstates.add((class_4917)class_4925.method_25769((class_2248)b).method_25775((class_4926)class_4926.method_25783((class_2769)class_2741.field_12484).method_25793((Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)offModel)).method_25793((Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)onModel))));
        });
        class_2960 petalBlockModel = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/cube_all_tinted")), Optional.empty(), new class_4945[]{class_4945.field_23010}).method_25852(ResourceLocationHelper.prefix("block/petal_block"), new class_4944().method_25868(class_4945.field_23010, ResourceLocationHelper.prefix("block/petal_block")), this.modelOutput);
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockPetalBlock).forEach(b -> this.singleVariantBlockState((class_2248)b, petalBlockModel));
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockAltGrass).forEach(b -> {
            class_2960 model = class_4943.field_22977.method_25846(b, new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)b, (String)"_side")).method_25868(class_4945.field_23014, class_4944.method_25860((class_2248)class_2246.field_10566)).method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)b, (String)"_top")), this.modelOutput);
            this.blockstates.add((class_4917)class_4925.method_25771((class_2248)b, (class_4935[])AccessorBlockModelGenerators.createRotatedVariants(model)));
        });
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockRedString).forEach(this::redStringBlock);
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockModDoubleFlower).forEach(b -> {
            class_2960 bottom = class_4943.field_22921.method_25846(b, class_4944.method_25877((class_2248)b), this.modelOutput);
            class_2960 top = class_4943.field_22921.method_25852(class_4941.method_25843((class_2248)b, (String)"_top"), class_4944.method_25880((class_2960)class_4944.method_25866((class_2248)b, (String)"_top")), this.modelOutput);
            this.blockstates.add((class_4917)class_4925.method_25769((class_2248)b).method_25775((class_4926)class_4926.method_25783((class_2769)class_2521.field_10929).method_25793((Comparable)class_2756.field_12607, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)bottom)).method_25793((Comparable)class_2756.field_12609, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)top))));
        });
        for (String variant : new String[]{"desert", "forest", "fungal", "mesa", "mountain", "plains", "swamp", "taiga"}) {
            class_2960 baseId = ResourceLocationHelper.prefix("metamorphic_" + variant + "_stone");
            class_2248 base = (class_2248)class_2378.field_11146.method_17966(baseId).get();
            this.cubeAll(base);
            class_2960 cobbleId = ResourceLocationHelper.prefix("metamorphic_" + variant + "_cobblestone");
            class_2248 cobble = (class_2248)class_2378.field_11146.method_17966(cobbleId).get();
            this.cubeAll(cobble);
            class_2960 cobbleWallId = ResourceLocationHelper.prefix("metamorphic_" + variant + "_cobblestone_wall");
            class_2248 cobbleWall = (class_2248)class_2378.field_11146.method_17966(cobbleWallId).get();
            this.wallBlock(cobbleWall, class_4944.method_25860((class_2248)cobble));
            class_2960 brickId = ResourceLocationHelper.prefix("metamorphic_" + variant + "_bricks");
            class_2248 brick = (class_2248)class_2378.field_11146.method_17966(brickId).get();
            this.cubeAll(brick);
            class_2960 brickWallId = ResourceLocationHelper.prefix("metamorphic_" + variant + "_bricks_wall");
            class_2248 brickWall = (class_2248)class_2378.field_11146.method_17966(brickWallId).get();
            this.wallBlock(brickWall, class_4944.method_25860((class_2248)brick));
            class_2960 chiseledBricksId = ResourceLocationHelper.prefix("chiseled_metamorphic_" + variant + "_bricks");
            class_2248 chiseledBricks = (class_2248)class_2378.field_11146.method_17966(chiseledBricksId).get();
            this.cubeAll(chiseledBricks);
            remainingBlocks.removeAll(Arrays.asList(base, cobble, cobbleWall, brick, brickWall, chiseledBricks));
        }
        for (String variant : new String[]{"dark", "mana", "blaze", "lavender", "red", "elf", "sunny"}) {
            class_2960 quartzId = ResourceLocationHelper.prefix(variant + "_quartz");
            class_2248 quartz = (class_2248)class_2378.field_11146.method_17966(quartzId).get();
            this.singleVariantBlockState(quartz, class_4943.field_22977.method_25846(quartz, class_4944.method_25898((class_2248)quartz), this.modelOutput));
            class_2960 pillarId = ResourceLocationHelper.prefix(variant + "_quartz_pillar");
            class_2248 pillar = (class_2248)class_2378.field_11146.method_17966(pillarId).get();
            class_2960 pillarModel = class_4943.field_22974.method_25846(pillar, class_4944.method_25870((class_2960)class_4944.method_25866((class_2248)pillar, (String)"_side"), (class_2960)class_4944.method_25866((class_2248)pillar, (String)"_end")), this.modelOutput);
            this.blockstates.add(AccessorBlockModelGenerators.createAxisAlignedPillarBlock(pillar, pillarModel));
            class_2960 chiseledId = ResourceLocationHelper.prefix("chiseled_" + variant + "_quartz");
            class_2248 chiseled = (class_2248)class_2378.field_11146.method_17966(chiseledId).get();
            this.singleVariantBlockState(chiseled, class_4943.field_22974.method_25846(chiseled, new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)chiseled, (String)"_side")).method_25868(class_4945.field_23013, class_4944.method_25866((class_2248)chiseled, (String)"_end")), this.modelOutput));
            remainingBlocks.remove(quartz);
            remainingBlocks.remove(pillar);
            remainingBlocks.remove(chiseled);
        }
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockBuriedPetals).forEach(b -> {
            class_1767 color = ((BlockBuriedPetals)b).color;
            class_2960 wool = new class_2960("block/" + color.method_15434() + "_wool");
            this.particleOnly(remainingBlocks, (class_2248)b, wool);
        });
        class_4945 gobletSlot = AccessorTextureSlot.make("goblet");
        class_4945 topBottomSlot = AccessorTextureSlot.make("top_bottom");
        class_4942 apothecaryTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/petal_apothecary")), Optional.empty(), new class_4945[]{class_4945.field_23018, gobletSlot, topBottomSlot});
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockAltar).forEach(b -> this.singleVariantBlockState((class_2248)b, apothecaryTemplate.method_25846(b, new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)b, (String)"_side")).method_25868(gobletSlot, class_4944.method_25866((class_2248)b, (String)"_goblet")).method_25868(topBottomSlot, class_4944.method_25866((class_2248)b, (String)"_top_bottom")), this.modelOutput)));
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockFloatingFlower).forEach(b -> this.singleVariantBlockState((class_2248)b, class_4941.method_25842((class_2248)b)));
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockModPane).forEach(b -> {
            String name = class_2378.field_11146.method_10221(b).method_12832();
            class_4944 mapping = new class_4944().method_25868(class_4945.field_23032, class_4944.method_25860((class_2248)b)).method_25868(class_4945.field_23031, ResourceLocationHelper.prefix("block/" + name.substring(0, name.length() - "_pane".length())));
            class_2960 postModel = class_4943.field_22953.method_25846(b, mapping, this.modelOutput);
            class_2960 sideModel = class_4943.field_22954.method_25846(b, mapping, this.modelOutput);
            class_2960 sideAltModel = class_4943.field_22955.method_25846(b, mapping, this.modelOutput);
            class_2960 noSideModel = class_4943.field_22951.method_25846(b, mapping, this.modelOutput);
            class_2960 noSideAltModel = class_4943.field_22952.method_25846(b, mapping, this.modelOutput);
            this.blockstates.add((class_4917)class_4922.method_25758((class_2248)b).method_25763(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)postModel)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)sideModel)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)sideModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)sideAltModel)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)sideAltModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)noSideModel)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)noSideAltModel)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)noSideAltModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)noSideModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)));
        });
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof class_2510).forEach(b -> {
            String name = class_2378.field_11146.method_10221(b).method_12832();
            String baseName = name.substring(0, name.length() - "_stairs".length());
            boolean quartz = name.contains("quartz");
            if (quartz) {
                class_2960 side = ResourceLocationHelper.prefix("block/" + baseName + "_side");
                class_2960 bottom = ResourceLocationHelper.prefix("block/" + baseName + "_bottom");
                class_2960 top = ResourceLocationHelper.prefix("block/" + baseName + "_top");
                this.stairsBlock((class_2248)b, side, bottom, top);
            } else {
                class_2960 tex = ResourceLocationHelper.prefix("block/" + baseName);
                this.stairsBlock((class_2248)b, tex, tex, tex);
            }
        });
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof class_2482).forEach(b -> {
            String name = class_2378.field_11146.method_10221(b).method_12832();
            String baseName = name.substring(0, name.length() - "_slab".length());
            class_2248 base = (class_2248)class_2378.field_11146.method_17966(ResourceLocationHelper.prefix(baseName)).get();
            boolean quartz = name.contains("quartz");
            if (quartz) {
                class_4944 mapping = new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)base, (String)"_side")).method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)base, (String)"_bottom")).method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)base, (String)"_top"));
                class_2960 bottomModel = class_4943.field_22909.method_25846(b, mapping, this.modelOutput);
                class_2960 topModel = class_4943.field_22910.method_25846(b, mapping, this.modelOutput);
                class_2960 doubleModel = class_4941.method_25842((class_2248)base);
                this.blockstates.add(AccessorBlockModelGenerators.makeSlabState(b, bottomModel, topModel, doubleModel));
            } else {
                class_2960 baseTex = class_4944.method_25860((class_2248)base);
                class_4944 mapping = new class_4944().method_25868(class_4945.field_23018, baseTex).method_25868(class_4945.field_23014, baseTex).method_25868(class_4945.field_23015, baseTex);
                class_2960 bottomModel = class_4943.field_22909.method_25846(b, mapping, this.modelOutput);
                class_2960 topModel = class_4943.field_22910.method_25846(b, mapping, this.modelOutput);
                class_2960 doubleModel = class_4941.method_25842((class_2248)base);
                this.blockstates.add(AccessorBlockModelGenerators.makeSlabState(b, bottomModel, topModel, doubleModel));
            }
        });
        remainingBlocks.forEach(this::cubeAll);
    }

    protected void particleOnly(Set<class_2248> blocks, class_2248 b, class_2960 particle) {
        this.singleVariantBlockState(b, class_4943.field_22908.method_25846(b, class_4944.method_25891((class_2960)particle), this.modelOutput));
        blocks.remove(b);
    }

    protected void manualModel(Set<class_2248> blocks, class_2248 b) {
        this.singleVariantBlockState(b, class_4941.method_25842((class_2248)b));
        blocks.remove(b);
    }

    private void stairsBlock(class_2248 block, class_2960 sideTex, class_2960 bottomTex, class_2960 topTex) {
        class_4944 mapping = new class_4944().method_25868(class_4945.field_23018, sideTex).method_25868(class_4945.field_23014, bottomTex).method_25868(class_4945.field_23015, topTex);
        class_2960 insideModel = class_4943.field_22913.method_25846(block, mapping, this.modelOutput);
        class_2960 straightModel = class_4943.field_22912.method_25846(block, mapping, this.modelOutput);
        class_2960 outsideModel = class_4943.field_22914.method_25846(block, mapping, this.modelOutput);
        this.blockstates.add(AccessorBlockModelGenerators.makeStairState(block, insideModel, straightModel, outsideModel));
    }

    private void fenceBlock(class_2248 block, class_2960 tex) {
        class_4944 mapping = class_4944.method_25869((class_2960)tex);
        class_2960 postModel = class_4943.field_22988.method_25846(block, mapping, this.modelOutput);
        class_2960 sideModel = class_4943.field_22989.method_25846(block, mapping, this.modelOutput);
        this.blockstates.add(AccessorBlockModelGenerators.makeFenceState(block, postModel, sideModel));
    }

    private void fenceGateBlock(class_2248 block, class_2960 tex) {
        class_4944 mapping = class_4944.method_25869((class_2960)tex);
        class_2960 openModel = class_4943.field_22996.method_25846(block, mapping, this.modelOutput);
        class_2960 closedModel = class_4943.field_22995.method_25846(block, mapping, this.modelOutput);
        class_2960 openWallModel = class_4943.field_22905.method_25846(block, mapping, this.modelOutput);
        class_2960 closedWallModel = class_4943.field_22904.method_25846(block, mapping, this.modelOutput);
        this.blockstates.add(AccessorBlockModelGenerators.makeFenceGateState(block, openModel, closedModel, openWallModel, closedWallModel));
    }

    private void cubeAll(class_2248 b) {
        class_2960 model = class_4943.field_22972.method_25846(b, class_4944.method_25864((class_2248)b), this.modelOutput);
        this.singleVariantBlockState(b, model);
    }

    private void singleVariantBlockState(class_2248 b, class_2960 model) {
        this.blockstates.add((class_4917)class_4925.method_25770((class_2248)b, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model)));
    }

    @SafeVarargs
    public static <T> Collection<T> takeAll(Set<? extends T> src, T ... items) {
        List<T> ret = Arrays.asList(items);
        for (T item : items) {
            if (src.contains(item)) continue;
            Botania.LOGGER.warn("Item {} not found in set", item);
        }
        if (!src.removeAll(ret)) {
            Botania.LOGGER.warn("takeAll array didn't yield anything ({})", (Object)Arrays.toString(items));
        }
        return ret;
    }

    public static <T> Collection<T> takeAll(Set<T> src, Predicate<T> pred) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iter = src.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            if (!pred.test(item)) continue;
            iter.remove();
            ret.add(item);
        }
        if (ret.isEmpty()) {
            Botania.LOGGER.warn("takeAll predicate yielded nothing", new Throwable());
        }
        return ret;
    }

    protected void wallBlock(class_2248 block, class_2960 tex) {
        class_4944 mapping = new class_4944().method_25868(class_4945.field_23027, tex);
        class_2960 postModel = class_4943.field_22991.method_25846(block, mapping, this.modelOutput);
        class_2960 lowModel = class_4943.field_22992.method_25846(block, mapping, this.modelOutput);
        class_2960 tallModel = class_4943.field_22993.method_25846(block, mapping, this.modelOutput);
        this.blockstates.add(AccessorBlockModelGenerators.makeWallState(block, postModel, lowModel, tallModel));
    }

    protected void redStringBlock(class_2248 b) {
        class_2960 selfName = class_4944.method_25860((class_2248)b);
        class_2960 front = ResourceLocationHelper.prefix("block/red_string_sender");
        class_2960 model = class_4943.field_22978.method_25846(b, new class_4944().method_25868(class_4945.field_23015, selfName).method_25868(class_4945.field_23016, front).method_25868(class_4945.field_23018, selfName), this.modelOutput);
        this.blockstates.add((class_4917)class_4925.method_25770((class_2248)b, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model)).method_25775(AccessorBlockModelGenerators.facingDispatch()));
    }
}

