/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.terrasteel;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.item.v1.FabricItem;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_5632;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.ISequentialBreaker;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.item.ItemTemperanceStone;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.equipment.tool.manasteel.ItemManasteelPick;
import vazkii.botania.common.item.relic.ItemThorRing;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class ItemTerraPick
extends ItemManasteelPick
implements IManaItem,
ISequentialBreaker,
FabricItem {
    private static final String TAG_ENABLED = "enabled";
    private static final String TAG_MANA = "mana";
    private static final String TAG_TIPPED = "tipped";
    private static final int MAX_MANA = Integer.MAX_VALUE;
    private static final int MANA_PER_DAMAGE = 100;
    public static final int[] LEVELS = new int[]{0, 10000, 1000000, 10000000, 100000000, 1000000000};
    private static final int[] CREATIVE_MANA = new int[]{9999, 999999, 9999999, 99999999, 999999999, 0x7FFFFFFE};

    public ItemTerraPick(class_1792.class_1793 props) {
        super(BotaniaAPI.instance().getTerrasteelItemTier(), props, -2.8f);
    }

    public void method_7850(@Nonnull class_1761 tab, @Nonnull class_2371<class_1799> list) {
        if (this.method_7877(tab)) {
            for (int mana : CREATIVE_MANA) {
                class_1799 stack = new class_1799((class_1935)this);
                ItemTerraPick.setMana(stack, mana);
                list.add((Object)stack);
            }
            class_1799 stack = new class_1799((class_1935)this);
            ItemTerraPick.setMana(stack, CREATIVE_MANA[1]);
            ItemTerraPick.setTipped(stack);
            list.add((Object)stack);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> stacks, class_1836 flags) {
        class_2588 rank = new class_2588("botania.rank" + ItemTerraPick.getLevel(stack));
        class_2588 rankFormat = new class_2588("botaniamisc.toolRank", new Object[]{rank});
        stacks.add((class_2561)rankFormat);
        if (this.getMana(stack) == Integer.MAX_VALUE) {
            stacks.add((class_2561)new class_2588("botaniamisc.getALife").method_27692(class_124.field_1061));
        }
    }

    @Nonnull
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        this.getMana(stack);
        int level = ItemTerraPick.getLevel(stack);
        if (level != 0) {
            this.setEnabled(stack, !ItemTerraPick.isEnabled(stack));
            if (!world.field_9236) {
                world.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), ModSounds.terraPickMode, class_3419.field_15248, 1.0f, 1.0f);
            }
        }
        return class_1271.method_22427((Object)stack);
    }

    @Override
    @Nonnull
    public class_1269 method_7884(class_1838 ctx) {
        return ctx.method_8036() == null || ctx.method_8036().method_5715() ? super.method_7884(ctx) : class_1269.field_5811;
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
        if (ItemTerraPick.isEnabled(stack)) {
            int level = ItemTerraPick.getLevel(stack);
            if (level == 0) {
                this.setEnabled(stack, false);
            } else if (entity instanceof class_1657 && !((class_1657)entity).field_6252) {
                this.addMana(stack, -level);
            }
        }
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        int level = ItemTerraPick.getLevel(stack);
        int max = LEVELS[Math.min(LEVELS.length - 1, level + 1)];
        int curr = ItemTerraPick.getMana_(stack);
        float percent = level == 0 ? 0.0f : (float)curr / (float)max;
        return Optional.of(new ManaBarTooltip(percent, level));
    }

    public boolean onBlockStartBreak(class_1799 stack, class_2338 pos, class_1657 player) {
        class_3965 raycast = ToolCommons.raytraceFromEntity((class_1297)player, 10.0, false);
        if (!player.field_6002.field_9236 && raycast.method_17783() == class_239.class_240.field_1332) {
            class_2350 face = raycast.method_17780();
            this.breakOtherBlock(player, stack, pos, pos, face);
            if (player.method_21823()) {
                BotaniaAPI.instance().breakOnAllCursors(player, stack, pos, face);
            }
        }
        return false;
    }

    @Override
    public int getManaPerDamage() {
        return 100;
    }

    @Override
    public void breakOtherBlock(class_1657 player, class_1799 stack, class_2338 pos, class_2338 originPos, class_2350 side) {
        if (!ItemTerraPick.isEnabled(stack)) {
            return;
        }
        class_1937 world = player.field_6002;
        class_2680 targetState = world.method_8320(pos);
        if (stack.method_7924(targetState) <= 1.0f) {
            return;
        }
        if (world.method_22347(pos)) {
            return;
        }
        boolean thor = !ItemThorRing.getThorRing(player).method_7960();
        boolean doX = thor || side.method_10148() == 0;
        boolean doY = thor || side.method_10164() == 0;
        boolean doZ = thor || side.method_10165() == 0;
        int origLevel = ItemTerraPick.getLevel(stack);
        int level = origLevel + (thor ? 1 : 0);
        if (ItemTemperanceStone.hasTemperanceActive(player) && level > 2) {
            level = 2;
        }
        int range = level - 1;
        int rangeY = Math.max(1, range);
        if (range == 0 && level != 1) {
            return;
        }
        class_2382 beginDiff = new class_2382(doX ? -range : 0, doY ? -1 : 0, doZ ? -range : 0);
        class_2382 endDiff = new class_2382(doX ? range : 0, doY ? rangeY * 2 - 1 : 0, doZ ? range : 0);
        ToolCommons.removeBlocksInIteration(player, stack, world, pos, beginDiff, endDiff, state -> stack.method_7924(state) > 1.0f);
        if (origLevel == 5) {
            PlayerHelper.grantCriterion((class_3222)player, ResourceLocationHelper.prefix("challenge/rank_ss_pick"), "code_triggered");
        }
    }

    public static boolean isTipped(class_1799 stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_TIPPED, false);
    }

    public static void setTipped(class_1799 stack) {
        ItemNBTHelper.setBoolean(stack, TAG_TIPPED, true);
    }

    public static boolean isEnabled(class_1799 stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_ENABLED, false);
    }

    void setEnabled(class_1799 stack, boolean enabled) {
        ItemNBTHelper.setBoolean(stack, TAG_ENABLED, enabled);
    }

    public static void setMana(class_1799 stack, int mana) {
        ItemNBTHelper.setInt(stack, TAG_MANA, mana);
    }

    @Override
    public int getMana(class_1799 stack) {
        return ItemTerraPick.getMana_(stack) * stack.method_7947();
    }

    public static int getMana_(class_1799 stack) {
        return ItemNBTHelper.getInt(stack, TAG_MANA, 0);
    }

    public static int getLevel(class_1799 stack) {
        int mana = ItemTerraPick.getMana_(stack);
        for (int i = LEVELS.length - 1; i > 0; --i) {
            if (mana < LEVELS[i]) continue;
            return i;
        }
        return 0;
    }

    @Override
    public int getMaxMana(class_1799 stack) {
        return Integer.MAX_VALUE * stack.method_7947();
    }

    @Override
    public void addMana(class_1799 stack, int mana) {
        ItemTerraPick.setMana(stack, Math.min(this.getMana(stack) + mana, this.getMaxMana(stack)) / stack.method_7947());
    }

    @Override
    public boolean canReceiveManaFromPool(class_1799 stack, class_2586 pool) {
        return true;
    }

    @Override
    public boolean canReceiveManaFromItem(class_1799 stack, class_1799 otherStack) {
        return !otherStack.method_31573(ModTags.Items.TERRA_PICK_BLACKLIST);
    }

    @Override
    public boolean canExportManaToPool(class_1799 stack, class_2586 pool) {
        return false;
    }

    @Override
    public boolean canExportManaToItem(class_1799 stack, class_1799 otherStack) {
        return false;
    }

    @Override
    public boolean isNoExport(class_1799 stack) {
        return true;
    }

    public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 before, class_1799 after) {
        return !after.method_31574((class_1792)this) || ItemTerraPick.isEnabled(before) != ItemTerraPick.isEnabled(after);
    }

    @Nonnull
    public class_1814 method_7862(@Nonnull class_1799 stack) {
        int level = ItemTerraPick.getLevel(stack);
        if (stack.method_7942()) {
            ++level;
        }
        if (level >= 5) {
            return class_1814.field_8904;
        }
        if (level >= 3) {
            return class_1814.field_8903;
        }
        return class_1814.field_8907;
    }
}

