/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2288;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_3965;
import net.minecraft.class_4208;
import net.minecraft.class_5250;
import vazkii.botania.api.block.ITileBound;
import vazkii.botania.api.block.IWandBindable;
import vazkii.botania.api.block.IWandable;
import vazkii.botania.api.item.ICoordBoundItem;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.BlockPistonRelay;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileEnchanter;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.common.network.PacketBotaniaEffect;

public class ItemTwigWand
extends class_1792 {
    private static final String TAG_COLOR1 = "color1";
    private static final String TAG_COLOR2 = "color2";
    private static final String TAG_BOUND_TILE_X = "boundTileX";
    private static final String TAG_BOUND_TILE_Y = "boundTileY";
    private static final String TAG_BOUND_TILE_Z = "boundTileZ";
    private static final String TAG_BIND_MODE = "bindMode";
    private static final class_2338 UNBOUND_POS = new class_2338(0, Integer.MIN_VALUE, 0);

    public ItemTwigWand(class_1792.class_1793 builder) {
        super(builder);
        ICoordBoundItem.API.registerForItems((st, c) -> new CoordBoundItem(st), new class_1935[]{this});
    }

    private static boolean tryCompleteBinding(class_2338 src, class_1799 stack, class_1838 ctx) {
        class_2338 dest = ctx.method_8037();
        if (!dest.equals((Object)src)) {
            ItemTwigWand.setBindingAttempt(stack, UNBOUND_POS);
            class_2586 srcTile = ctx.method_8045().method_8321(src);
            if (srcTile instanceof IWandBindable) {
                if (((IWandBindable)srcTile).bindTo(ctx.method_8036(), stack, dest, ctx.method_8038())) {
                    ItemTwigWand.doParticleBeamWithOffset(ctx.method_8045(), src, dest);
                    ItemTwigWand.setBindingAttempt(stack, UNBOUND_POS);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean tryFormEnchanter(class_1838 ctx) {
        class_2338 pos;
        class_1937 world = ctx.method_8045();
        class_2350.class_2351 axis = TileEnchanter.canEnchanterExist(world, pos = ctx.method_8037());
        if (axis != null) {
            if (!world.field_9236) {
                world.method_8501(pos, (class_2680)ModBlocks.enchanter.method_9564().method_11657(BotaniaStateProps.ENCHANTER_DIRECTION, (Comparable)axis));
                world.method_8396(null, pos, ModSounds.enchanterForm, class_3419.field_15245, 1.0f, 1.0f);
                PlayerHelper.grantCriterion((class_3222)ctx.method_8036(), ResourceLocationHelper.prefix("main/enchanter_make"), "code_triggered");
            } else {
                for (int i = 0; i < 50; ++i) {
                    float red = (float)Math.random();
                    float green = (float)Math.random();
                    float blue = (float)Math.random();
                    double x = (Math.random() - 0.5) * 6.0;
                    double y = (Math.random() - 0.5) * 6.0;
                    double z = (Math.random() - 0.5) * 6.0;
                    float velMul = 0.07f;
                    float motionx = (float)(-x) * velMul;
                    float motiony = (float)(-y) * velMul;
                    float motionz = (float)(-z) * velMul;
                    WispParticleData data = WispParticleData.wisp((float)Math.random() * 0.15f + 0.15f, red, green, blue);
                    world.method_8406((class_2394)data, (double)pos.method_10263() + 0.5 + x, (double)pos.method_10264() + 0.5 + y, (double)pos.method_10260() + 0.5 + z, (double)motionx, (double)motiony, (double)motionz);
                }
            }
            return true;
        }
        return false;
    }

    private static boolean tryCompletePistonRelayBinding(class_1838 ctx) {
        class_1937 world = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        class_1657 player = ctx.method_8036();
        class_4208 bindPos = ((BlockPistonRelay)ModBlocks.pistonRelay).activeBindingAttempts.get(player.method_5667());
        if (bindPos != null && bindPos.method_19442() == world.method_27983()) {
            ((BlockPistonRelay)ModBlocks.pistonRelay).activeBindingAttempts.remove(player.method_5667());
            BlockPistonRelay.WorldData data = BlockPistonRelay.WorldData.get(world);
            data.mapping.put(bindPos.method_19446(), pos.method_10062());
            data.method_80();
            PacketBotaniaEffect.sendNearby(world, pos, PacketBotaniaEffect.EffectType.PARTICLE_BEAM, (double)bindPos.method_19446().method_10263() + 0.5, (double)bindPos.method_19446().method_10264() + 0.5, (double)bindPos.method_19446().method_10260() + 0.5, pos.method_10263(), pos.method_10264(), pos.method_10260());
            world.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), ModSounds.ding, class_3419.field_15248, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Nonnull
    public class_1269 method_7884(class_1838 ctx) {
        class_1799 stack = ctx.method_8041();
        class_1937 world = ctx.method_8045();
        class_1657 player = ctx.method_8036();
        class_2338 pos = ctx.method_8037();
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        class_2350 side = ctx.method_8038();
        Optional<class_2338> boundPos = ItemTwigWand.getBindingAttempt(stack);
        if (player == null) {
            return class_1269.field_5811;
        }
        if (player.method_5715()) {
            class_2680 newState;
            if (boundPos.filter(loc -> ItemTwigWand.tryCompleteBinding(loc, stack, ctx)).isPresent()) {
                return class_1269.field_5812;
            }
            if (player.method_7343(pos, side, stack) && (!(block instanceof class_2288) || player.method_7338()) && (newState = ItemTwigWand.rotate(state, side.method_10166())) != state) {
                world.method_8501(pos, newState);
                return class_1269.field_5812;
            }
        }
        if (state.method_27852(class_2246.field_10441) && ((Boolean)ConfigHandler.COMMON.enchanterEnabled.getValue()).booleanValue() && ItemTwigWand.tryFormEnchanter(ctx)) {
            return class_1269.field_5812;
        }
        class_2586 tile = world.method_8321(pos);
        boolean bindable = tile instanceof IWandBindable;
        if (ItemTwigWand.getBindMode(stack) && bindable && player.method_5715() && ((IWandBindable)tile).canSelect(player, stack, pos, side)) {
            if (boundPos.filter(arg_0 -> ((class_2338)pos).equals(arg_0)).isPresent()) {
                ItemTwigWand.setBindingAttempt(stack, UNBOUND_POS);
            } else {
                ItemTwigWand.setBindingAttempt(stack, pos);
            }
            if (world.field_9236) {
                player.method_5783(ModSounds.ding, 0.11f, 1.0f);
            }
            return class_1269.field_5812;
        }
        IWandable wandable = (IWandable)IWandable.API.find(world, pos, state, tile, (Object)class_3902.field_17274);
        if (wandable != null) {
            return wandable.onUsedByWand(player, stack, side) ? class_1269.field_5812 : class_1269.field_5814;
        }
        if (!world.field_9236 && ItemTwigWand.getBindMode(stack) && ItemTwigWand.tryCompletePistonRelayBinding(ctx)) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private static class_2680 rotate(class_2680 old, class_2350.class_2351 axis) {
        for (class_2769 prop : old.method_28501()) {
            class_2350 newDir;
            class_2769 facingProp;
            class_2350 oldDir;
            if (!prop.method_11899().equals("facing") || prop.method_11902() != class_2350.class || (oldDir = (class_2350)old.method_11654(facingProp = prop)) == (newDir = ItemTwigWand.rotateAround(oldDir, axis)) || !facingProp.method_11898().contains(newDir)) continue;
            return (class_2680)old.method_11657(facingProp, (Comparable)newDir);
        }
        return old.method_26186(class_2470.field_11463);
    }

    private static class_2350 rotateAround(class_2350 old, class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> {
                switch (old) {
                    case field_11033: {
                        yield class_2350.field_11035;
                    }
                    case field_11035: {
                        yield class_2350.field_11036;
                    }
                    case field_11036: {
                        yield class_2350.field_11043;
                    }
                    case field_11043: {
                        yield class_2350.field_11033;
                    }
                }
                yield old;
            }
            case class_2350.class_2351.field_11052 -> {
                switch (old) {
                    case field_11043: {
                        yield class_2350.field_11034;
                    }
                    case field_11034: {
                        yield class_2350.field_11035;
                    }
                    case field_11035: {
                        yield class_2350.field_11039;
                    }
                    case field_11039: {
                        yield class_2350.field_11043;
                    }
                }
                yield old;
            }
            case class_2350.class_2351.field_11051 -> {
                switch (old) {
                    case field_11033: {
                        yield class_2350.field_11039;
                    }
                    case field_11039: {
                        yield class_2350.field_11036;
                    }
                    case field_11036: {
                        yield class_2350.field_11034;
                    }
                    case field_11034: {
                        yield class_2350.field_11033;
                    }
                }
                yield old;
            }
        };
    }

    public static void doParticleBeamWithOffset(class_1937 world, class_2338 orig, class_2338 end) {
        class_243 origOffset = world.method_8320(orig).method_26226((class_1922)world, orig);
        class_243 vorig = new class_243((double)orig.method_10263() + origOffset.method_10216() + 0.5, (double)orig.method_10264() + origOffset.method_10214() + 0.5, (double)orig.method_10260() + origOffset.method_10215() + 0.5);
        class_243 endOffset = world.method_8320(end).method_26226((class_1922)world, end);
        class_243 vend = new class_243((double)end.method_10263() + endOffset.method_10216() + 0.5, (double)end.method_10264() + endOffset.method_10214() + 0.5, (double)end.method_10260() + endOffset.method_10215() + 0.5);
        ItemTwigWand.doParticleBeam(world, vorig, vend);
    }

    public static void doParticleBeam(class_1937 world, class_243 orig, class_243 end) {
        if (!world.field_9236) {
            return;
        }
        class_243 diff = end.method_1020(orig);
        class_243 movement = diff.method_1029().method_1021(0.05);
        int iters = (int)(diff.method_1033() / movement.method_1033());
        float huePer = 1.0f / (float)iters;
        float hueSum = (float)Math.random();
        class_243 currentPos = orig;
        for (int i = 0; i < iters; ++i) {
            float hue = (float)i * huePer + hueSum;
            int color = class_3532.method_15369((float)class_3532.method_22450((float)hue), (float)1.0f, (float)1.0f);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            SparkleParticleData data = SparkleParticleData.noClip(0.5f, r, g, b, 4);
            Botania.proxy.addParticleForceNear(world, data, currentPos.field_1352, currentPos.field_1351, currentPos.field_1350, 0.0, 0.0, 0.0);
            currentPos = currentPos.method_1019(movement);
        }
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        ItemTwigWand.getBindingAttempt(stack).ifPresent(coords -> {
            class_2586 tile = world.method_8321(coords);
            if (!(tile instanceof IWandBindable)) {
                ItemTwigWand.setBindingAttempt(stack, UNBOUND_POS);
            }
        });
    }

    @Nonnull
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (player.method_5715()) {
            if (!world.field_9236) {
                ItemTwigWand.setBindMode(stack, !ItemTwigWand.getBindMode(stack));
            } else {
                player.method_5783(ModSounds.ding, 0.1f, 1.0f);
            }
        }
        return class_1271.method_22427((Object)stack);
    }

    public void method_7850(@Nonnull class_1761 group, @Nonnull class_2371<class_1799> stacks) {
        if (this.method_7877(group)) {
            for (int i = 0; i < 16; ++i) {
                stacks.add((Object)ItemTwigWand.forColors(i, i));
            }
        }
    }

    public class_2561 method_7864(@Nonnull class_1799 stack) {
        class_5250 mode = new class_2585(" (").method_10852((class_2561)new class_2588(ItemTwigWand.getModeString(stack)).method_27692(class_124.field_1077)).method_27693(")");
        return super.method_7864(stack).method_27662().method_10852((class_2561)mode);
    }

    public static class_1799 forColors(int color1, int color2) {
        class_1799 stack = new class_1799((class_1935)ModItems.twigWand);
        ItemNBTHelper.setInt(stack, TAG_COLOR1, color1);
        ItemNBTHelper.setInt(stack, TAG_COLOR2, color2);
        return stack;
    }

    public static int getColor1(class_1799 stack) {
        return ItemNBTHelper.getInt(stack, TAG_COLOR1, 0);
    }

    public static int getColor2(class_1799 stack) {
        return ItemNBTHelper.getInt(stack, TAG_COLOR2, 0);
    }

    public static void setBindingAttempt(class_1799 stack, class_2338 pos) {
        ItemNBTHelper.setInt(stack, TAG_BOUND_TILE_X, pos.method_10263());
        ItemNBTHelper.setInt(stack, TAG_BOUND_TILE_Y, pos.method_10264());
        ItemNBTHelper.setInt(stack, TAG_BOUND_TILE_Z, pos.method_10260());
    }

    public static Optional<class_2338> getBindingAttempt(class_1799 stack) {
        int x = ItemNBTHelper.getInt(stack, TAG_BOUND_TILE_X, 0);
        int y = ItemNBTHelper.getInt(stack, TAG_BOUND_TILE_Y, Integer.MIN_VALUE);
        int z = ItemNBTHelper.getInt(stack, TAG_BOUND_TILE_Z, 0);
        return y == Integer.MIN_VALUE ? Optional.empty() : Optional.of(new class_2338(x, y, z));
    }

    public static boolean getBindMode(class_1799 stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_BIND_MODE, true);
    }

    public static void setBindMode(class_1799 stack, boolean bindMode) {
        ItemNBTHelper.setBoolean(stack, TAG_BIND_MODE, bindMode);
    }

    public static String getModeString(class_1799 stack) {
        return "botaniamisc.wandMode." + (ItemTwigWand.getBindMode(stack) ? "bind" : "function");
    }

    protected static class CoordBoundItem
    implements ICoordBoundItem {
        private final class_1799 stack;

        public CoordBoundItem(class_1799 stack) {
            this.stack = stack;
        }

        @Override
        @Nullable
        public class_2338 getBinding(class_1937 world) {
            class_2586 tile;
            Optional<class_2338> bound = ItemTwigWand.getBindingAttempt(this.stack);
            if (bound.isPresent()) {
                return bound.get();
            }
            class_239 pos = class_310.method_1551().field_1765;
            if (pos != null && pos.method_17783() == class_239.class_240.field_1332 && (tile = world.method_8321(((class_3965)pos).method_17777())) instanceof ITileBound) {
                return ((ITileBound)tile).getBinding();
            }
            return null;
        }
    }
}

