/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1682;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2346;
import net.minecraft.class_2371;
import net.minecraft.class_2388;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ILensEffect;
import vazkii.botania.api.mana.ITinyPlanetExcempt;
import vazkii.botania.common.advancements.UseItemSuccessTrigger;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.entity.EntityManaBurst;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.lib.ModTags;

public class ItemLaputaShard
extends class_1792
implements ILensEffect,
ITinyPlanetExcempt {
    private static final String TAG_STATE = "_state";
    private static final String TAG_TILE = "_tile";
    private static final String TAG_X = "_x";
    private static final String TAG_Y = "_y";
    private static final String TAG_Y_START = "_yStart";
    private static final String TAG_Z = "_z";
    private static final String TAG_POINTY = "_pointy";
    private static final String TAG_HEIGHTSCALE = "_heightscale";
    private static final String TAG_ITERATION_I = "iterationI";
    private static final String TAG_ITERATION_J = "iterationJ";
    private static final String TAG_ITERATION_K = "iterationK";
    public static final String TAG_LEVEL = "level";
    private static final int BASE_RANGE = 14;
    private static final int BASE_OFFSET = 42;

    public ItemLaputaShard(class_1792.class_1793 props) {
        super(props);
    }

    public void method_7850(@Nonnull class_1761 tab, @Nonnull class_2371<class_1799> list) {
        if (this.method_7877(tab)) {
            for (int i = 0; i <= 20; i += 5) {
                class_1799 s = new class_1799((class_1935)this);
                if (i != 0) {
                    s.method_7948().method_10569(TAG_LEVEL, i - 1);
                }
                list.add((Object)s);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> list, class_1836 flags) {
        int level = ItemLaputaShard.getShardLevel(stack);
        class_2588 levelLoc = new class_2588("botania.roman" + (level + 1));
        list.add((class_2561)new class_2588("botaniamisc.shardLevel", new Object[]{levelLoc}).method_27692(class_124.field_1080));
        list.add((class_2561)new class_2588("botaniamisc.shardRange", new Object[]{this.getRange(stack)}).method_27692(class_124.field_1080));
    }

    @Nonnull
    public class_1269 method_7884(class_1838 ctx) {
        class_1937 world = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        if (!world.field_9236 && pos.method_10264() < 160 && !world.method_8597().method_27999()) {
            world.method_8396(null, pos, ModSounds.laputaStart, class_3419.field_15245, 1.0f + world.field_9229.nextFloat(), world.field_9229.nextFloat() * 0.7f + 1.3f);
            class_1799 stack = ctx.method_8041();
            this.spawnFirstBurst(world, pos, stack);
            if (ctx.method_8036() != null) {
                UseItemSuccessTrigger.INSTANCE.trigger((class_3222)ctx.method_8036(), stack, (class_3218)world, pos.method_10263(), pos.method_10264(), pos.method_10260());
            }
            stack.method_7934(1);
        }
        return class_1269.field_5812;
    }

    private int getRange(class_1799 shard) {
        return 14 + ItemLaputaShard.getShardLevel(shard);
    }

    protected void spawnFirstBurst(class_1937 world, class_2338 pos, class_1799 shard) {
        int range = this.getRange(shard);
        boolean pointy = world.field_9229.nextDouble() < 0.25;
        double heightscale = (world.field_9229.nextDouble() + 0.5) * (14.0 / (double)range);
        this.spawnNextBurst(world, pos, shard, pointy, heightscale);
    }

    protected void spawnNextBurst(class_1937 world, class_2338 pos, class_1799 lens) {
        boolean pointy = ItemNBTHelper.getBoolean(lens, TAG_POINTY, false);
        double heightscale = ItemNBTHelper.getDouble(lens, TAG_HEIGHTSCALE, 1.0);
        this.spawnNextBurst(world, pos, lens, pointy, heightscale);
    }

    private static boolean canMove(class_2680 state, class_1937 world, class_2338 pos) {
        class_3610 fluidState = state.method_26227();
        boolean isFlowingFluid = !fluidState.method_15769() && !fluidState.method_15771();
        class_2248 block = state.method_26204();
        return !state.method_26215() && !isFlowingFluid && !(block instanceof class_2346) && !state.method_26164(ModTags.Blocks.LAPUTA_IMMOBILE) && state.method_26214((class_1922)world, pos) != -1.0f;
    }

    private void spawnNextBurst(class_1937 world, class_2338 pos, class_1799 shard, boolean pointy, double heightscale) {
        int range = this.getRange(shard);
        int i = ItemNBTHelper.getInt(shard, TAG_ITERATION_I, 0);
        int j = ItemNBTHelper.getInt(shard, TAG_ITERATION_J, 35);
        int k = ItemNBTHelper.getInt(shard, TAG_ITERATION_K, 0);
        if (j <= -28) {
            j = 35;
        }
        if (k >= range * 2 + 1) {
            k = 0;
        }
        while (i < range * 2 + 1) {
            while (j > -28) {
                while (k < range * 2 + 1) {
                    class_2338 pos_ = pos.method_10069(-range + i, -14 + j, -range + k);
                    if (this.inRange(pos_, pos, range, heightscale, pointy)) {
                        class_2680 state = world.method_8320(pos_);
                        class_2248 block = state.method_26204();
                        if (ItemLaputaShard.canMove(state, world, pos_)) {
                            class_2586 tile = world.method_8321(pos_);
                            class_2487 cmp = new class_2487();
                            if (tile != null) {
                                cmp = tile.method_38242();
                                class_2586 newTile = ((class_2343)block).method_10123(pos_, state);
                                world.method_8438(newTile);
                            }
                            if (!world.method_8650(pos_, false)) {
                                if (tile != null) {
                                    world.method_8438(tile);
                                }
                            } else {
                                world.method_20290(2001, pos_, class_2248.method_9507((class_2680)state));
                                class_1799 copyLens = new class_1799((class_1935)this);
                                copyLens.method_7948().method_10569(TAG_LEVEL, ItemLaputaShard.getShardLevel(shard));
                                copyLens.method_7969().method_10566(TAG_STATE, (class_2520)class_2512.method_10686((class_2680)state));
                                ItemNBTHelper.setCompound(copyLens, TAG_TILE, cmp);
                                ItemNBTHelper.setInt(copyLens, TAG_X, pos.method_10263());
                                ItemNBTHelper.setInt(copyLens, TAG_Y, pos.method_10264());
                                ItemNBTHelper.setInt(copyLens, TAG_Y_START, pos_.method_10264());
                                ItemNBTHelper.setInt(copyLens, TAG_Z, pos.method_10260());
                                ItemNBTHelper.setBoolean(copyLens, TAG_POINTY, pointy);
                                ItemNBTHelper.setDouble(copyLens, TAG_HEIGHTSCALE, heightscale);
                                ItemNBTHelper.setInt(copyLens, TAG_ITERATION_I, i);
                                ItemNBTHelper.setInt(copyLens, TAG_ITERATION_J, j);
                                ItemNBTHelper.setInt(copyLens, TAG_ITERATION_K, k);
                                EntityManaBurst burst = this.getBurst(world, pos_, copyLens);
                                world.method_8649((class_1297)burst);
                                return;
                            }
                        }
                    }
                    ++k;
                }
                k = 0;
                --j;
            }
            j = 35;
            ++i;
        }
    }

    public static int getShardLevel(class_1799 shard) {
        if (!shard.method_7985()) {
            return 0;
        }
        return shard.method_7948().method_10550(TAG_LEVEL);
    }

    private boolean inRange(class_2338 pos, class_2338 srcPos, int range, double heightscale, boolean pointy) {
        if (pos.method_10264() >= srcPos.method_10264()) {
            return MathHelper.pointDistanceSpace(pos.method_10263(), 0.0, pos.method_10260(), srcPos.method_10263(), 0.0, srcPos.method_10260()) < (float)range;
        }
        if (!pointy) {
            return MathHelper.pointDistanceSpace(pos.method_10263(), (double)pos.method_10264() / heightscale, pos.method_10260(), srcPos.method_10263(), (double)srcPos.method_10264() / heightscale, srcPos.method_10260()) < (float)range;
        }
        return (double)MathHelper.pointDistanceSpace(pos.method_10263(), 0.0, pos.method_10260(), srcPos.method_10263(), 0.0, srcPos.method_10260()) < (double)range - (double)(srcPos.method_10264() - pos.method_10264()) / heightscale;
    }

    public EntityManaBurst getBurst(class_1937 world, class_2338 pos, class_1799 stack) {
        EntityManaBurst burst = (EntityManaBurst)ModEntities.MANA_BURST.method_5883(world);
        burst.method_5814((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        burst.setColor(60159);
        burst.setMana(1);
        burst.setStartingMana(1);
        burst.setMinManaLoss(0);
        burst.setManaLossPerTick(0.0f);
        burst.setGravity(0.0f);
        burst.method_18800(0.0, 0.5, 0.0);
        burst.setSourceLens(stack);
        return burst;
    }

    @Override
    public void apply(class_1799 stack, BurstProperties props) {
    }

    @Override
    public boolean collideBurst(IManaBurst burst, class_239 pos, boolean isManaBlock, boolean shouldKill, class_1799 stack) {
        return false;
    }

    @Override
    public void updateBurst(IManaBurst burst, class_1799 stack) {
        double speed = 0.35;
        int targetDistance = 42;
        class_1682 entity = burst.entity();
        if (!entity.field_6002.field_9236) {
            entity.method_18800(0.0, speed, 0.0);
            int spawnTicks = 2;
            int placeTicks = class_3532.method_15357((double)((double)targetDistance / speed));
            class_1799 lens = burst.getSourceLens();
            if (burst.getTicksExisted() == 2) {
                int x = ItemNBTHelper.getInt(lens, TAG_X, 0);
                int y = ItemNBTHelper.getInt(lens, TAG_Y, Integer.MIN_VALUE);
                int z = ItemNBTHelper.getInt(lens, TAG_Z, 0);
                if (y != Integer.MIN_VALUE) {
                    this.spawnNextBurst(entity.field_6002, new class_2338(x, y, z), lens);
                }
            } else if (burst.getTicksExisted() == placeTicks) {
                int x = class_3532.method_15357((double)entity.method_23317());
                int y = ItemNBTHelper.getInt(lens, TAG_Y_START, -1) + targetDistance;
                int z = class_3532.method_15357((double)entity.method_23321());
                class_2338 pos = new class_2338(x, y, z);
                class_2680 placeState = class_2246.field_10124.method_9564();
                if (lens.method_7985() && lens.method_7969().method_10545(TAG_STATE)) {
                    placeState = class_2512.method_10681((class_2487)lens.method_7969().method_10562(TAG_STATE));
                }
                if (entity.field_6002.method_8597().method_27999() && placeState.method_28498((class_2769)class_2741.field_12508)) {
                    placeState = (class_2680)placeState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false));
                }
                if (entity.field_6002.method_8320(pos).method_26207().method_15800()) {
                    class_2586 tile = null;
                    class_2487 tilecmp = ItemNBTHelper.getCompound(lens, TAG_TILE, false);
                    if (tilecmp.method_10545("id")) {
                        tile = class_2586.method_11005((class_2338)pos, (class_2680)placeState, (class_2487)tilecmp);
                    }
                    entity.field_6002.method_8501(pos, placeState);
                    entity.field_6002.method_20290(2001, pos, class_2248.method_9507((class_2680)placeState));
                    if (tile != null) {
                        entity.field_6002.method_8438(tile);
                    }
                } else {
                    int ox = ItemNBTHelper.getInt(lens, TAG_X, 0);
                    int oy = ItemNBTHelper.getInt(lens, TAG_Y_START, -1);
                    int oz = ItemNBTHelper.getInt(lens, TAG_Z, 0);
                    class_2248.method_9497((class_2680)placeState, (class_1937)entity.field_6002, (class_2338)new class_2338(ox, oy, oz));
                }
                entity.method_31472();
            }
        }
    }

    @Override
    public boolean doParticles(IManaBurst burst, class_1799 stack) {
        class_1682 entity = burst.entity();
        class_1799 lens = burst.getSourceLens();
        class_2680 state = class_2512.method_10681((class_2487)lens.method_7948().method_10562(TAG_STATE));
        entity.field_6002.method_8406((class_2394)new class_2388(class_2398.field_11217, state), entity.method_23317(), entity.method_23318(), entity.method_23321(), entity.method_18798().method_10216(), entity.method_18798().method_10214(), entity.method_18798().method_10215());
        return true;
    }

    @Override
    public boolean shouldPull(class_1799 stack) {
        return false;
    }
}

