/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.handler;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import net.minecraft.class_140;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.lib.LibBlockNames;
import vazkii.botania.common.lib.ModTags;

public class ContributorList {
    private static final ImmutableMap<String, String> LEGACY_FLOWER_NAMES = ImmutableMap.builder().put((Object)"daybloom", (Object)"daybloom_motif").put((Object)"nightshade", (Object)"nightshade_motif").put((Object)"puredaisy", (Object)LibBlockNames.SUBTILE_PUREDAISY.method_12832()).put((Object)"fallenkanade", (Object)LibBlockNames.SUBTILE_FALLEN_KANADE.method_12832()).put((Object)"heiseidream", (Object)LibBlockNames.SUBTILE_HEISEI_DREAM.method_12832()).put((Object)"arcanerose", (Object)LibBlockNames.SUBTILE_ARCANE_ROSE.method_12832()).put((Object)"jadedamaranthus", (Object)LibBlockNames.SUBTILE_JADED_AMARANTHUS.method_12832()).put((Object)"orechidignem", (Object)LibBlockNames.SUBTILE_ORECHID_IGNEM.method_12832()).build();
    private static volatile Map<String, class_1799> flowerMap = Collections.emptyMap();
    private static boolean startedLoading = false;
    public static final String TAG_HEADFLOWER = "botania:headflower";

    public static void firstStart() {
        if (!startedLoading) {
            Thread thread = new Thread(ContributorList::fetch);
            thread.setName("Botania Contributor Fanciness Thread");
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new class_140(Botania.LOGGER));
            thread.start();
            startedLoading = true;
        }
    }

    public static class_1799 getFlower(String name) {
        return flowerMap.getOrDefault(name, class_1799.field_8037);
    }

    public static boolean hasFlower(String name) {
        return flowerMap.containsKey(name);
    }

    private static void load(Properties props) {
        HashMap<String, class_1799> m = new HashMap<String, class_1799>();
        HashMap<class_1792, class_1799> cachedStacks = new HashMap<class_1792, class_1799>();
        for (String key : props.stringPropertyNames()) {
            class_1799 stack;
            String value = props.getProperty(key);
            try {
                int i = Integer.parseInt(value);
                if (i < 0 || i >= 16) {
                    throw new NumberFormatException();
                }
                stack = cachedStacks.computeIfAbsent(ModBlocks.getFlower(class_1767.method_7791((int)i)).method_8389(), ContributorList::configureStack);
            }
            catch (NumberFormatException e) {
                String rawName = value.toLowerCase(Locale.ROOT);
                String flowerName = (String)LEGACY_FLOWER_NAMES.getOrDefault((Object)rawName, (Object)rawName);
                class_1792 item = ModTags.Items.CONTRIBUTOR_HEADFLOWERS.method_15138().stream().filter(flower -> class_2378.field_11142.method_10221(flower).method_12832().equals(flowerName)).findFirst().orElse(class_1802.field_8880);
                stack = cachedStacks.computeIfAbsent(item, ContributorList::configureStack);
            }
            m.put(key, stack);
        }
        flowerMap = m;
    }

    private static class_1799 configureStack(class_1792 item) {
        class_1799 stack = new class_1799((class_1935)item);
        HashMap<class_1887, Integer> ench = new HashMap<class_1887, Integer>();
        ench.put(class_1893.field_9119, 1);
        class_2378.field_11160.method_17966(new class_2960("charm", "tinted")).ifPresent(e -> ench.put((class_1887)e, 1));
        class_1890.method_8214(ench, (class_1799)stack);
        stack.method_7969().method_10556(TAG_HEADFLOWER, true);
        stack.method_7969().method_10582("charm_glint", class_1767.field_7947.method_15434());
        return stack;
    }

    private static void fetch() {
        try {
            URL url = new URL("https://raw.githubusercontent.com/Vazkii/Botania/master/contributors.properties");
            Properties props = new Properties();
            try (InputStreamReader reader = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);){
                props.load(reader);
                ContributorList.load(props);
            }
        }
        catch (IOException e) {
            Botania.LOGGER.info("Could not load contributors list. Either you're offline or GitHub is down. Nothing to worry about, carry on~");
        }
    }
}

