/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.mana;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;

public class TileRFGenerator
extends TileMod
implements IManaReceiver {
    private static final int MANA_TO_FE = 10;
    private static final int MAX_ENERGY = 12800;
    private static final String TAG_MANA = "mana";
    private int energy = 0;

    public TileRFGenerator(class_2338 pos, class_2680 state) {
        super(ModTiles.FLUXFIELD, pos, state);
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, TileRFGenerator self) {
        int transfer = Math.min(self.energy, 1600);
        self.energy -= transfer;
        self.energy += self.transmitEnergy(transfer);
    }

    private int transmitEnergy(int energy) {
        return energy;
    }

    @Override
    public int getCurrentMana() {
        return this.energy / 10;
    }

    @Override
    public boolean isFull() {
        return this.energy >= 12800;
    }

    @Override
    public void receiveMana(int mana) {
        this.energy = Math.min(12800, this.energy + mana * 10);
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return true;
    }

    @Override
    public void writePacketNBT(class_2487 cmp) {
        cmp.method_10569(TAG_MANA, this.energy);
    }

    @Override
    public void readPacketNBT(class_2487 cmp) {
        this.energy = cmp.method_10550(TAG_MANA);
    }
}

