/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import com.google.common.base.Predicates;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.spark.IManaSpark;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.api.recipe.ITerraPlateRecipe;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.network.PacketBotaniaEffect;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;

public class TileTerraPlate
extends TileMod
implements ISparkAttachable {
    public static final Supplier<IMultiblock> MULTIBLOCK = Suppliers.memoize(() -> PatchouliAPI.get().makeMultiblock((String[][])new String[][]{{"___", "_P_", "___"}, {"RLR", "L0L", "RLR"}}, new Object[]{Character.valueOf('P'), ModBlocks.terraPlate, Character.valueOf('R'), "#botania:terra_plate_base", Character.valueOf('0'), "#botania:terra_plate_base", Character.valueOf('L'), "#c:lapis_blocks"}));
    private static final String TAG_MANA = "mana";
    private int mana;

    public TileTerraPlate(class_2338 pos, class_2680 state) {
        super(ModTiles.TERRA_PLATE, pos, state);
    }

    public static void serverTick(class_1937 level, class_2338 worldPosition, class_2680 state, TileTerraPlate self) {
        boolean removeMana = true;
        if (self.hasValidPlatform()) {
            List<class_1799> items = self.getItems();
            class_1277 inv = self.getInventory();
            ITerraPlateRecipe recipe = self.getCurrentRecipe(inv);
            if (recipe != null) {
                removeMana = false;
                IManaSpark spark = self.getAttachedSpark();
                if (spark != null) {
                    SparkHelper.getSparksAround(level, (double)worldPosition.method_10263() + 0.5, (double)worldPosition.method_10264() + 0.5, (double)worldPosition.method_10260() + 0.5, spark.getNetwork()).filter(otherSpark -> spark != otherSpark && otherSpark.getAttachedTile() instanceof IManaPool).forEach(os -> os.registerTransfer(spark));
                }
                if (self.mana > 0) {
                    VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
                    int proportion = Float.floatToIntBits(self.getCompletion());
                    PacketBotaniaEffect.sendNearby(level, worldPosition, PacketBotaniaEffect.EffectType.TERRA_PLATE, (double)worldPosition.method_10263(), (double)worldPosition.method_10264(), (double)worldPosition.method_10260(), proportion);
                }
                if (self.mana >= recipe.getMana()) {
                    class_1799 result = recipe.method_8116((class_1263)inv);
                    for (class_1799 item : items) {
                        item.method_7939(0);
                    }
                    class_1542 item = new class_1542(level, (double)worldPosition.method_10263() + 0.5, (double)worldPosition.method_10264() + 0.2, (double)worldPosition.method_10260() + 0.5, result);
                    item.method_18799(class_243.field_1353);
                    level.method_8649((class_1297)item);
                    level.method_8465(null, item.method_23317(), item.method_23318(), item.method_23321(), ModSounds.terrasteelCraft, class_3419.field_15245, 1.0f, 1.0f);
                    self.mana = 0;
                    level.method_8455(worldPosition, state.method_26204());
                    VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
                }
            }
        }
        if (removeMana) {
            self.receiveMana(-1000);
        }
    }

    private List<class_1799> getItems() {
        List itemEntities = this.field_11863.method_8390(class_1542.class, new class_238(this.field_11867, this.field_11867.method_10069(1, 1, 1)), class_1301.field_6154);
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        for (class_1542 entity : itemEntities) {
            if (entity.method_6983().method_7960()) continue;
            stacks.add(entity.method_6983());
        }
        return stacks;
    }

    private class_1277 getInventory() {
        List<class_1799> items = this.getItems();
        return new class_1277(TileTerraPlate.flattenStacks(items));
    }

    private static class_1799[] flattenStacks(List<class_1799> items) {
        int i = 0;
        for (class_1799 item : items) {
            i += item.method_7947();
        }
        if (i > 64) {
            return new class_1799[0];
        }
        class_1799[] stacks = new class_1799[i];
        int j = 0;
        for (class_1799 item : items) {
            if (item.method_7947() > 1) {
                class_1799 temp = item.method_7972();
                temp.method_7939(1);
                for (int count = 0; count < item.method_7947(); ++count) {
                    stacks[j] = temp.method_7972();
                    ++j;
                }
                continue;
            }
            stacks[j] = item;
            ++j;
        }
        return stacks;
    }

    @Nullable
    private ITerraPlateRecipe getCurrentRecipe(class_1277 items) {
        if (items.method_5442()) {
            return null;
        }
        return this.field_11863.method_8433().method_8132(ModRecipeTypes.TERRA_PLATE_TYPE, (class_1263)items, this.field_11863).orElse(null);
    }

    private boolean isActive() {
        return this.getCurrentRecipe(this.getInventory()) != null;
    }

    private boolean hasValidPlatform() {
        return MULTIBLOCK.get().validate(this.field_11863, this.method_11016().method_10074()) != null;
    }

    @Override
    public void writePacketNBT(class_2487 cmp) {
        cmp.method_10569(TAG_MANA, this.mana);
    }

    @Override
    public void readPacketNBT(class_2487 cmp) {
        this.mana = cmp.method_10550(TAG_MANA);
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public boolean isFull() {
        ITerraPlateRecipe recipe = this.getCurrentRecipe(this.getInventory());
        return recipe == null || this.getCurrentMana() >= recipe.getMana();
    }

    @Override
    public void receiveMana(int mana) {
        this.mana = Math.max(0, this.mana + mana);
        this.field_11863.method_8455(this.field_11867, this.method_11010().method_26204());
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return this.isActive();
    }

    @Override
    public boolean canAttachSpark(class_1799 stack) {
        return true;
    }

    @Override
    public IManaSpark getAttachedSpark() {
        List sparks = this.field_11863.method_8390(class_1297.class, new class_238(this.field_11867.method_10084(), this.field_11867.method_10084().method_10069(1, 1, 1)), (Predicate)Predicates.instanceOf(IManaSpark.class));
        if (sparks.size() == 1) {
            class_1297 e = (class_1297)sparks.get(0);
            return (IManaSpark)e;
        }
        return null;
    }

    @Override
    public boolean areIncomingTranfersDone() {
        return !this.isActive();
    }

    @Override
    public int getAvailableSpaceForMana() {
        ITerraPlateRecipe recipe = this.getCurrentRecipe(this.getInventory());
        return recipe == null ? 0 : Math.max(0, recipe.getMana() - this.getCurrentMana());
    }

    public float getCompletion() {
        ITerraPlateRecipe recipe = this.getCurrentRecipe(this.getInventory());
        if (recipe == null) {
            return 0.0f;
        }
        return (float)this.getCurrentMana() / (float)recipe.getMana();
    }

    public int getComparatorLevel() {
        int val = (int)((double)this.getCompletion() * 15.0);
        if (this.getCurrentMana() > 0) {
            val = Math.max(val, 1);
        }
        return val;
    }
}

