/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import vazkii.botania.api.block.IWandable;
import vazkii.botania.api.recipe.ElvenPortalUpdateCallback;
import vazkii.botania.api.recipe.IElvenTradeRecipe;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.AlfPortalState;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.advancements.AlfPortalBreadTrigger;
import vazkii.botania.common.advancements.AlfPortalTrigger;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.mana.BlockPool;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.block.tile.TilePylon;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.components.EntityComponents;
import vazkii.botania.common.components.ItemFlagsComponent;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;

public class TileAlfPortal
extends TileMod
implements IWandable {
    public static final Supplier<IMultiblock> MULTIBLOCK = Suppliers.memoize(() -> PatchouliAPI.get().makeMultiblock((String[][])new String[][]{{"_", "W", "G", "W", "_"}, {"W", " ", " ", " ", "W"}, {"G", " ", " ", " ", "G"}, {"W", " ", " ", " ", "W"}, {"_", "W", "0", "W", "_"}}, new Object[]{Character.valueOf('W'), ModBlocks.livingwood, Character.valueOf('G'), ModBlocks.livingwoodGlimmering, Character.valueOf('0'), ModBlocks.alfPortal}));
    public static final int MANA_COST = 500;
    private static final String TAG_TICKS_OPEN = "ticksOpen";
    private static final String TAG_TICKS_SINCE_LAST_ITEM = "ticksSinceLastItem";
    private static final String TAG_STACK_COUNT = "stackCount";
    private static final String TAG_STACK = "portalStack";
    public static final String TAG_PORTAL_FLAG = "_elvenPortal";
    private final List<class_1799> stacksIn = new ArrayList<class_1799>();
    public int ticksOpen = 0;
    private int ticksSinceLastItem = 0;
    private boolean closeNow = false;
    private boolean explode = false;
    @Nullable
    private UUID breadPlayer = null;

    public TileAlfPortal(class_2338 pos, class_2680 state) {
        super(ModTiles.ALF_PORTAL, pos, state);
    }

    public static void commonTick(class_1937 level, class_2338 worldPosition, class_2680 blockState, TileAlfPortal self) {
        if (blockState.method_11654(BotaniaStateProps.ALFPORTAL_STATE) == AlfPortalState.OFF) {
            self.ticksOpen = 0;
            return;
        }
        AlfPortalState state = (AlfPortalState)((Object)blockState.method_11654(BotaniaStateProps.ALFPORTAL_STATE));
        AlfPortalState newState = self.getValidState();
        ++self.ticksOpen;
        class_238 aabb = self.getPortalAABB();
        boolean open = self.ticksOpen > 60;
        ((ElvenPortalUpdateCallback)ElvenPortalUpdateCallback.EVENT.invoker()).onElvenPortalTick(self, aabb, open, self.stacksIn);
        if (self.ticksOpen > 60) {
            ++self.ticksSinceLastItem;
            if (level.field_9236 && ((Boolean)ConfigHandler.CLIENT.elfPortalParticlesEnabled.getValue()).booleanValue()) {
                self.blockParticle(state);
            }
            List items = level.method_18467(class_1542.class, aabb);
            if (!level.field_9236) {
                for (class_1542 item : items) {
                    if (!item.method_5805()) continue;
                    class_1799 stack = item.method_6983();
                    if (((ItemFlagsComponent)EntityComponents.INTERNAL_ITEM.get((Object)item)).alfPortalSpawned) continue;
                    item.method_31472();
                    if (self.validateItemUsage(item)) {
                        self.addItem(stack);
                    }
                    self.ticksSinceLastItem = 0;
                }
            }
            if (!level.field_9236 && !self.stacksIn.isEmpty() && self.ticksSinceLastItem >= 4) {
                self.resolveRecipes();
            }
        }
        if (self.closeNow) {
            if (!level.field_9236) {
                level.method_8501(worldPosition, ModBlocks.alfPortal.method_9564());
            }
            for (int i = 0; i < 36; ++i) {
                self.blockParticle(state);
            }
            self.closeNow = false;
        } else if (newState != state) {
            if (newState == AlfPortalState.OFF) {
                for (int i = 0; i < 36; ++i) {
                    self.blockParticle(state);
                }
            }
            if (!level.field_9236) {
                level.method_8501(worldPosition, (class_2680)blockState.method_11657(BotaniaStateProps.ALFPORTAL_STATE, (Comparable)((Object)newState)));
            }
        } else if (self.explode) {
            class_1657 entity;
            level.method_8437(null, (double)worldPosition.method_10263() + 0.5, (double)worldPosition.method_10264() + 2.0, (double)worldPosition.method_10260() + 0.5, 3.0f, class_1927.class_4179.field_18686);
            self.explode = false;
            if (!level.field_9236 && self.breadPlayer != null && (entity = level.method_18470(self.breadPlayer)) instanceof class_3222) {
                AlfPortalBreadTrigger.INSTANCE.trigger((class_3222)entity, worldPosition);
            }
            self.breadPlayer = null;
        }
    }

    private boolean validateItemUsage(class_1542 entity) {
        class_1799 inputStack = entity.method_6983();
        for (class_1860 recipe : ModRecipeTypes.getRecipes(this.field_11863, ModRecipeTypes.ELVEN_TRADE_TYPE).values()) {
            if (!(recipe instanceof IElvenTradeRecipe) || !((IElvenTradeRecipe)recipe).containsItem(inputStack)) continue;
            return true;
        }
        if (inputStack.method_31574(class_1802.field_8229)) {
            this.explode = true;
            this.breadPlayer = entity.method_6978();
        }
        return false;
    }

    private void blockParticle(AlfPortalState state) {
        double dh;
        double dy = switch (this.field_11863.field_9229.nextInt(9)) {
            case 0 -> {
                dh = 0.0;
                yield 1.0;
            }
            case 1 -> {
                dh = 0.0;
                yield 2.0;
            }
            case 2 -> {
                dh = 0.0;
                yield 3.0;
            }
            case 3 -> {
                dh = -1.0;
                yield 1.0;
            }
            case 4 -> {
                dh = -1.0;
                yield 2.0;
            }
            case 5 -> {
                dh = -1.0;
                yield 3.0;
            }
            case 6 -> {
                dh = 1.0;
                yield 1.0;
            }
            case 7 -> {
                dh = 1.0;
                yield 2.0;
            }
            case 8 -> {
                dh = 1.0;
                yield 3.0;
            }
            default -> throw new AssertionError();
        };
        double dx = state == AlfPortalState.ON_X ? 0.0 : dh;
        double dz = state == AlfPortalState.ON_Z ? 0.0 : dh;
        float motionMul = 0.2f;
        WispParticleData data = WispParticleData.wisp((float)(Math.random() * (double)0.15f + (double)0.1f), (float)(Math.random() * 0.25), (float)(Math.random() * 0.5 + 0.5), (float)(Math.random() * 0.25));
        this.field_11863.method_8406((class_2394)data, (double)this.method_11016().method_10263() + dx, (double)this.method_11016().method_10264() + dy, (double)this.method_11016().method_10260() + dz, (double)((float)(Math.random() - 0.5) * motionMul), (double)((float)(Math.random() - 0.5) * motionMul), (double)((float)(Math.random() - 0.5) * motionMul));
    }

    @Override
    public boolean onUsedByWand(@Nullable class_1657 player, class_1799 stack, class_2350 side) {
        AlfPortalState newState;
        AlfPortalState state = (AlfPortalState)((Object)this.method_11010().method_11654(BotaniaStateProps.ALFPORTAL_STATE));
        if (state == AlfPortalState.OFF && (newState = this.getValidState()) != AlfPortalState.OFF) {
            this.field_11863.method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657(BotaniaStateProps.ALFPORTAL_STATE, (Comparable)((Object)newState)));
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                AlfPortalTrigger.INSTANCE.trigger(serverPlayer, serverPlayer.method_14220(), this.method_11016(), stack);
            }
            return true;
        }
        return false;
    }

    private class_238 getPortalAABB() {
        class_238 aabb = new class_238(this.field_11867.method_10069(-1, 1, 0), this.field_11867.method_10069(2, 4, 1));
        if (this.method_11010().method_11654(BotaniaStateProps.ALFPORTAL_STATE) == AlfPortalState.ON_X) {
            aabb = new class_238(this.field_11867.method_10069(0, 1, -1), this.field_11867.method_10069(1, 4, 2));
        }
        return aabb;
    }

    private void addItem(class_1799 stack) {
        int size = stack.method_7947();
        stack.method_7939(1);
        for (int i = 0; i < size; ++i) {
            this.stacksIn.add(stack.method_7972());
        }
    }

    public static Collection<IElvenTradeRecipe> elvenTradeRecipes(class_1937 world) {
        return ModRecipeTypes.getRecipes(world, ModRecipeTypes.ELVEN_TRADE_TYPE).values();
    }

    private void resolveRecipes() {
        List<class_2338> pylons = this.locatePylons();
        for (class_1860 r : ModRecipeTypes.getRecipes(this.field_11863, ModRecipeTypes.ELVEN_TRADE_TYPE).values()) {
            IElvenTradeRecipe recipe;
            Optional<List<class_1799>> match;
            if (!(r instanceof IElvenTradeRecipe) || !(match = (recipe = (IElvenTradeRecipe)r).match(this.stacksIn)).isPresent()) continue;
            if (!this.consumeMana(pylons, 500, false)) break;
            List<class_1799> inputs = match.get();
            for (class_1799 stack : inputs) {
                this.stacksIn.remove(stack);
            }
            for (class_1799 output : recipe.getOutputs(inputs)) {
                this.spawnItem(output.method_7972());
            }
        }
    }

    private void spawnItem(class_1799 stack) {
        class_1542 item = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.5, (double)this.field_11867.method_10260() + 0.5, stack);
        ((ItemFlagsComponent)EntityComponents.INTERNAL_ITEM.get((Object)item)).alfPortalSpawned = true;
        this.field_11863.method_8649((class_1297)item);
        this.ticksSinceLastItem = 0;
    }

    @Override
    public void method_11007(class_2487 cmp) {
        super.method_11007(cmp);
        cmp.method_10569(TAG_STACK_COUNT, this.stacksIn.size());
        int i = 0;
        for (class_1799 stack : this.stacksIn) {
            class_2487 stackcmp = stack.method_7953(new class_2487());
            cmp.method_10566(TAG_STACK + i, (class_2520)stackcmp);
            ++i;
        }
    }

    @Override
    public void method_11014(@Nonnull class_2487 cmp) {
        super.method_11014(cmp);
        int count = cmp.method_10550(TAG_STACK_COUNT);
        this.stacksIn.clear();
        for (int i = 0; i < count; ++i) {
            class_2487 stackcmp = cmp.method_10562(TAG_STACK + i);
            class_1799 stack = class_1799.method_7915((class_2487)stackcmp);
            this.stacksIn.add(stack);
        }
    }

    @Override
    public void writePacketNBT(class_2487 cmp) {
        cmp.method_10569(TAG_TICKS_OPEN, this.ticksOpen);
        cmp.method_10569(TAG_TICKS_SINCE_LAST_ITEM, this.ticksSinceLastItem);
    }

    @Override
    public void readPacketNBT(class_2487 cmp) {
        this.ticksOpen = cmp.method_10550(TAG_TICKS_OPEN);
        this.ticksSinceLastItem = cmp.method_10550(TAG_TICKS_SINCE_LAST_ITEM);
    }

    private AlfPortalState getValidState() {
        class_2470 rot = MULTIBLOCK.get().validate(this.field_11863, this.method_11016());
        if (rot == null) {
            return AlfPortalState.OFF;
        }
        this.lightPylons();
        return switch (rot) {
            default -> throw new IncompatibleClassChangeError();
            case class_2470.field_11467, class_2470.field_11464 -> AlfPortalState.ON_Z;
            case class_2470.field_11463, class_2470.field_11465 -> AlfPortalState.ON_X;
        };
    }

    public List<class_2338> locatePylons() {
        int range = 5;
        class_2680 pylonState = ModBlocks.naturaPylon.method_9564();
        return class_2338.method_20437((class_2338)this.method_11016().method_10069(-range, -range, -range), (class_2338)this.method_11016().method_10069(range, range, range)).filter(arg_0 -> ((class_1937)this.field_11863).method_22340(arg_0)).filter(p -> this.field_11863.method_8320(p) == pylonState && this.field_11863.method_8320(p.method_10074()).method_26204() instanceof BlockPool).map(class_2338::method_10062).collect(Collectors.toList());
    }

    public void lightPylons() {
        if (this.ticksOpen < 50) {
            return;
        }
        List<class_2338> pylons = this.locatePylons();
        for (class_2338 pos : pylons) {
            class_2586 tile = this.field_11863.method_8321(pos);
            if (!(tile instanceof TilePylon)) continue;
            TilePylon pylon = (TilePylon)tile;
            pylon.activated = true;
            pylon.centerPos = this.method_11016();
        }
        if (this.ticksOpen == 50) {
            this.consumeMana(pylons, 200000, true);
        }
    }

    public boolean consumeMana(List<class_2338> pylons, int totalCost, boolean close) {
        ArrayList<TilePool> consumePools = new ArrayList<TilePool>();
        int consumed = 0;
        if (pylons.size() < 2) {
            this.closeNow = true;
            return false;
        }
        int costPer = Math.max(1, totalCost / pylons.size());
        int expectedConsumption = costPer * pylons.size();
        for (class_2338 pos : pylons) {
            class_2586 tile = this.field_11863.method_8321(pos);
            if (tile instanceof TilePylon) {
                TilePylon pylon = (TilePylon)tile;
                pylon.activated = true;
                pylon.centerPos = this.method_11016();
            }
            if (!((tile = this.field_11863.method_8321(pos.method_10074())) instanceof TilePool)) continue;
            TilePool pool = (TilePool)tile;
            if (pool.getCurrentMana() < costPer) {
                this.closeNow = this.closeNow || close;
                return false;
            }
            if (this.field_11863.field_9236) continue;
            consumePools.add(pool);
            consumed += costPer;
        }
        if (consumed >= expectedConsumption) {
            for (TilePool pool : consumePools) {
                pool.receiveMana(-costPer);
            }
            return true;
        }
        return false;
    }
}

