/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_247;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.IPetalApothecary;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileAltar;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.core.helper.InventoryHelper;
import vazkii.botania.common.item.ModItems;

public class BlockAltar
extends BlockMod
implements class_2343 {
    public static final class_2754<IPetalApothecary.State> FLUID = class_2754.method_11850((String)"fluid", IPetalApothecary.State.class);
    private static final class_265 BASE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final class_265 MIDDLE = class_2248.method_9541((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    private static final class_265 TOP = class_2248.method_9541((double)2.0, (double)12.0, (double)2.0, (double)14.0, (double)20.0, (double)14.0);
    private static final class_265 TOP_CUTOUT = class_2248.method_9541((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)20.0, (double)13.0);
    private static final class_265 SHAPE = class_259.method_1084((class_265)class_259.method_1084((class_265)BASE, (class_265)MIDDLE), (class_265)class_259.method_1072((class_265)TOP, (class_265)TOP_CUTOUT, (class_247)class_247.field_16886));
    public final Variant variant;

    protected BlockAltar(Variant v, class_4970.class_2251 builder) {
        super(builder);
        this.variant = v;
        this.method_9590((class_2680)this.method_9564().method_11657(FLUID, (Comparable)((Object)IPetalApothecary.State.EMPTY)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FLUID});
    }

    @Nonnull
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
        return SHAPE;
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        TileAltar tile;
        if (!world.field_9236 && entity instanceof class_1542 && (tile = (TileAltar)world.method_8321(pos)).collideEntityItem((class_1542)entity)) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile);
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        TileAltar tile = (TileAltar)world.method_8321(pos);
        IPetalApothecary.State fluid = tile.getFluid();
        class_1799 stack = player.method_5998(hand);
        if (player.method_5715()) {
            InventoryHelper.withdrawFromInventory(tile, player);
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile);
            return class_1269.field_5812;
        }
        if (tile.isEmpty() && fluid == IPetalApothecary.State.WATER && stack.method_7960()) {
            tile.trySetLastRecipe(player);
            return class_1269.field_5812;
        }
        if (this.tryWithdrawFluid(player, hand, tile) || this.tryDepositFluid(player, hand, tile)) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public void method_9504(class_2680 state, class_1937 world, class_2338 pos, class_1959.class_1963 precipitation) {
        if (world.field_9229.nextInt(20) == 1 && state.method_11654(FLUID) == IPetalApothecary.State.EMPTY) {
            world.method_8501(pos, (class_2680)state.method_11657(FLUID, (Comparable)((Object)IPetalApothecary.State.WATER)));
        }
    }

    private boolean tryWithdrawFluid(class_1657 player, class_1268 hand, TileAltar altar) {
        class_3611 fluid = altar.getFluid().asVanilla();
        if (fluid == class_3612.field_15906 || fluid == class_3612.field_15910 && Botania.gardenOfGlassLoaded) {
            return false;
        }
        ContainerItemContext context = ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand);
        Storage fluidStorage = (Storage)context.find(FluidStorage.ITEM);
        if (fluidStorage == null) {
            return false;
        }
        try (Transaction txn = Transaction.openOuter();){
            long inserted = fluidStorage.insert((Object)FluidVariant.of((class_3611)fluid), 81000L, (TransactionContext)txn);
            if (inserted == 81000L) {
                if (!player.method_31549().field_7477) {
                    txn.commit();
                }
                altar.setFluid(IPetalApothecary.State.EMPTY);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private boolean tryDepositFluid(class_1657 player, class_1268 hand, TileAltar altar) {
        long extracted;
        if (altar.getFluid() != IPetalApothecary.State.EMPTY) {
            return false;
        }
        class_1799 stack = player.method_5998(hand);
        if (!stack.method_7960() && stack.method_31574(ModItems.waterRod) && ManaItemHandler.instance().requestManaExact(stack, player, 75, false)) {
            ManaItemHandler.instance().requestManaExact(stack, player, 75, true);
            altar.setFluid(IPetalApothecary.State.WATER);
            return true;
        }
        ContainerItemContext context = ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand);
        Storage fluidStorage = (Storage)context.find(FluidStorage.ITEM);
        if (fluidStorage == null) {
            return false;
        }
        try (Transaction txn = Transaction.openOuter();){
            extracted = fluidStorage.extract((Object)FluidVariant.of((class_3611)class_3612.field_15910), 81000L, (TransactionContext)txn);
            if (extracted == 81000L) {
                if (!player.method_31549().field_7477) {
                    txn.commit();
                }
                altar.setFluid(IPetalApothecary.State.WATER);
                boolean bl = true;
                return bl;
            }
        }
        txn = Transaction.openOuter();
        try {
            extracted = fluidStorage.extract((Object)FluidVariant.of((class_3611)class_3612.field_15908), 81000L, (TransactionContext)txn);
            if (extracted == 81000L) {
                if (!player.method_31549().field_7477) {
                    txn.commit();
                }
                altar.setFluid(IPetalApothecary.State.LAVA);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (txn != null) {
                txn.close();
            }
        }
        return false;
    }

    @Nonnull
    public class_2586 method_10123(@Nonnull class_2338 pos, @Nonnull class_2680 state) {
        return new TileAltar(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        if (level.field_9236) {
            return BlockAltar.createTickerHelper(type, ModTiles.ALTAR, TileAltar::clientTick);
        }
        return BlockAltar.createTickerHelper(type, ModTiles.ALTAR, TileAltar::serverTick);
    }

    public void method_9536(@Nonnull class_2680 state, @Nonnull class_1937 world, @Nonnull class_2338 pos, @Nonnull class_2680 newState, boolean isMoving) {
        if (!state.method_27852(newState.method_26204())) {
            class_2586 be = world.method_8321(pos);
            if (be instanceof TileSimpleInventory) {
                class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)((TileSimpleInventory)be).getItemHandler());
            }
            super.method_9536(state, world, pos, newState, isMoving);
        }
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return state.method_11654(FLUID) == IPetalApothecary.State.WATER ? 15 : 0;
    }

    public static enum Variant {
        DEFAULT,
        FOREST,
        PLAINS,
        MOUNTAIN,
        FUNGAL,
        SWAMP,
        DESERT,
        TAIGA,
        MESA,
        MOSSY;

    }
}

