/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common;

import com.mojang.brigadier.CommandDispatcher;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.loot.v1.event.LootTableLoadingCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1767;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block.IHornHarvestable;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.mana.ManaNetworkCallback;
import vazkii.botania.client.fx.ModParticles;
import vazkii.botania.common.advancements.ModCriteriaTriggers;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.block.string.BlockRedStringInterceptor;
import vazkii.botania.common.block.subtile.functional.SubTileTigerseye;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileAlfPortal;
import vazkii.botania.common.block.tile.TileCraftCrate;
import vazkii.botania.common.block.tile.TileEnchanter;
import vazkii.botania.common.block.tile.TileTerraPlate;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex;
import vazkii.botania.common.brew.ModBrews;
import vazkii.botania.common.brew.ModPotions;
import vazkii.botania.common.core.ModStats;
import vazkii.botania.common.core.command.SkyblockCommand;
import vazkii.botania.common.core.handler.CommonTickHandler;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.ContributorList;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.handler.ManaNetworkHandler;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.handler.OrechidManager;
import vazkii.botania.common.core.handler.PaintableData;
import vazkii.botania.common.core.handler.PixieHandler;
import vazkii.botania.common.core.helper.ColorHelper;
import vazkii.botania.common.core.loot.LootHandler;
import vazkii.botania.common.core.loot.ModLootModifiers;
import vazkii.botania.common.core.proxy.IProxy;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.impl.BotaniaAPIImpl;
import vazkii.botania.common.impl.corporea.CorporeaItemStackMatcher;
import vazkii.botania.common.impl.corporea.CorporeaStringMatcher;
import vazkii.botania.common.item.ItemGrassSeeds;
import vazkii.botania.common.item.ItemKeepIvy;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.bauble.ItemFlightTiara;
import vazkii.botania.common.item.material.ItemEnderAir;
import vazkii.botania.common.item.relic.ItemLokiRing;
import vazkii.botania.common.item.rod.ItemGravityRod;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.common.network.PacketHandler;
import vazkii.botania.common.world.ModFeatures;
import vazkii.botania.common.world.SkyblockChunkGenerator;
import vazkii.botania.common.world.SkyblockWorldEvents;
import vazkii.botania.data.DataGenerators;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI;

public class Botania
implements ModInitializer {
    public static boolean gardenOfGlassLoaded = false;
    public static boolean trinketsLoaded = false;
    public static IProxy proxy = new IProxy(){};
    public static Consumer<Supplier<Runnable>> runOnClient = s -> {};
    public static volatile boolean configLoaded = false;
    public static MinecraftServer currentServer;
    public static final Logger LOGGER;

    public void onInitialize() {
        gardenOfGlassLoaded = FabricLoader.getInstance().isModLoaded("gardenofglass");
        trinketsLoaded = FabricLoader.getInstance().isModLoaded("trinkets");
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            runOnClient = t -> ((Runnable)t.get()).run();
        }
        ConfigHandler.setup();
        EquipmentHandler.init();
        ModFeatures.registerFeatures();
        ModItems.registerItems();
        ModItems.registerRecipeSerializers();
        ModEntities.registerEntities();
        ModRecipeTypes.registerRecipeTypes();
        ModSounds.init();
        ModBrews.registerBrews();
        ModPotions.registerPotions();
        ModBlocks.registerBlocks();
        ModBlocks.registerItemBlocks();
        ModTiles.registerTiles();
        ModFluffBlocks.registerBlocks();
        ModFluffBlocks.registerItemBlocks();
        ModParticles.registerParticles();
        ModSubtiles.registerBlocks();
        ModSubtiles.registerItemBlocks();
        ModSubtiles.registerTEs();
        PixieHandler.registerAttribute();
        this.commonSetup();
        ServerLifecycleEvents.SERVER_STARTING.register(this::serverStarting);
        ServerLifecycleEvents.SERVER_STARTED.register(this::serverAboutToStart);
        CommandRegistrationCallback.EVENT.register(this::registerCommands);
        ServerLifecycleEvents.SERVER_STOPPING.register(this::serverStopping);
        UseBlockCallback.EVENT.register(ItemLokiRing::onPlayerInteract);
        UseItemCallback.EVENT.register(ItemEnderAir::onPlayerInteract);
        ServerTickEvents.END_WORLD_TICK.register(ItemGrassSeeds::onTickEnd);
        ServerPlayerEvents.AFTER_RESPAWN.register(ItemKeepIvy::onPlayerRespawn);
        ServerTickEvents.END_WORLD_TICK.register(CommonTickHandler::onTick);
        UseBlockCallback.EVENT.register(BlockRedStringInterceptor::onInteract);
        ManaNetworkCallback.EVENT.register(ManaNetworkHandler.instance::onNetworkEvent);
        LootTableLoadingCallback.EVENT.register(LootHandler::lootLoad);
        ServerPlayConnectionEvents.DISCONNECT.register(ItemFlightTiara::playerLoggedOut);
        ServerEntityEvents.ENTITY_LOAD.register(SubTileTigerseye::pacifyAfterLoad);
        AttackEntityCallback.EVENT.register(ItemGravityRod::onAttack);
        OrechidManager.registerListener();
        TileCraftCrate.registerListener();
        ModLootModifiers.init();
        ModCriteriaTriggers.init();
    }

    private void commonSetup() {
        PacketHandler.init();
        PaintableData.init();
        CorporeaHelper.instance().registerRequestMatcher(ResourceLocationHelper.prefix("string"), CorporeaStringMatcher.class, CorporeaStringMatcher::createFromNBT);
        CorporeaHelper.instance().registerRequestMatcher(ResourceLocationHelper.prefix("item_stack"), CorporeaItemStackMatcher.class, CorporeaItemStackMatcher::createFromNBT);
        if (gardenOfGlassLoaded) {
            UseBlockCallback.EVENT.register(SkyblockWorldEvents::onPlayerInteract);
        }
        SkyblockChunkGenerator.init();
        ModEntities.registerAttributes();
        PatchouliAPI.get().registerMultiblock(class_2378.field_11146.method_10221((Object)ModBlocks.alfPortal), TileAlfPortal.MULTIBLOCK.get());
        PatchouliAPI.get().registerMultiblock(class_2378.field_11146.method_10221((Object)ModBlocks.terraPlate), TileTerraPlate.MULTIBLOCK.get());
        PatchouliAPI.get().registerMultiblock(class_2378.field_11146.method_10221((Object)ModBlocks.enchanter), TileEnchanter.MULTIBLOCK.get());
        String[][] pat = new String[][]{{"P_______P", "_________", "_________", "_________", "_________", "_________", "_________", "_________", "P_______P"}, {"_________", "_________", "_________", "_________", "____B____", "_________", "_________", "_________", "_________"}, {"_________", "_________", "_________", "___III___", "___I0I___", "___III___", "_________", "_________", "_________"}};
        IStateMatcher sm = PatchouliAPI.get().predicateMatcher(class_2246.field_10085, state -> state.method_26164((class_3494)class_3481.field_22275));
        IMultiblock mb = PatchouliAPI.get().makeMultiblock(pat, new Object[]{Character.valueOf('P'), ModBlocks.gaiaPylon, Character.valueOf('B'), class_2246.field_10327, Character.valueOf('I'), sm, Character.valueOf('0'), sm});
        PatchouliAPI.get().registerMultiblock(ResourceLocationHelper.prefix("gaia_ritual"), mb);
        ModBlocks.addDispenserBehaviours();
        ModStats.init();
        this.registerPaintables();
        IHornHarvestable.API.registerForBlocks((w, p, s, be, c) -> (world, pos, stack, hornType) -> hornType == IHornHarvestable.EnumHornType.CANOPY, new class_2248[]{class_2246.field_10597, class_2246.field_28675, class_2246.field_28676, class_2246.field_23078, class_2246.field_23079, class_2246.field_22123, class_2246.field_22124});
    }

    private void registerPaintables() {
        BotaniaAPI.instance().registerPaintableBlock(class_2246.field_10033, ColorHelper.STAINED_GLASS_MAP);
        for (class_1767 color : class_1767.values()) {
            BotaniaAPI.instance().registerPaintableBlock(ColorHelper.STAINED_GLASS_MAP.apply(color), ColorHelper.STAINED_GLASS_MAP);
        }
        BotaniaAPI.instance().registerPaintableBlock(class_2246.field_10285, ColorHelper.STAINED_GLASS_PANE_MAP);
        for (class_1767 color : class_1767.values()) {
            BotaniaAPI.instance().registerPaintableBlock(ColorHelper.STAINED_GLASS_PANE_MAP.apply(color), ColorHelper.STAINED_GLASS_PANE_MAP);
        }
        BotaniaAPI.instance().registerPaintableBlock(class_2246.field_10415, ColorHelper.TERRACOTTA_MAP);
        for (class_1767 color : class_1767.values()) {
            BotaniaAPI.instance().registerPaintableBlock(ColorHelper.TERRACOTTA_MAP.apply(color), ColorHelper.TERRACOTTA_MAP);
        }
        for (class_1767 color : class_1767.values()) {
            BotaniaAPI.instance().registerPaintableBlock(ColorHelper.GLAZED_TERRACOTTA_MAP.apply(color), ColorHelper.GLAZED_TERRACOTTA_MAP);
        }
        for (class_1767 color : class_1767.values()) {
            BotaniaAPI.instance().registerPaintableBlock(ColorHelper.WOOL_MAP.apply(color), ColorHelper.WOOL_MAP);
        }
        for (class_1767 color : class_1767.values()) {
            BotaniaAPI.instance().registerPaintableBlock(ColorHelper.CARPET_MAP.apply(color), ColorHelper.CARPET_MAP);
        }
        for (class_1767 color : class_1767.values()) {
            BotaniaAPI.instance().registerPaintableBlock(ColorHelper.CONCRETE_MAP.apply(color), ColorHelper.CONCRETE_MAP);
        }
        for (class_1767 color : class_1767.values()) {
            BotaniaAPI.instance().registerPaintableBlock(ColorHelper.CONCRETE_POWDER_MAP.apply(color), ColorHelper.CONCRETE_POWDER_MAP);
        }
    }

    private void serverStarting(MinecraftServer server) {
        currentServer = server;
    }

    private void serverAboutToStart(MinecraftServer server) {
        if (BotaniaAPI.instance().getClass() != BotaniaAPIImpl.class) {
            String clname = BotaniaAPI.instance().getClass().getName();
            throw new IllegalAccessError("The Botania API has been overriden. This will cause crashes and compatibility issues, and that's why it's marked as \"Do not Override\". Whoever had the brilliant idea of overriding it needs to go back to elementary school and learn to read. (Actual classname: " + clname + ")");
        }
        if (server.method_3816()) {
            ContributorList.firstStart();
        }
    }

    private void registerCommands(CommandDispatcher<class_2168> dispatcher, boolean dedicated) {
        if (gardenOfGlassLoaded) {
            SkyblockCommand.register(dispatcher);
        }
        DataGenerators.registerCommands(dispatcher);
    }

    private void serverStopping(MinecraftServer server) {
        ManaNetworkHandler.instance.clear();
        TileCorporeaIndex.clearIndexCache();
        currentServer = null;
    }

    static {
        LOGGER = LogManager.getLogger((String)"botania");
    }
}

