/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.google.common.base.Suppliers;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.minecraft.class_1160;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_809;
import net.minecraft.class_827;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.model.IPylonModel;
import vazkii.botania.client.model.ModModelLayers;
import vazkii.botania.client.model.ModelPylonGaia;
import vazkii.botania.client.model.ModelPylonMana;
import vazkii.botania.client.model.ModelPylonNatura;
import vazkii.botania.common.block.BlockPylon;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TilePylon;

public class RenderTilePylon
implements class_827<TilePylon> {
    public static final class_2960 MANA_TEXTURE = new class_2960("botania:textures/model/pylon_mana.png");
    public static final class_2960 NATURA_TEXTURE = new class_2960("botania:textures/model/pylon_natura.png");
    public static final class_2960 GAIA_TEXTURE = new class_2960("botania:textures/model/pylon_gaia.png");
    private final ModelPylonMana manaModel;
    private final ModelPylonNatura naturaModel;
    private final ModelPylonGaia gaiaModel;
    private static BlockPylon.Variant forceVariant = BlockPylon.Variant.MANA;
    private static class_809.class_811 forceTransform = class_809.class_811.field_4315;

    public RenderTilePylon(class_5614.class_5615 ctx) {
        this.manaModel = new ModelPylonMana(ctx.method_32140(ModModelLayers.PYLON_MANA));
        this.naturaModel = new ModelPylonNatura(ctx.method_32140(ModModelLayers.PYLON_NATURA));
        this.gaiaModel = new ModelPylonGaia(ctx.method_32140(ModModelLayers.PYLON_GAIA));
    }

    public void render(@Nonnull TilePylon pylon, float pticks, class_4587 ms, class_4597 buffers, int light, int overlay) {
        this.renderPylon(pylon, pticks, ms, buffers, light, overlay);
    }

    private void renderPylon(@Nullable TilePylon pylon, float pticks, class_4587 ms, class_4597 buffers, int light, int overlay) {
        class_2960 texture;
        IPylonModel model;
        boolean renderingItem = pylon == null;
        boolean direct = renderingItem && (forceTransform == class_809.class_811.field_4317 || forceTransform.method_29998());
        BlockPylon.Variant type = renderingItem ? forceVariant : ((BlockPylon)pylon.method_11010().method_26204()).variant;
        class_1921 shaderLayer = switch (type) {
            default -> {
                model = this.manaModel;
                texture = MANA_TEXTURE;
                yield direct ? RenderHelper.MANA_PYLON_GLOW_DIRECT : RenderHelper.MANA_PYLON_GLOW;
            }
            case BlockPylon.Variant.NATURA -> {
                model = this.naturaModel;
                texture = NATURA_TEXTURE;
                yield direct ? RenderHelper.NATURA_PYLON_GLOW_DIRECT : RenderHelper.NATURA_PYLON_GLOW;
            }
            case BlockPylon.Variant.GAIA -> {
                model = this.gaiaModel;
                texture = GAIA_TEXTURE;
                yield direct ? RenderHelper.GAIA_PYLON_GLOW_DIRECT : RenderHelper.GAIA_PYLON_GLOW;
            }
        };
        ms.method_22903();
        float worldTime = (float)ClientTickHandler.ticksInGame + pticks;
        worldTime += pylon == null ? 0.0f : (float)new Random(pylon.method_11016().hashCode()).nextInt(360);
        ms.method_22904(0.0, pylon == null ? 1.35 : 1.5, 0.0);
        ms.method_22905(1.0f, -1.0f, -1.0f);
        ms.method_22903();
        ms.method_22904(0.5, 0.0, -0.5);
        if (pylon != null) {
            ms.method_22907(class_1160.field_20705.method_23214(worldTime * 1.5f));
        }
        class_1921 layer = class_1921.method_23580((class_2960)texture);
        class_4588 buffer = buffers.getBuffer(layer);
        model.renderRing(ms, buffer, light, overlay);
        if (pylon != null) {
            ms.method_22904(0.0, Math.sin((double)worldTime / 20.0) / 20.0 - 0.025, 0.0);
        }
        ms.method_22909();
        ms.method_22903();
        if (pylon != null) {
            ms.method_22904(0.0, Math.sin((double)worldTime / 20.0) / 17.5, 0.0);
        }
        ms.method_22904(0.5, 0.0, -0.5);
        if (pylon != null) {
            ms.method_22907(class_1160.field_20705.method_23214(-worldTime));
        }
        buffer = buffers.getBuffer(shaderLayer);
        model.renderCrystal(ms, buffer, light, overlay);
        ms.method_22909();
        ms.method_22909();
    }

    public static class TEISR
    implements BuiltinItemRendererRegistry.DynamicItemRenderer {
        private static final Supplier<TilePylon> DUMMY = Suppliers.memoize(() -> new TilePylon(new class_2338(0, Integer.MIN_VALUE, 0), ModBlocks.manaPylon.method_9564()));

        public void render(class_1799 stack, class_809.class_811 type, class_4587 ms, class_4597 buffers, int light, int overlay) {
            if (class_2248.method_9503((class_1792)stack.method_7909()) instanceof BlockPylon) {
                forceVariant = ((BlockPylon)class_2248.method_9503((class_1792)stack.method_7909())).variant;
                forceTransform = type;
                class_827 r = class_310.method_1551().method_31975().method_3550((class_2586)DUMMY.get());
                if (r instanceof RenderTilePylon) {
                    ((RenderTilePylon)r).renderPylon(null, 0.0f, ms, buffers, light, overlay);
                }
            }
        }
    }
}

