/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.patchouli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3956;
import vazkii.botania.common.Botania;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.patchouli.api.IVariable;

public class PatchouliUtils {
    private static boolean crafttweakerInfoNote = false;

    public static <T extends class_1860<C>, C extends class_1263> T getRecipe(class_3956<T> type, class_2960 id) {
        Map map = ModRecipeTypes.getRecipes((class_1937)class_310.method_1551().field_1687, type);
        class_1860 r = map.get(id);
        if (r != null) {
            return (T)r;
        }
        r = map.get(new class_2960("crafttweaker", id.method_12832()));
        if (r != null) {
            return (T)r;
        }
        r = map.get(new class_2960("crafttweaker", "autogenerated/" + id.method_12836() + "." + id.method_12832()));
        if (r != null) {
            return (T)r;
        }
        Botania.LOGGER.warn("Template references nonexistent recipe {} of type {}", (Object)id, type);
        if (!crafttweakerInfoNote) {
            crafttweakerInfoNote = true;
            if (FabricLoader.getInstance().isModLoaded("crafttweaker")) {
                Botania.LOGGER.info("To add a recipe that replaces a builtin recipe with CT, \nadd one with the same type, named the same as the path of the missing recipe.\neg. for recipe {}, add a recipe named \"{}\".", (Object)id, (Object)id.method_12832());
            }
        }
        return null;
    }

    public static <T extends class_1860<C>, C extends class_1263> List<T> getRecipeGroup(class_3956<T> type, String group) {
        Map map = ModRecipeTypes.getRecipes((class_1937)class_310.method_1551().field_1687, type);
        ArrayList list = new ArrayList();
        for (class_1860 value : map.values()) {
            if (!group.equals(value.method_8112())) continue;
            list.add(value);
        }
        if (list.isEmpty()) {
            Botania.LOGGER.warn("Template references empty group {} of recipe type {}", (Object)group, type);
        }
        return list;
    }

    public static IVariable interweaveIngredients(List<class_1856> ingredients, int longestIngredientSize) {
        if (ingredients.size() == 1) {
            return IVariable.wrapList((Iterable)Arrays.stream(ingredients.get(0).method_8105()).map(IVariable::from).collect(Collectors.toList()));
        }
        class_1799[] empty = new class_1799[]{class_1799.field_8037};
        ArrayList<class_1799[]> stacks = new ArrayList<class_1799[]>();
        for (class_1856 ingredient : ingredients) {
            if (ingredient != null && !ingredient.method_8103()) {
                stacks.add(ingredient.method_8105());
                continue;
            }
            stacks.add(empty);
        }
        ArrayList<IVariable> list = new ArrayList<IVariable>(stacks.size() * longestIngredientSize);
        for (int i = 0; i < longestIngredientSize; ++i) {
            for (class_1799[] stack : stacks) {
                list.add(IVariable.from((Object)stack[i % stack.length]));
            }
        }
        return IVariable.wrapList(list);
    }

    public static IVariable interweaveIngredients(List<class_1856> ingredients) {
        return PatchouliUtils.interweaveIngredients(ingredients, ingredients.stream().mapToInt(ingr -> ingr.method_8105().length).max().orElse(1));
    }
}

