/*
 * Decompiled with CFR 0.152.
 */
package terrablender.worldgen.noise;

import java.util.function.Function;
import java.util.function.LongFunction;
import terrablender.api.BiomeProvider;
import terrablender.core.TerraBlender;
import terrablender.worldgen.noise.Area;
import terrablender.worldgen.noise.AreaContext;
import terrablender.worldgen.noise.AreaFactory;
import terrablender.worldgen.noise.AreaTransformer1;
import terrablender.worldgen.noise.InitialLayer;
import terrablender.worldgen.noise.ZoomLayer;

public class LayeredNoiseUtil {
    public static Area uniqueness(long worldSeed, UniquenessType type) {
        int regionSize;
        Function<BiomeProvider, Integer> weightGetter = switch (type) {
            case UniquenessType.OVERWORLD_LARGE -> {
                regionSize = TerraBlender.CONFIG.overworldLargeBiomesRegionSize;
                yield BiomeProvider::getOverworldWeight;
            }
            case UniquenessType.NETHER -> {
                regionSize = TerraBlender.CONFIG.netherRegionSize;
                yield BiomeProvider::getNetherWeight;
            }
            case UniquenessType.NETHER_LARGE -> {
                regionSize = TerraBlender.CONFIG.netherLargeBiomesRegionSize;
                yield BiomeProvider::getNetherWeight;
            }
            default -> {
                regionSize = TerraBlender.CONFIG.overworldRegionSize;
                yield BiomeProvider::getOverworldWeight;
            }
        };
        LongFunction<AreaContext> contextFactory = seedModifier -> new AreaContext(25, worldSeed, seedModifier);
        AreaFactory factory = new InitialLayer(weightGetter).run(contextFactory.apply(1L));
        factory = ZoomLayer.FUZZY.run(contextFactory.apply(2000L), factory);
        factory = LayeredNoiseUtil.zoom(2001L, ZoomLayer.NORMAL, factory, 3, contextFactory);
        factory = LayeredNoiseUtil.zoom(1001L, ZoomLayer.NORMAL, factory, regionSize, contextFactory);
        return factory.make();
    }

    public static AreaFactory zoom(long seedModifier, AreaTransformer1 transformer, AreaFactory initialAreaFactory, int times, LongFunction<AreaContext> contextFactory) {
        AreaFactory areaFactory = initialAreaFactory;
        for (int i = 0; i < times; ++i) {
            areaFactory = transformer.run(contextFactory.apply(seedModifier + (long)i), areaFactory);
        }
        return areaFactory;
    }

    public static enum UniquenessType {
        OVERWORLD,
        OVERWORLD_LARGE,
        NETHER,
        NETHER_LARGE;

    }
}

