/*
 * Decompiled with CFR 0.152.
 */
package terrablender.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_3754;
import net.minecraft.class_5138;
import net.minecraft.class_5216;
import net.minecraft.class_5284;
import net.minecraft.class_5309;
import net.minecraft.class_5321;
import net.minecraft.class_5505;
import net.minecraft.class_5817;
import net.minecraft.class_5818;
import net.minecraft.class_6350;
import net.minecraft.class_6568;
import net.minecraft.class_6746;
import net.minecraft.class_6748;
import net.minecraft.class_6780;
import terrablender.worldgen.IExtendedNoiseBasedChunkGenerator;
import terrablender.worldgen.TBNoiseChunk;
import terrablender.worldgen.TBNoiseSampler;
import terrablender.worldgen.noise.LayeredNoiseUtil;

public class TBNoiseBasedChunkGenerator
extends class_3754
implements IExtendedNoiseBasedChunkGenerator {
    public static final Codec<TBNoiseBasedChunkGenerator> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)class_5505.method_31148((class_5321)class_2378.field_35433).forGetter(instance -> instance.field_35361), (App)class_1966.field_24713.fieldOf("biome_source").forGetter(instance -> instance.field_12761), (App)Codec.LONG.fieldOf("seed").stable().forGetter(instance -> instance.field_24778), (App)class_5284.field_24781.fieldOf("settings").forGetter(instance -> instance.field_24774)).apply((Applicative)builder, builder.stable(TBNoiseBasedChunkGenerator::new)));

    public TBNoiseBasedChunkGenerator(class_2378<class_5216.class_5487> noises, class_1966 biomeSource, long seed, Supplier<class_5284> settings) {
        this(noises, biomeSource, biomeSource, seed, settings);
    }

    private TBNoiseBasedChunkGenerator(class_2378<class_5216.class_5487> noises, class_1966 biomeSource, class_1966 runtimeBiomeSource, long seed, Supplier<class_5284> settings) {
        super(noises, runtimeBiomeSource, seed, settings);
        LayeredNoiseUtil.UniquenessType uniquenessType;
        class_5284 noiseGeneratorSettings = (class_5284)this.field_24774.get();
        class_5309 noiseSettings = noiseGeneratorSettings.method_28559();
        boolean largeBiomes = noiseSettings.comp_262();
        LayeredNoiseUtil.UniquenessType uniquenessType2 = uniquenessType = largeBiomes ? LayeredNoiseUtil.UniquenessType.OVERWORLD_LARGE : LayeredNoiseUtil.UniquenessType.OVERWORLD;
        if (noiseGeneratorSettings.method_28005().method_26204() == class_2246.field_10515 && noiseGeneratorSettings.method_28006().method_26204() == class_2246.field_10164) {
            uniquenessType = largeBiomes ? LayeredNoiseUtil.UniquenessType.NETHER_LARGE : LayeredNoiseUtil.UniquenessType.NETHER;
        }
        this.field_28748 = new TBNoiseSampler(noiseSettings, noiseGeneratorSettings.method_33758(), seed, noises, noiseGeneratorSettings.method_38999(), uniquenessType);
    }

    public CompletableFuture<class_2791> method_38275(class_2378<class_1959> registry, Executor executor, class_6748 blender, class_5138 structureFeatureManager, class_2791 chunkAccess) {
        return CompletableFuture.supplyAsync(class_156.method_37910((String)"init_biomes", () -> {
            this.doCreateBiomes(registry, blender, structureFeatureManager, chunkAccess);
            return chunkAccess;
        }), class_156.method_18349());
    }

    private void doCreateBiomes(class_2378<class_1959> biomeRegistry, class_6748 blender, class_5138 structureManager, class_2791 chunkAccess) {
        TBNoiseChunk noiseChunk = (TBNoiseChunk)this.getOrCreateNoiseChunk(chunkAccess, this.field_28748, () -> new class_5817(structureManager, chunkAccess), (class_5284)this.field_24774.get(), this.field_34591, blender);
        class_6780 biomeresolver = class_6746.method_39767((class_6780)blender.method_39563((class_6780)this.field_24747), biomeRegistry, (class_2791)chunkAccess);
        chunkAccess.method_38257(biomeresolver, (x, y, z) -> ((TBNoiseSampler)this.field_28748).targetTB(x, y, z, noiseChunk.noiseDataTB(x, z)));
    }

    protected Codec<? extends class_2794> method_28506() {
        return CODEC;
    }

    public class_2794 method_27997(long seed) {
        return new TBNoiseBasedChunkGenerator((class_2378<class_5216.class_5487>)this.field_35361, this.field_12761.method_27985(seed), seed, this.field_24774);
    }

    @Override
    public class_6568 forColumn(int x, int z, int cellNoiseMinY, int cellCountY, class_5818 sampler, class_5284 noiseGenSettings, class_6350.class_6565 fluidPicker) {
        return TBNoiseChunk.forColumn(x, z, cellNoiseMinY, cellCountY, (TBNoiseSampler)sampler, noiseGenSettings, fluidPicker);
    }

    @Override
    public class_6568 getOrCreateNoiseChunk(class_2791 chunkAccess, class_5818 sampler, Supplier<class_6568.class_6572> noiseFiller, class_5284 settings, class_6350.class_6565 fluidPicker, class_6748 blender) {
        if (chunkAccess.field_34539 == null) {
            chunkAccess.field_34539 = TBNoiseChunk.forChunk(chunkAccess, (TBNoiseSampler)sampler, noiseFiller, settings, fluidPicker, blender);
        }
        return chunkAccess.field_34539;
    }
}

