/*
 * Decompiled with CFR 0.152.
 */
package terrablender.worldgen;

import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3754;
import net.minecraft.class_4766;
import net.minecraft.class_5284;
import net.minecraft.class_5285;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_6544;
import net.minecraft.class_6686;
import terrablender.api.BiomeProvider;
import terrablender.api.ParameterUtils;
import terrablender.core.TerraBlender;
import terrablender.worldgen.TBClimate;

public class DataPackBiomeProvider
extends BiomeProvider {
    private class_5285 settings;
    private class_2794 overworldGenerator;
    private class_2794 netherGenerator;
    private Optional<class_6686.class_6708> overworldSurfaceRules = Optional.empty();
    private Optional<class_6686.class_6708> netherSurfaceRules = Optional.empty();

    public DataPackBiomeProvider(class_2960 name, int overworldWeight, int netherWeight, class_5285 settings) {
        super(name, overworldWeight, netherWeight);
        class_5363 netherStem;
        this.settings = settings;
        this.overworldGenerator = settings.method_28032();
        if (this.overworldGenerator instanceof class_3754) {
            class_5284 generatorSettings = (class_5284)((class_3754)this.overworldGenerator).field_24774.get();
            this.overworldSurfaceRules = Optional.of(generatorSettings.method_39042());
        }
        class_2794 class_27942 = this.netherGenerator = (netherStem = (class_5363)settings.method_28609().method_29107(class_5363.field_25413)) != null ? netherStem.method_29571() : null;
        if (this.netherGenerator != null && this.netherGenerator instanceof class_3754) {
            class_5284 generatorSettings = (class_5284)((class_3754)this.netherGenerator).field_24774.get();
            this.netherSurfaceRules = Optional.of(generatorSettings.method_39042());
        }
    }

    @Override
    public void addOverworldBiomes(class_2378<class_1959> registry, Consumer<Pair<TBClimate.ParameterPoint, class_5321<class_1959>>> mapper) {
        if (!(this.overworldGenerator.method_12098() instanceof class_4766)) {
            return;
        }
        class_4766 biomeSource = (class_4766)this.overworldGenerator.method_12098();
        class_6544.class_6546 uniquenessParameter = this.getUniquenessParameter();
        TerraBlender.LOGGER.info("Adding overworld biomes for datapack " + this.getName() + " with uniqueness " + uniquenessParameter);
        biomeSource.field_34498.method_38128().stream().forEach(pair -> {
            TBClimate.ParameterPoint parameters = ParameterUtils.convertParameterPoint((class_6544.class_4762)pair.getFirst(), uniquenessParameter);
            Optional key = registry.method_29113((Object)((class_1959)((Supplier)pair.getSecond()).get()));
            if (key.isPresent()) {
                this.addBiome(mapper, parameters, (class_5321<class_1959>)((class_5321)key.get()));
            }
        });
    }

    @Override
    public void addNetherBiomes(class_2378<class_1959> registry, Consumer<Pair<TBClimate.ParameterPoint, class_5321<class_1959>>> mapper) {
        if (this.netherGenerator == null || !(this.netherGenerator.method_12098() instanceof class_4766)) {
            return;
        }
        class_4766 biomeSource = (class_4766)this.netherGenerator.method_12098();
        class_6544.class_6546 uniquenessParameter = this.getUniquenessParameter();
        TerraBlender.LOGGER.info("Adding nether biomes for datapack " + this.getName() + " with uniqueness " + uniquenessParameter);
        biomeSource.field_34498.method_38128().stream().forEach(pair -> {
            TBClimate.ParameterPoint parameters = ParameterUtils.convertParameterPoint((class_6544.class_4762)pair.getFirst(), uniquenessParameter);
            Optional key = registry.method_29113((Object)((class_1959)((Supplier)pair.getSecond()).get()));
            if (key.isPresent()) {
                this.addBiome(mapper, parameters, (class_5321<class_1959>)((class_5321)key.get()));
            }
        });
    }

    @Override
    public Optional<class_6686.class_6708> getOverworldSurfaceRules() {
        return this.overworldSurfaceRules;
    }

    @Override
    public Optional<class_6686.class_6708> getNetherSurfaceRules() {
        return this.netherSurfaceRules;
    }
}

