/*
 * Decompiled with CFR 0.152.
 */
package terrablender.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_1959;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3754;
import net.minecraft.class_4766;
import net.minecraft.class_5216;
import net.minecraft.class_5284;
import net.minecraft.class_5285;
import net.minecraft.class_5309;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5382;
import net.minecraft.class_5455;
import net.minecraft.class_6686;
import terrablender.api.BiomeProvider;
import terrablender.api.BiomeProviders;
import terrablender.core.TerraBlender;
import terrablender.worldgen.BiomeProviderUtils;
import terrablender.worldgen.DataPackBiomeProvider;
import terrablender.worldgen.TBMultiNoiseBiomeSource;
import terrablender.worldgen.TBNoiseBasedChunkGenerator;
import terrablender.worldgen.TBNoiseGeneratorSettings;

public class DataPackManager {
    public static final class_2960 DATA_PACK_PROVIDER_LOCATION = new class_2960("datapack:biome_provider");
    private static final Codec<class_5285> DIRECT_WGS_CODEC = RecordCodecBuilder.create(p_64626_ -> p_64626_.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(class_5285::method_28028), (App)Codec.BOOL.fieldOf("generate_features").orElse((Object)true).stable().forGetter(class_5285::method_28029), (App)Codec.BOOL.fieldOf("bonus_chest").orElse((Object)false).stable().forGetter(class_5285::method_28030), (App)class_2370.method_31059((class_5321)class_2378.field_25490, (Lifecycle)Lifecycle.stable(), (Codec)class_5363.field_25411).xmap(class_5363::method_29569, Function.identity()).fieldOf("dimensions").forGetter(class_5285::method_28609), (App)Codec.STRING.optionalFieldOf("legacy_custom_options").stable().forGetter(p_158959_ -> p_158959_.field_24532)).apply((Applicative)p_64626_, p_64626_.stable(class_5285::new))).comapFlatMap(class_5285::method_28610, Function.identity());

    public static class_5285 mergeWorldGenSettings(class_5455 registryAccess, class_5285 currentSettings, class_5285 newSettings) {
        if (!DataPackManager.shouldAttemptMerge(newSettings)) {
            return newSettings;
        }
        boolean shouldMergeOverworld = DataPackManager.shouldMergeStem((class_5321<class_5363>)class_5363.field_25412, newSettings);
        boolean shouldMergeNether = DataPackManager.shouldMergeStem((class_5321<class_5363>)class_5363.field_25413, newSettings);
        int overworldWeight = shouldMergeOverworld ? TerraBlender.CONFIG.datapackOverworldRegionWeight : 0;
        int netherWeight = shouldMergeNether && TerraBlender.CONFIG.replaceDefaultNether ? TerraBlender.CONFIG.datapackNetherRegionWeight : 0;
        DataPackBiomeProvider dataPackBiomeProvider = new DataPackBiomeProvider(DATA_PACK_PROVIDER_LOCATION, overworldWeight, netherWeight, newSettings);
        BiomeProviders.register(DATA_PACK_PROVIDER_LOCATION, dataPackBiomeProvider);
        class_2378 dimensionTypeRegistry = registryAccess.method_30530(class_2378.field_25095);
        class_2370 dimensions = new class_2370(class_2378.field_25490, Lifecycle.experimental());
        for (Map.Entry entry : newSettings.method_28609().method_29722()) {
            class_5321 key = (class_5321)entry.getKey();
            class_5363 stem = (class_5363)entry.getValue();
            if (key == class_5363.field_25412 && shouldMergeOverworld) {
                stem = new class_5363(() -> (class_2874)dimensionTypeRegistry.method_31140(class_2874.field_24753), DataPackManager.createdMergedChunkGenerator((class_5321<class_5363>)class_5363.field_25412, registryAccess, currentSettings, newSettings, dataPackBiomeProvider, provider -> BiomeProviderUtils.createOverworldRules(provider.getOverworldSurfaceRules().get()), TBNoiseGeneratorSettings::overworld, TBMultiNoiseBiomeSource.Preset.OVERWORLD));
            } else if (key == class_5363.field_25413 && shouldMergeNether) {
                stem = new class_5363(() -> (class_2874)dimensionTypeRegistry.method_31140(class_2874.field_24754), DataPackManager.createdMergedChunkGenerator((class_5321<class_5363>)class_5363.field_25413, registryAccess, currentSettings, newSettings, dataPackBiomeProvider, provider -> BiomeProviderUtils.createNetherRules(provider.getNetherSurfaceRules().get()), TBNoiseGeneratorSettings::nether, TBMultiNoiseBiomeSource.Preset.NETHER));
            }
            dimensions.method_10272(key, (Object)stem, Lifecycle.stable());
        }
        TerraBlender.LOGGER.info("Merged generation settings with datapack");
        return new class_5285(currentSettings.method_28028(), currentSettings.method_28029(), currentSettings.method_28030(), dimensions);
    }

    public static <T> DataResult replaceDatapackWorldGenSettings(Dynamic<T> dynamicWorldGenSettings) {
        class_5455 registryAccess = ((class_5382)dynamicWorldGenSettings.getOps()).field_25511;
        DataResult directWorldGenSettingsResult = DIRECT_WGS_CODEC.parse(dynamicWorldGenSettings);
        DataResult dataPackedWorldGenSettingsResult = class_5285.field_24826.parse(dynamicWorldGenSettings);
        Optional directWorldGenSettingsOptional = directWorldGenSettingsResult.result();
        Optional dataPackedWorldGenSettingsOptional = dataPackedWorldGenSettingsResult.result();
        if (directWorldGenSettingsOptional.isPresent() && (dataPackedWorldGenSettingsOptional.isEmpty() || DataPackManager.shouldAttemptMerge((class_5285)dataPackedWorldGenSettingsOptional.get()))) {
            boolean forceDiscrepencyCorrection = false;
            if (dataPackedWorldGenSettingsOptional.isPresent()) {
                TerraBlender.LOGGER.info("Using merged world generation settings");
                class_5285 datapackSettings = (class_5285)dataPackedWorldGenSettingsOptional.get();
                int overworldWeight = DataPackManager.shouldMergeStem((class_5321<class_5363>)class_5363.field_25412, datapackSettings) ? TerraBlender.CONFIG.datapackOverworldRegionWeight : 0;
                int netherWeight = DataPackManager.shouldMergeStem((class_5321<class_5363>)class_5363.field_25413, datapackSettings) && TerraBlender.CONFIG.replaceDefaultNether ? TerraBlender.CONFIG.datapackNetherRegionWeight : 0;
                BiomeProviders.register(new DataPackBiomeProvider(DATA_PACK_PROVIDER_LOCATION, overworldWeight, netherWeight, (class_5285)dataPackedWorldGenSettingsOptional.get()));
                forceDiscrepencyCorrection = true;
            } else {
                TerraBlender.LOGGER.info("Using direct world generation settings without merging");
            }
            return DataPackManager.correctParameterDiscrepancies(registryAccess, (class_5285)directWorldGenSettingsOptional.get(), forceDiscrepencyCorrection);
        }
        if (dataPackedWorldGenSettingsOptional.isPresent()) {
            TerraBlender.LOGGER.info("Using original world generation settings");
            return DataPackManager.correctParameterDiscrepancies(registryAccess, (class_5285)dataPackedWorldGenSettingsOptional.get(), false);
        }
        return dataPackedWorldGenSettingsResult;
    }

    private static class_2794 createdMergedChunkGenerator(class_5321<class_5363> key, class_5455 registryAccess, class_5285 currentSettings, class_5285 newSettings, BiomeProvider biomeProvider, Function<BiomeProvider, class_6686.class_6708> getSurfaceRules, BiFunction<class_5309, class_6686.class_6708, class_5284> createNoiseGeneratorSettings, TBMultiNoiseBiomeSource.Preset preset) {
        class_2794 newChunkGenerator = DataPackManager.chunkGeneratorForStem(key, newSettings);
        if (newChunkGenerator == null) {
            throw new IllegalStateException("Attempted to merge chunk generator for missing level stem");
        }
        if (!(newChunkGenerator instanceof class_3754)) {
            return newChunkGenerator;
        }
        class_3754 newNoiseBasedChunkGenerator = (class_3754)newChunkGenerator;
        class_5284 newNoiseGeneratorSettings = (class_5284)newNoiseBasedChunkGenerator.field_24774.get();
        class_6686.class_6708 surfaceRules = getSurfaceRules.apply(biomeProvider);
        class_5284 mergedNoiseGeneratorSettings = createNoiseGeneratorSettings.apply(newNoiseGeneratorSettings.method_28559(), surfaceRules);
        return new TBNoiseBasedChunkGenerator((class_2378<class_5216.class_5487>)registryAccess.method_30530(class_2378.field_35433), preset.biomeSource((class_2378<class_1959>)registryAccess.method_30530(class_2378.field_25114), false), currentSettings.method_28028(), () -> mergedNoiseGeneratorSettings);
    }

    private static boolean shouldAttemptMerge(class_5285 settings) {
        return DataPackManager.shouldMergeStem((class_5321<class_5363>)class_5363.field_25412, settings) || DataPackManager.shouldMergeStem((class_5321<class_5363>)class_5363.field_25413, settings);
    }

    private static boolean shouldMergeStem(class_5321<class_5363> key, class_5285 settings) {
        class_2794 generator = DataPackManager.chunkGeneratorForStem(key, settings);
        return generator != null && generator.method_12098() instanceof class_4766 && !(generator.method_12098() instanceof TBMultiNoiseBiomeSource);
    }

    private static class_2794 chunkGeneratorForStem(class_5321<class_5363> key, class_5285 settings) {
        class_5363 stem = (class_5363)settings.method_28609().method_29107(key);
        return stem == null ? null : stem.method_29571();
    }

    private static DataResult<class_5285> correctParameterDiscrepancies(class_5455 registryAccess, class_5285 settings, boolean forceDiscrepancyCorrection) {
        class_2378 biomeRegistry = registryAccess.method_30530(class_2378.field_25114);
        class_2378 dimensionTypeRegistry = registryAccess.method_30530(class_2378.field_25095);
        class_2370 dimensions = new class_2370(class_2378.field_25490, Lifecycle.experimental());
        for (Map.Entry entry : settings.method_28609().method_29722()) {
            class_5321 key = (class_5321)entry.getKey();
            class_5363 stem = (class_5363)entry.getValue();
            if (key == class_5363.field_25412 && (DataPackManager.shouldCorrectUniquenessDiscrepancy(stem.method_29571(), BiomeProvider::getOverworldWeight) || DataPackManager.isChunkGeneratorCorrectable(stem.method_29571()) && forceDiscrepancyCorrection)) {
                chunkGenerator = (TBNoiseBasedChunkGenerator)stem.method_29571();
                stem = new class_5363(() -> (class_2874)dimensionTypeRegistry.method_31140(class_2874.field_24753), (class_2794)new TBNoiseBasedChunkGenerator((class_2378<class_5216.class_5487>)chunkGenerator.field_35361, TBMultiNoiseBiomeSource.Preset.OVERWORLD.biomeSource((class_2378<class_1959>)biomeRegistry, false), chunkGenerator.field_24778, chunkGenerator.field_24774));
            } else if (key == class_5363.field_25413 && (DataPackManager.shouldCorrectUniquenessDiscrepancy(stem.method_29571(), BiomeProvider::getNetherWeight) || DataPackManager.isChunkGeneratorCorrectable(stem.method_29571()) && forceDiscrepancyCorrection)) {
                chunkGenerator = (TBNoiseBasedChunkGenerator)stem.method_29571();
                stem = new class_5363(() -> (class_2874)dimensionTypeRegistry.method_31140(class_2874.field_24754), (class_2794)new TBNoiseBasedChunkGenerator((class_2378<class_5216.class_5487>)chunkGenerator.field_35361, TBMultiNoiseBiomeSource.Preset.NETHER.biomeSource((class_2378<class_1959>)biomeRegistry, false), chunkGenerator.field_24778, chunkGenerator.field_24774));
            }
            dimensions.method_10272(key, (Object)stem, Lifecycle.stable());
        }
        return DataResult.success((Object)new class_5285(settings.method_28028(), settings.method_28029(), settings.method_28030(), dimensions));
    }

    private static boolean shouldCorrectUniquenessDiscrepancy(class_2794 chunkGenerator, Function<BiomeProvider, Integer> getWeight) {
        if (!DataPackManager.isChunkGeneratorCorrectable(chunkGenerator)) {
            return false;
        }
        TBNoiseBasedChunkGenerator noiseBasedChunkGenerator = (TBNoiseBasedChunkGenerator)chunkGenerator;
        TBMultiNoiseBiomeSource multiNoiseBiomeSource = (TBMultiNoiseBiomeSource)noiseBasedChunkGenerator.method_12098();
        List<Integer> uniquenessValues = BiomeProviderUtils.getUniquenessValues(multiNoiseBiomeSource.parameters().values());
        if (TerraBlender.CONFIG.forceResetBiomeParameters) {
            TerraBlender.LOGGER.info("Forcibly resetting biome parameters");
            return true;
        }
        int currentUniquenessCount = uniquenessValues.size();
        int expectedUniquenessCount = 0;
        for (BiomeProvider provider : BiomeProviders.get()) {
            if (getWeight.apply(provider) <= 0) continue;
            ++expectedUniquenessCount;
        }
        if (currentUniquenessCount != expectedUniquenessCount) {
            TerraBlender.LOGGER.warn("Discrepancy detected between current uniqueness count " + currentUniquenessCount + " and expected uniqueness count " + expectedUniquenessCount);
            return true;
        }
        return false;
    }

    private static boolean isChunkGeneratorCorrectable(class_2794 chunkGenerator) {
        return chunkGenerator != null && chunkGenerator instanceof TBNoiseBasedChunkGenerator && chunkGenerator.method_12098() instanceof TBMultiNoiseBiomeSource;
    }
}

