/*
 * Decompiled with CFR 0.152.
 */
package terrablender.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import terrablender.worldgen.BiomeProviderUtils;
import terrablender.worldgen.TBClimate;

public class ParameterUtils {
    public static List<class_6544.class_4762> getVanillaParameterPoints(class_5321<class_1959> biome) {
        return BiomeProviderUtils.getVanillaParameterPoints(biome);
    }

    public static TBClimate.ParameterPoint convertParameterPoint(class_6544.class_4762 point, class_6544.class_6546 uniqueness) {
        return TBClimate.parameters(point.comp_105(), point.comp_106(), point.comp_107(), point.comp_108(), point.comp_109(), point.comp_110(), uniqueness, class_6544.method_38666((long)point.comp_111()));
    }

    public static enum Weirdness {
        MID_SLICE_NORMAL_ASCENDING(class_6544.class_6546.method_38121((float)-1.0f, (float)-0.93333334f)),
        HIGH_SLICE_NORMAL_ASCENDING(class_6544.class_6546.method_38121((float)-0.93333334f, (float)-0.7666667f)),
        PEAK_NORMAL(class_6544.class_6546.method_38121((float)-0.7666667f, (float)-0.56666666f)),
        HIGH_SLICE_NORMAL_DESCENDING(class_6544.class_6546.method_38121((float)-0.56666666f, (float)-0.4f)),
        MID_SLICE_NORMAL_DESCENDING(class_6544.class_6546.method_38121((float)-0.4f, (float)-0.26666668f)),
        LOW_SLICE_NORMAL_DESCENDING(class_6544.class_6546.method_38121((float)-0.26666668f, (float)-0.05f)),
        VALLEY(class_6544.class_6546.method_38121((float)-0.05f, (float)0.05f)),
        LOW_SLICE_VARIANT_ASCENDING(class_6544.class_6546.method_38121((float)0.05f, (float)0.26666668f)),
        MID_SLICE_VARIANT_ASCENDING(class_6544.class_6546.method_38121((float)0.26666668f, (float)0.4f)),
        HIGH_SLICE_VARIANT_ASCENDING(class_6544.class_6546.method_38121((float)0.4f, (float)0.56666666f)),
        PEAK_VARIANT(class_6544.class_6546.method_38121((float)0.56666666f, (float)0.7666667f)),
        HIGH_SLICE_VARIANT_DESCENDING(class_6544.class_6546.method_38121((float)0.7666667f, (float)0.93333334f)),
        MID_SLICE_VARIANT_DESCENDING(class_6544.class_6546.method_38121((float)0.93333334f, (float)1.0f)),
        FULL_RANGE(class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f));

        private class_6544.class_6546 parameter;

        private Weirdness(class_6544.class_6546 parameter) {
            this.parameter = parameter;
        }

        public class_6544.class_6546 parameter() {
            return this.parameter;
        }

        public static class_6544.class_6546 span(Weirdness min, Weirdness max) {
            return class_6544.class_6546.method_38121((float)class_6544.method_38666((long)min.parameter().comp_103()), (float)class_6544.method_38666((long)max.parameter().comp_104()));
        }
    }

    public static enum Depth {
        SURFACE(class_6544.class_6546.method_38120((float)0.0f)),
        UNDERGROUND(class_6544.class_6546.method_38121((float)0.2f, (float)0.9f)),
        FLOOR(class_6544.class_6546.method_38120((float)1.0f)),
        FULL_RANGE(class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f));

        private class_6544.class_6546 parameter;

        private Depth(class_6544.class_6546 parameter) {
            this.parameter = parameter;
        }

        public class_6544.class_6546 parameter() {
            return this.parameter;
        }

        public static class_6544.class_6546 span(Depth min, Depth max) {
            return class_6544.class_6546.method_38121((float)class_6544.method_38666((long)min.parameter().comp_103()), (float)class_6544.method_38666((long)max.parameter().comp_104()));
        }
    }

    public static enum Erosion {
        EROSION_0(class_6544.class_6546.method_38121((float)-1.0f, (float)-0.78f)),
        EROSION_1(class_6544.class_6546.method_38121((float)-0.78f, (float)-0.375f)),
        EROSION_2(class_6544.class_6546.method_38121((float)-0.375f, (float)-0.2225f)),
        EROSION_3(class_6544.class_6546.method_38121((float)-0.2225f, (float)0.05f)),
        EROSION_4(class_6544.class_6546.method_38121((float)0.05f, (float)0.45f)),
        EROSION_5(class_6544.class_6546.method_38121((float)0.45f, (float)0.55f)),
        EROSION_6(class_6544.class_6546.method_38121((float)0.55f, (float)1.0f)),
        FULL_RANGE(class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f));

        private class_6544.class_6546 parameter;

        private Erosion(class_6544.class_6546 parameter) {
            this.parameter = parameter;
        }

        public class_6544.class_6546 parameter() {
            return this.parameter;
        }

        public static class_6544.class_6546 span(Erosion min, Erosion max) {
            return class_6544.class_6546.method_38121((float)class_6544.method_38666((long)min.parameter().comp_103()), (float)class_6544.method_38666((long)max.parameter().comp_104()));
        }
    }

    public static enum Continentalness {
        MUSHROOM_FIELDS(class_6544.class_6546.method_38121((float)-1.2f, (float)-1.05f)),
        DEEP_OCEAN(class_6544.class_6546.method_38121((float)-1.05f, (float)-0.455f)),
        OCEAN(class_6544.class_6546.method_38121((float)-0.455f, (float)-0.19f)),
        COAST(class_6544.class_6546.method_38121((float)-0.19f, (float)-0.11f)),
        NEAR_INLAND(class_6544.class_6546.method_38121((float)-0.11f, (float)0.03f)),
        MID_INLAND(class_6544.class_6546.method_38121((float)0.03f, (float)0.3f)),
        FAR_INLAND(class_6544.class_6546.method_38121((float)0.3f, (float)1.0f)),
        INLAND(class_6544.class_6546.method_38121((float)-0.11f, (float)0.55f)),
        FULL_RANGE(class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f));

        private class_6544.class_6546 parameter;

        private Continentalness(class_6544.class_6546 parameter) {
            this.parameter = parameter;
        }

        public class_6544.class_6546 parameter() {
            return this.parameter;
        }

        public static class_6544.class_6546 span(Continentalness min, Continentalness max) {
            return class_6544.class_6546.method_38121((float)class_6544.method_38666((long)min.parameter().comp_103()), (float)class_6544.method_38666((long)max.parameter().comp_104()));
        }
    }

    public static enum Humidity {
        ARID(class_6544.class_6546.method_38121((float)-1.0f, (float)-0.35f)),
        DRY(class_6544.class_6546.method_38121((float)-0.35f, (float)-0.1f)),
        NEUTRAL(class_6544.class_6546.method_38121((float)-0.1f, (float)0.1f)),
        WET(class_6544.class_6546.method_38121((float)0.1f, (float)0.3f)),
        HUMID(class_6544.class_6546.method_38121((float)0.3f, (float)1.0f)),
        FULL_RANGE(class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f));

        private class_6544.class_6546 parameter;

        private Humidity(class_6544.class_6546 parameter) {
            this.parameter = parameter;
        }

        public class_6544.class_6546 parameter() {
            return this.parameter;
        }

        public static class_6544.class_6546 span(Humidity min, Humidity max) {
            return class_6544.class_6546.method_38121((float)class_6544.method_38666((long)min.parameter().comp_103()), (float)class_6544.method_38666((long)max.parameter().comp_104()));
        }
    }

    public static enum Temperature {
        ICY(class_6544.class_6546.method_38121((float)-1.0f, (float)-0.45f)),
        COOL(class_6544.class_6546.method_38121((float)-0.45f, (float)-0.15f)),
        NEUTRAL(class_6544.class_6546.method_38121((float)-0.15f, (float)0.2f)),
        WARM(class_6544.class_6546.method_38121((float)0.2f, (float)0.55f)),
        HOT(class_6544.class_6546.method_38121((float)0.55f, (float)1.0f)),
        FROZEN(class_6544.class_6546.method_38121((float)-1.0f, (float)-0.45f)),
        UNFROZEN(class_6544.class_6546.method_38121((float)-0.45f, (float)1.0f)),
        FULL_RANGE(class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f));

        private class_6544.class_6546 parameter;

        private Temperature(class_6544.class_6546 parameter) {
            this.parameter = parameter;
        }

        public class_6544.class_6546 parameter() {
            return this.parameter;
        }

        public static class_6544.class_6546 span(Temperature min, Temperature max) {
            return class_6544.class_6546.method_38121((float)class_6544.method_38666((long)min.parameter().comp_103()), (float)class_6544.method_38666((long)max.parameter().comp_104()));
        }
    }

    public static class ParameterPointListBuilder {
        private List<class_6544.class_6546> temperatures = Lists.newArrayList();
        private List<class_6544.class_6546> humidities = Lists.newArrayList();
        private List<class_6544.class_6546> continentalnesses = Lists.newArrayList();
        private List<class_6544.class_6546> erosions = Lists.newArrayList();
        private List<class_6544.class_6546> depths = Lists.newArrayList();
        private List<class_6544.class_6546> weirdnesses = Lists.newArrayList();
        private List<class_6544.class_6546> uniquenesses = Lists.newArrayList();
        private List<Long> offsets = Lists.newArrayList();

        public ParameterPointListBuilder temperature(class_6544.class_6546 ... values) {
            this.temperatures.addAll(Arrays.asList(values));
            return this;
        }

        public ParameterPointListBuilder temperature(Temperature ... values) {
            this.temperatures.addAll(Arrays.asList(values).stream().map(Temperature::parameter).toList());
            return this;
        }

        public ParameterPointListBuilder humidity(class_6544.class_6546 ... values) {
            this.humidities.addAll(Arrays.asList(values));
            return this;
        }

        public ParameterPointListBuilder humidity(Humidity ... values) {
            this.humidities.addAll(Arrays.asList(values).stream().map(Humidity::parameter).toList());
            return this;
        }

        public ParameterPointListBuilder continentalness(class_6544.class_6546 ... values) {
            this.continentalnesses.addAll(Arrays.asList(values));
            return this;
        }

        public ParameterPointListBuilder continentalness(Continentalness ... values) {
            this.continentalnesses.addAll(Arrays.asList(values).stream().map(Continentalness::parameter).toList());
            return this;
        }

        public ParameterPointListBuilder erosion(class_6544.class_6546 ... values) {
            this.erosions.addAll(Arrays.asList(values));
            return this;
        }

        public ParameterPointListBuilder erosion(Erosion ... values) {
            this.erosions.addAll(Arrays.asList(values).stream().map(Erosion::parameter).toList());
            return this;
        }

        public ParameterPointListBuilder depth(class_6544.class_6546 ... values) {
            this.depths.addAll(Arrays.asList(values));
            return this;
        }

        public ParameterPointListBuilder depth(Depth ... values) {
            this.depths.addAll(Arrays.asList(values).stream().map(Depth::parameter).toList());
            return this;
        }

        public ParameterPointListBuilder weirdness(class_6544.class_6546 ... values) {
            this.weirdnesses.addAll(Arrays.asList(values));
            return this;
        }

        public ParameterPointListBuilder weirdness(Weirdness ... values) {
            this.weirdnesses.addAll(Arrays.asList(values).stream().map(Weirdness::parameter).toList());
            return this;
        }

        public ParameterPointListBuilder uniqueness(class_6544.class_6546 ... values) {
            this.uniquenesses.addAll(Arrays.asList(values));
            return this;
        }

        public ParameterPointListBuilder uniqueness(Integer ... values) {
            this.uniquenesses.addAll(Arrays.asList(values).stream().map(BiomeProviderUtils::getUniquenessParameter).toList());
            return this;
        }

        public ParameterPointListBuilder offset(Float ... values) {
            this.offsets.addAll(Arrays.asList(values).stream().map(class_6544::method_38665).toList());
            return this;
        }

        public ParameterPointListBuilder offset(Long ... values) {
            this.offsets.addAll(Arrays.asList(values));
            return this;
        }

        public List<TBClimate.ParameterPoint> build() {
            this.populateIfEmpty();
            ImmutableList.Builder builder = new ImmutableList.Builder();
            this.temperatures.forEach(temperature -> this.humidities.forEach(humidity -> this.continentalnesses.forEach(continentalness -> this.erosions.forEach(erosion -> this.depths.forEach(depth -> this.weirdnesses.forEach(weirdness -> this.uniquenesses.forEach(uniqueness -> this.offsets.forEach(offset -> builder.add((Object)new TBClimate.ParameterPoint((class_6544.class_6546)temperature, (class_6544.class_6546)humidity, (class_6544.class_6546)continentalness, (class_6544.class_6546)erosion, (class_6544.class_6546)depth, (class_6544.class_6546)weirdness, (class_6544.class_6546)uniqueness, (long)offset))))))))));
            return builder.build();
        }

        public List<class_6544.class_4762> buildVanilla() {
            return (List)this.build().stream().map(point -> new class_6544.class_4762(point.temperature(), point.humidity(), point.continentalness(), point.erosion(), point.depth(), point.weirdness(), point.offset())).collect(ImmutableList.toImmutableList());
        }

        private void populateIfEmpty() {
            if (this.temperatures.isEmpty()) {
                this.temperatures.add(Temperature.FULL_RANGE.parameter());
            }
            if (this.humidities.isEmpty()) {
                this.humidities.add(Humidity.FULL_RANGE.parameter());
            }
            if (this.continentalnesses.isEmpty()) {
                this.continentalnesses.add(Continentalness.FULL_RANGE.parameter());
            }
            if (this.erosions.isEmpty()) {
                this.erosions.add(Erosion.FULL_RANGE.parameter());
            }
            if (this.depths.isEmpty()) {
                this.depths.add(Depth.FULL_RANGE.parameter());
            }
            if (this.weirdnesses.isEmpty()) {
                this.weirdnesses.add(Weirdness.FULL_RANGE.parameter());
            }
            if (this.uniquenesses.isEmpty()) {
                this.uniquenesses.add(BiomeProviderUtils.getUniquenessParameter(0));
            }
            if (this.offsets.isEmpty()) {
                this.offsets.add(class_6544.method_38665((float)0.0f));
            }
        }
    }
}

