/*
 * Decompiled with CFR 0.152.
 */
package terrablender.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6554;
import terrablender.api.ParameterUtils;
import terrablender.worldgen.TBClimate;

public class ModifiedVanillaOverworldBuilder {
    private Map<class_5321<class_1959>, class_5321<class_1959>> originalBiomeMappings = Maps.newHashMap();
    private Map<class_6544.class_4762, class_5321<class_1959>> parameterBiomeMappings = Maps.newHashMap();
    private Map<class_6544.class_4762, class_6544.class_4762> parameterMappings = Maps.newHashMap();
    private final class_6554 biomeBuilder = new class_6554();

    public void replaceBiome(class_5321<class_1959> original, class_5321<class_1959> replacement) {
        this.originalBiomeMappings.put(original, replacement);
    }

    public void replaceBiome(class_6544.class_4762 point, class_5321<class_1959> biome) {
        this.parameterBiomeMappings.put(point, biome);
    }

    public void replaceParameter(class_6544.class_4762 original, class_6544.class_4762 replacement) {
        this.parameterMappings.put(original, replacement);
    }

    public List<Pair<TBClimate.ParameterPoint, class_5321<class_1959>>> build(class_6544.class_6546 uniqueness) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        Consumer<Pair> mapper = pair -> {
            class_6544.class_4762 parameters = (class_6544.class_4762)pair.getFirst();
            class_5321<class_1959> biome = (class_5321<class_1959>)pair.getSecond();
            if (this.originalBiomeMappings.containsKey(biome)) {
                biome = this.originalBiomeMappings.get(biome);
            } else if (this.parameterBiomeMappings.containsKey(parameters)) {
                biome = this.parameterBiomeMappings.get(parameters);
            }
            if (this.parameterMappings.containsKey(parameters)) {
                parameters = this.parameterMappings.get(parameters);
            }
            builder.add((Object)Pair.of((Object)ParameterUtils.convertParameterPoint(parameters, uniqueness), biome));
        };
        this.biomeBuilder.method_38185(mapper);
        return builder.build();
    }
}

