/*
 * Decompiled with CFR 0.152.
 */
package terrablender.api;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6686;
import terrablender.api.BiomeProviders;
import terrablender.api.ModifiedVanillaOverworldBuilder;
import terrablender.api.ParameterUtils;
import terrablender.worldgen.BiomeProviderUtils;
import terrablender.worldgen.TBClimate;

public abstract class BiomeProvider {
    private final class_2960 name;
    private final int overworldWeight;
    private final int netherWeight;

    public BiomeProvider(class_2960 name, int overworldWeight) {
        this(name, overworldWeight, 0);
    }

    public BiomeProvider(class_2960 name, int overworldWeight, int netherWeight) {
        this.name = name;
        this.overworldWeight = overworldWeight;
        this.netherWeight = netherWeight;
    }

    public void addOverworldBiomes(class_2378<class_1959> registry, Consumer<Pair<TBClimate.ParameterPoint, class_5321<class_1959>>> mapper) {
    }

    public void addNetherBiomes(class_2378<class_1959> registry, Consumer<Pair<TBClimate.ParameterPoint, class_5321<class_1959>>> mapper) {
    }

    public List<TBClimate.ParameterPoint> getSpawnTargets() {
        return ImmutableList.of();
    }

    public Optional<class_6686.class_6708> getOverworldSurfaceRules() {
        return Optional.empty();
    }

    public Optional<class_6686.class_6708> getNetherSurfaceRules() {
        return Optional.empty();
    }

    public class_2960 getName() {
        return this.name;
    }

    public int getOverworldWeight() {
        return this.overworldWeight;
    }

    public int getNetherWeight() {
        return this.netherWeight;
    }

    public final int getIndex() {
        return BiomeProviders.getIndex(this.getName());
    }

    protected final class_6544.class_6546 getUniquenessParameter() {
        return BiomeProviderUtils.getUniquenessParameter(this.getIndex());
    }

    protected final void addBiome(Consumer<Pair<TBClimate.ParameterPoint, class_5321<class_1959>>> mapper, class_6544.class_6546 temperature, class_6544.class_6546 humidity, class_6544.class_6546 continentalness, class_6544.class_6546 erosion, class_6544.class_6546 weirdness, class_6544.class_6546 depth, float offset, class_5321<class_1959> biome) {
        this.addBiome(mapper, TBClimate.parameters(temperature, humidity, continentalness, erosion, depth, weirdness, this.getUniquenessParameter(), offset), biome);
    }

    protected final void addBiome(Consumer<Pair<TBClimate.ParameterPoint, class_5321<class_1959>>> mapper, ParameterUtils.Temperature temperature, ParameterUtils.Humidity humidity, ParameterUtils.Continentalness continentalness, ParameterUtils.Erosion erosion, ParameterUtils.Weirdness weirdness, ParameterUtils.Depth depth, float offset, class_5321<class_1959> biome) {
        this.addBiome(mapper, TBClimate.parameters(temperature.parameter(), humidity.parameter(), continentalness.parameter(), erosion.parameter(), depth.parameter(), weirdness.parameter(), this.getUniquenessParameter(), offset), biome);
    }

    protected final void addBiome(Consumer<Pair<TBClimate.ParameterPoint, class_5321<class_1959>>> mapper, TBClimate.ParameterPoint parameters, class_5321<class_1959> biome) {
        mapper.accept((Pair<TBClimate.ParameterPoint, class_5321<class_1959>>)Pair.of((Object)parameters, biome));
    }

    protected final void addBiomeSimilar(Consumer<Pair<TBClimate.ParameterPoint, class_5321<class_1959>>> mapper, class_5321<class_1959> similarVanillaBiome, class_5321<class_1959> biome) {
        List points = (List)BiomeProviderUtils.getVanillaParameterPoints(similarVanillaBiome).stream().map(point -> ParameterUtils.convertParameterPoint(point, this.getUniquenessParameter())).collect(ImmutableList.toImmutableList());
        points.forEach(point -> this.addBiome(mapper, (TBClimate.ParameterPoint)point, biome));
    }

    protected final void addModifiedVanillaOverworldBiomes(Consumer<Pair<TBClimate.ParameterPoint, class_5321<class_1959>>> mapper, Consumer<ModifiedVanillaOverworldBuilder> onModify) {
        ModifiedVanillaOverworldBuilder builder = new ModifiedVanillaOverworldBuilder();
        onModify.accept(builder);
        builder.build(this.getUniquenessParameter()).forEach(mapper::accept);
    }
}

