/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.world.surface;

import com.mojang.serialization.Codec;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_6686;
import ru.bclib.BCLib;
import ru.bclib.api.surface.rules.SurfaceNoiseCondition;
import ru.bclib.mixin.common.SurfaceRulesContextAccessor;
import ru.bclib.noise.OpenSimplexNoise;
import ru.bclib.util.MHelper;

public class DoubleBlockSurfaceNoiseCondition
extends SurfaceNoiseCondition {
    public static final DoubleBlockSurfaceNoiseCondition CONDITION = new DoubleBlockSurfaceNoiseCondition(0.0);
    private static final OpenSimplexNoise NOISE = new OpenSimplexNoise(4141L);
    public static final Codec<DoubleBlockSurfaceNoiseCondition> CODEC = Codec.DOUBLE.fieldOf("threshold").xmap(DoubleBlockSurfaceNoiseCondition::new, obj -> obj.threshold).codec();
    private final double threshold;
    private static int lastX = Integer.MIN_VALUE;
    private static int lastZ = Integer.MIN_VALUE;
    private static double lastValue = 0.0;

    public DoubleBlockSurfaceNoiseCondition(double threshold) {
        this.threshold = threshold;
    }

    public Codec<? extends class_6686.class_6693> method_39064() {
        return CODEC;
    }

    @Override
    public boolean test(SurfaceRulesContextAccessor context) {
        int x = context.getBlockX();
        int z = context.getBlockZ();
        if (lastX == x && lastZ == z) {
            return lastValue > this.threshold;
        }
        double value = NOISE.eval((double)x * 0.1, (double)z * 0.1) + MHelper.randRange(-0.4, 0.4, MHelper.RANDOM);
        lastX = x;
        lastZ = z;
        lastValue = value;
        return value > this.threshold;
    }

    static {
        class_2378.method_10230((class_2378)class_2378.field_35307, (class_2960)BCLib.makeID("doubleblock_surface"), CODEC);
    }
}

