/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.world.generator.map.hex;

import java.util.Arrays;
import java.util.Random;
import ru.bclib.interfaces.BiomeChunk;
import ru.bclib.world.biomes.BCLBiome;
import ru.bclib.world.generator.BiomePicker;

public class HexBiomeChunk
implements BiomeChunk {
    private static final short SIDE = 32;
    private static final byte SIDE_PRE = 4;
    private static final short SIZE = 1024;
    private static final short MAX_SIDE = 992;
    private static final byte SCALE_PRE = 8;
    private static final byte SIZE_PRE = 16;
    private static final byte SIDE_MASK = 31;
    private static final byte SIDE_PRE_MASK = 3;
    private static final byte SIDE_OFFSET = (byte)Math.round(Math.log(32.0) / Math.log(2.0));
    private static final byte SIDE_PRE_OFFSET = (byte)Math.round(Math.log(4.0) / Math.log(2.0));
    private static final short[][] NEIGHBOURS = new short[2][6];
    private final BCLBiome[] biomes = new BCLBiome[1024];

    public HexBiomeChunk(Random random, BiomePicker picker) {
        short index;
        BCLBiome[][] buffers;
        for (Object[] objectArray : buffers = new BCLBiome[2][1024]) {
            Arrays.fill(objectArray, null);
        }
        for (int index2 = 0; index2 < 16; index2 = (int)((byte)(index2 + 1))) {
            byte px = (byte)(index2 >> SIDE_PRE_OFFSET);
            byte pz = (byte)(index2 & 3);
            px = (byte)(px * 8 + random.nextInt(8));
            pz = (byte)(pz * 8 + random.nextInt(8));
            this.circle(buffers[0], this.getIndex(px, pz), picker.getBiome(random), null);
        }
        boolean hasEmptyCells = true;
        int bufferIndex = 0;
        while (hasEmptyCells) {
            BCLBiome[] inBuffer = buffers[bufferIndex];
            bufferIndex = (byte)(bufferIndex + 1 & 1);
            BCLBiome[] bCLBiomeArray = buffers[bufferIndex];
            hasEmptyCells = false;
            for (index = 32; index < 992; index = (short)(index + 1)) {
                byte z = (byte)(index & 0x1F);
                if (z == 0 || z == 31) continue;
                if (inBuffer[index] != null) {
                    bCLBiomeArray[index] = inBuffer[index];
                    short[] neighbours = this.getNeighbours(index & 0x1F);
                    short indexSide = (short)(index + neighbours[random.nextInt(6)]);
                    if (indexSide < 0 || indexSide >= 1024 || bCLBiomeArray[indexSide] != null) continue;
                    bCLBiomeArray[indexSide] = inBuffer[index];
                    continue;
                }
                hasEmptyCells = true;
            }
        }
        BCLBiome[] outBuffer = buffers[bufferIndex];
        byte by = 29;
        for (index = 0; index < 32; index = (short)((byte)(index + 1))) {
            outBuffer[this.getIndex((byte)index, (byte)0)] = outBuffer[this.getIndex((byte)index, (byte)2)];
            outBuffer[this.getIndex((byte)0, (byte)index)] = outBuffer[this.getIndex((byte)2, (byte)index)];
            outBuffer[this.getIndex((byte)index, (byte)31)] = outBuffer[this.getIndex((byte)index, by)];
            outBuffer[this.getIndex((byte)31, (byte)index)] = outBuffer[this.getIndex(by, (byte)index)];
        }
        for (index = 0; index < 1024; index = (short)(index + 1)) {
            if (outBuffer[index] == null) {
                outBuffer[index] = picker.getBiome(random);
                continue;
            }
            if (random.nextInt(4) != 0) continue;
            this.circle(outBuffer, index, outBuffer[index].getSubBiome(random), outBuffer[index]);
        }
        System.arraycopy(outBuffer, 0, this.biomes, 0, 1024);
    }

    private void circle(BCLBiome[] buffer, short center, BCLBiome biome, BCLBiome mask) {
        short[] neighbours;
        if (buffer[center] == mask) {
            buffer[center] = biome;
        }
        for (short i : neighbours = this.getNeighbours(center & 0x1F)) {
            short index = (short)(center + i);
            if (index < 0 || index >= 1024 || buffer[index] != mask) continue;
            buffer[index] = biome;
        }
    }

    private static byte wrap(int value) {
        return (byte)(value & 0x1F);
    }

    private short getIndex(byte x, byte z) {
        return (short)((short)x << SIDE_OFFSET | z);
    }

    @Override
    public BCLBiome getBiome(int x, int z) {
        return this.biomes[this.getIndex(HexBiomeChunk.wrap(x), HexBiomeChunk.wrap(z))];
    }

    @Override
    public void setBiome(int x, int z, BCLBiome biome) {
        this.biomes[this.getIndex((byte)HexBiomeChunk.wrap((int)x), (byte)HexBiomeChunk.wrap((int)z))] = biome;
    }

    @Override
    public int getSide() {
        return 32;
    }

    public static int scaleCoordinate(int value) {
        return value >> SIDE_OFFSET;
    }

    public static boolean isBorder(int value) {
        return HexBiomeChunk.wrap(value) == 31;
    }

    private short[] getNeighbours(int z) {
        return NEIGHBOURS[z & 1];
    }

    public static float scaleMap(float size) {
        return size / 8.0f;
    }

    static {
        HexBiomeChunk.NEIGHBOURS[0][0] = 1;
        HexBiomeChunk.NEIGHBOURS[0][1] = -1;
        HexBiomeChunk.NEIGHBOURS[0][2] = 32;
        HexBiomeChunk.NEIGHBOURS[0][3] = -32;
        HexBiomeChunk.NEIGHBOURS[0][4] = 33;
        HexBiomeChunk.NEIGHBOURS[0][5] = 31;
        HexBiomeChunk.NEIGHBOURS[1][0] = 1;
        HexBiomeChunk.NEIGHBOURS[1][1] = -1;
        HexBiomeChunk.NEIGHBOURS[1][2] = 32;
        HexBiomeChunk.NEIGHBOURS[1][3] = -32;
        HexBiomeChunk.NEIGHBOURS[1][4] = -31;
        HexBiomeChunk.NEIGHBOURS[1][5] = -33;
    }
}

