/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.world.features;

import java.util.List;
import java.util.Random;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5281;
import ru.bclib.util.StructureHelper;
import ru.bclib.world.features.NBTStructureFeature;

public class ListFeature
extends NBTStructureFeature {
    private final List<StructureInfo> list;
    private StructureInfo selected;

    public ListFeature(List<StructureInfo> list, class_2680 defaultBlock) {
        super(defaultBlock);
        this.list = list;
    }

    @Override
    protected class_3499 getStructure(class_5281 world, class_2338 pos, Random random) {
        this.selected = this.list.get(random.nextInt(this.list.size()));
        return this.selected.getStructure();
    }

    @Override
    protected boolean canSpawn(class_5281 world, class_2338 pos, Random random) {
        int cz;
        int cx = pos.method_10263() >> 4;
        return (cx + (cz = pos.method_10260() >> 4) & 1) == 0 && pos.method_10264() > 58;
    }

    @Override
    protected class_2470 getRotation(class_5281 world, class_2338 pos, Random random) {
        return class_2470.method_16548((Random)random);
    }

    @Override
    protected class_2415 getMirror(class_5281 world, class_2338 pos, Random random) {
        return class_2415.values()[random.nextInt(3)];
    }

    @Override
    protected int getYOffset(class_3499 structure, class_5281 world, class_2338 pos, Random random) {
        return this.selected.offsetY;
    }

    @Override
    protected NBTStructureFeature.TerrainMerge getTerrainMerge(class_5281 world, class_2338 pos, Random random) {
        return this.selected.terrainMerge;
    }

    @Override
    protected void addStructureData(class_3492 data) {
    }

    public static final class StructureInfo {
        public final NBTStructureFeature.TerrainMerge terrainMerge;
        public final String structurePath;
        public final int offsetY;
        private class_3499 structure;

        public StructureInfo(String structurePath, int offsetY, NBTStructureFeature.TerrainMerge terrainMerge) {
            this.terrainMerge = terrainMerge;
            this.structurePath = structurePath;
            this.offsetY = offsetY;
        }

        public class_3499 getStructure() {
            if (this.structure == null) {
                this.structure = StructureHelper.readStructure(this.structurePath);
            }
            return this.structure;
        }
    }
}

