/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.complexmaterials;

import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import ru.bclib.BCLib;
import ru.bclib.api.tag.NamedBlockTags;
import ru.bclib.api.tag.NamedCommonBlockTags;
import ru.bclib.api.tag.NamedCommonItemTags;
import ru.bclib.api.tag.NamedItemTags;
import ru.bclib.api.tag.TagAPI;
import ru.bclib.blocks.BaseBarkBlock;
import ru.bclib.blocks.BaseBarrelBlock;
import ru.bclib.blocks.BaseBlock;
import ru.bclib.blocks.BaseBookshelfBlock;
import ru.bclib.blocks.BaseChestBlock;
import ru.bclib.blocks.BaseComposterBlock;
import ru.bclib.blocks.BaseCraftingTableBlock;
import ru.bclib.blocks.BaseDoorBlock;
import ru.bclib.blocks.BaseFenceBlock;
import ru.bclib.blocks.BaseGateBlock;
import ru.bclib.blocks.BaseLadderBlock;
import ru.bclib.blocks.BaseRotatedPillarBlock;
import ru.bclib.blocks.BaseSignBlock;
import ru.bclib.blocks.BaseSlabBlock;
import ru.bclib.blocks.BaseStairsBlock;
import ru.bclib.blocks.BaseStripableLogBlock;
import ru.bclib.blocks.BaseTrapdoorBlock;
import ru.bclib.blocks.BaseWoodenButtonBlock;
import ru.bclib.blocks.StripableBarkBlock;
import ru.bclib.blocks.WoodenPressurePlateBlock;
import ru.bclib.complexmaterials.ComplexMaterial;
import ru.bclib.complexmaterials.entry.BlockEntry;
import ru.bclib.complexmaterials.entry.RecipeEntry;
import ru.bclib.config.PathConfig;
import ru.bclib.recipes.GridRecipe;

public class WoodenComplexMaterial
extends ComplexMaterial {
    public static final class_2960 MATERIAL_ID = BCLib.makeID("wooden_material");
    public static final String BLOCK_CRAFTING_TABLE = "crafting_table";
    public static final String BLOCK_STRIPPED_BARK = "stripped_bark";
    public static final String BLOCK_STRIPPED_LOG = "stripped_log";
    public static final String BLOCK_PRESSURE_PLATE = "plate";
    public static final String BLOCK_BOOKSHELF = "bookshelf";
    public static final String BLOCK_COMPOSTER = "composter";
    public static final String BLOCK_TRAPDOOR = "trapdoor";
    public static final String BLOCK_BARREL = "barrel";
    public static final String BLOCK_BUTTON = "button";
    public static final String BLOCK_LADDER = "ladder";
    public static final String BLOCK_PLANKS = "planks";
    public static final String BLOCK_STAIRS = "stairs";
    public static final String BLOCK_CHEST = "chest";
    public static final String BLOCK_FENCE = "fence";
    public static final String BLOCK_BARK = "bark";
    public static final String BLOCK_DOOR = "door";
    public static final String BLOCK_GATE = "gate";
    public static final String BLOCK_SIGN = "sign";
    public static final String BLOCK_SLAB = "slab";
    public static final String BLOCK_LOG = "log";
    public static final String TAG_LOGS = "logs";
    public final class_3620 planksColor;
    public final class_3620 woodColor;

    public WoodenComplexMaterial(String modID, String baseName, String receipGroupPrefix, class_3620 woodColor, class_3620 planksColor) {
        super(modID, baseName, receipGroupPrefix);
        this.planksColor = planksColor;
        this.woodColor = woodColor;
    }

    @Override
    protected FabricBlockSettings getBlockSettings() {
        return FabricBlockSettings.copyOf((class_4970)class_2246.field_10161).materialColor(this.planksColor);
    }

    @Override
    public class_2960 getMaterialID() {
        return MATERIAL_ID;
    }

    @Override
    protected void initTags() {
        this.addBlockTag(TagAPI.makeBlockTag(this.getModID(), this.getBaseName() + "_logs"));
        this.addItemTag(TagAPI.makeItemTag(this.getModID(), this.getBaseName() + "_logs"));
    }

    @Override
    protected void initDefault(FabricBlockSettings blockSettings, FabricItemSettings itemSettings) {
        this.initBase(blockSettings, itemSettings);
        this.initStorage(blockSettings, itemSettings);
        this.initDecorations(blockSettings, itemSettings);
    }

    protected final void initBase(FabricBlockSettings blockSettings, FabricItemSettings itemSettings) {
        TagAPI.TagLocation tagBlockLog = new TagAPI.TagLocation(this.getBlockTag(TAG_LOGS).method_26791());
        TagAPI.TagLocation tagItemLog = new TagAPI.TagLocation(this.getItemTag(TAG_LOGS).method_26791());
        this.addBlockEntry(new BlockEntry(BLOCK_STRIPPED_LOG, (complexMaterial, settings) -> new BaseRotatedPillarBlock((class_4970.class_2251)settings)).setBlockTags(NamedBlockTags.LOGS, NamedBlockTags.LOGS_THAT_BURN, tagBlockLog).setItemTags(NamedItemTags.LOGS, NamedItemTags.LOGS_THAT_BURN, tagItemLog));
        this.addBlockEntry(new BlockEntry(BLOCK_STRIPPED_BARK, (complexMaterial, settings) -> new BaseBarkBlock((class_4970.class_2251)settings)).setBlockTags(NamedBlockTags.LOGS, NamedBlockTags.LOGS_THAT_BURN, tagBlockLog).setItemTags(NamedItemTags.LOGS, NamedItemTags.LOGS_THAT_BURN, tagItemLog));
        this.addBlockEntry(new BlockEntry(BLOCK_LOG, (complexMaterial, settings) -> new BaseStripableLogBlock(this.woodColor, this.getBlock(BLOCK_STRIPPED_LOG))).setBlockTags(NamedBlockTags.LOGS, NamedBlockTags.LOGS_THAT_BURN, tagBlockLog).setItemTags(NamedItemTags.LOGS, NamedItemTags.LOGS_THAT_BURN, tagItemLog));
        this.addBlockEntry(new BlockEntry(BLOCK_BARK, (complexMaterial, settings) -> new StripableBarkBlock(this.woodColor, this.getBlock(BLOCK_STRIPPED_BARK))).setBlockTags(NamedBlockTags.LOGS, NamedBlockTags.LOGS_THAT_BURN, tagBlockLog).setItemTags(NamedItemTags.LOGS, NamedItemTags.LOGS_THAT_BURN, tagItemLog));
        this.addBlockEntry(new BlockEntry(BLOCK_PLANKS, (complexMaterial, settings) -> new BaseBlock((class_4970.class_2251)settings)).setBlockTags(NamedBlockTags.PLANKS).setItemTags(NamedItemTags.PLANKS));
        this.addBlockEntry(new BlockEntry(BLOCK_STAIRS, (complexMaterial, settings) -> new BaseStairsBlock(this.getBlock(BLOCK_PLANKS))).setBlockTags(NamedBlockTags.WOODEN_STAIRS, NamedBlockTags.STAIRS).setItemTags(NamedItemTags.WOODEN_STAIRS, NamedItemTags.STAIRS));
        this.addBlockEntry(new BlockEntry(BLOCK_SLAB, (complexMaterial, settings) -> new BaseSlabBlock(this.getBlock(BLOCK_PLANKS))).setBlockTags(NamedBlockTags.WOODEN_SLABS, NamedBlockTags.SLABS).setItemTags(NamedItemTags.WOODEN_SLABS, NamedItemTags.SLABS));
        this.addBlockEntry(new BlockEntry(BLOCK_FENCE, (complexMaterial, settings) -> new BaseFenceBlock(this.getBlock(BLOCK_PLANKS))).setBlockTags(NamedBlockTags.FENCES, NamedBlockTags.WOODEN_FENCES).setItemTags(NamedItemTags.FENCES, NamedItemTags.WOODEN_FENCES));
        this.addBlockEntry(new BlockEntry(BLOCK_GATE, (complexMaterial, settings) -> new BaseGateBlock(this.getBlock(BLOCK_PLANKS))).setBlockTags(NamedBlockTags.FENCE_GATES));
        this.addBlockEntry(new BlockEntry(BLOCK_BUTTON, (complexMaterial, settings) -> new BaseWoodenButtonBlock(this.getBlock(BLOCK_PLANKS))).setBlockTags(NamedBlockTags.BUTTONS, NamedBlockTags.WOODEN_BUTTONS).setItemTags(NamedItemTags.BUTTONS, NamedItemTags.WOODEN_BUTTONS));
        this.addBlockEntry(new BlockEntry(BLOCK_PRESSURE_PLATE, (complexMaterial, settings) -> new WoodenPressurePlateBlock(this.getBlock(BLOCK_PLANKS))).setBlockTags(NamedBlockTags.PRESSURE_PLATES, NamedBlockTags.WOODEN_PRESSURE_PLATES).setItemTags(NamedItemTags.WOODEN_PRESSURE_PLATES));
        this.addBlockEntry(new BlockEntry(BLOCK_TRAPDOOR, (complexMaterial, settings) -> new BaseTrapdoorBlock(this.getBlock(BLOCK_PLANKS))).setBlockTags(NamedBlockTags.TRAPDOORS, NamedBlockTags.WOODEN_TRAPDOORS).setItemTags(NamedItemTags.TRAPDOORS, NamedItemTags.WOODEN_TRAPDOORS));
        this.addBlockEntry(new BlockEntry(BLOCK_DOOR, (complexMaterial, settings) -> new BaseDoorBlock(this.getBlock(BLOCK_PLANKS))).setBlockTags(NamedBlockTags.DOORS, NamedBlockTags.WOODEN_DOORS).setItemTags(NamedItemTags.DOORS, NamedItemTags.WOODEN_DOORS));
        this.addBlockEntry(new BlockEntry(BLOCK_LADDER, (complexMaterial, settings) -> new BaseLadderBlock(this.getBlock(BLOCK_PLANKS))).setBlockTags(NamedBlockTags.CLIMBABLE));
        this.addBlockEntry(new BlockEntry(BLOCK_SIGN, (complexMaterial, settings) -> new BaseSignBlock(this.getBlock(BLOCK_PLANKS))).setBlockTags(NamedBlockTags.SIGNS).setItemTags(NamedItemTags.SIGNS));
    }

    protected final void initStorage(FabricBlockSettings blockSettings, FabricItemSettings itemSettings) {
        this.addBlockEntry(new BlockEntry(BLOCK_CHEST, (complexMaterial, settings) -> new BaseChestBlock(this.getBlock(BLOCK_PLANKS))).setBlockTags(NamedCommonBlockTags.CHEST, NamedCommonBlockTags.WOODEN_CHEST).setItemTags(NamedCommonItemTags.CHEST, NamedCommonItemTags.WOODEN_CHEST));
        this.addBlockEntry(new BlockEntry(BLOCK_BARREL, (complexMaterial, settings) -> new BaseBarrelBlock(this.getBlock(BLOCK_PLANKS))).setBlockTags(NamedCommonBlockTags.BARREL, NamedCommonBlockTags.WOODEN_BARREL).setItemTags(NamedCommonItemTags.BARREL, NamedCommonItemTags.WOODEN_BARREL));
    }

    protected final void initDecorations(FabricBlockSettings blockSettings, FabricItemSettings itemSettings) {
        this.addBlockEntry(new BlockEntry(BLOCK_CRAFTING_TABLE, (complexMaterial, settings) -> new BaseCraftingTableBlock(this.getBlock(BLOCK_PLANKS))).setBlockTags(NamedCommonBlockTags.WORKBENCHES).setItemTags(NamedCommonItemTags.WORKBENCHES));
        this.addBlockEntry(new BlockEntry(BLOCK_BOOKSHELF, (complexMaterial, settings) -> new BaseBookshelfBlock(this.getBlock(BLOCK_PLANKS))).setBlockTags(NamedCommonBlockTags.BOOKSHELVES));
        this.addBlockEntry(new BlockEntry(BLOCK_COMPOSTER, (complexMaterial, settings) -> new BaseComposterBlock(this.getBlock(BLOCK_PLANKS))));
    }

    @Override
    protected void initFlammable(FlammableBlockRegistry registry) {
        this.getBlocks().forEach(block -> registry.add(block, 5, 20));
        registry.add(this.getBlock(BLOCK_LOG), 5, 5);
        registry.add(this.getBlock(BLOCK_BARK), 5, 5);
        registry.add(this.getBlock(BLOCK_STRIPPED_LOG), 5, 5);
        registry.add(this.getBlock(BLOCK_STRIPPED_BARK), 5, 5);
    }

    @Override
    public void initDefaultRecipes() {
        class_2248 planks = this.getBlock(BLOCK_PLANKS);
        this.addRecipeEntry(new RecipeEntry(BLOCK_PLANKS, (material, config, id) -> {
            class_2248 log_stripped = this.getBlock(BLOCK_STRIPPED_LOG);
            class_2248 bark_stripped = this.getBlock(BLOCK_STRIPPED_BARK);
            class_2248 log = this.getBlock(BLOCK_LOG);
            class_2248 bark = this.getBlock(BLOCK_BARK);
            GridRecipe.make(id, (class_1935)planks).checkConfig((PathConfig)config).setOutputCount(4).setList("#").addMaterial('#', new class_1935[]{log, bark, log_stripped, bark_stripped}).setGroup(this.receipGroupPrefix + "_planks").build();
        }));
        this.addRecipeEntry(new RecipeEntry(BLOCK_STAIRS, (material, config, id) -> GridRecipe.make(id, (class_1935)this.getBlock(BLOCK_STAIRS)).checkConfig((PathConfig)config).setOutputCount(4).setShape("#  ", "## ", "###").addMaterial('#', new class_1935[]{planks}).setGroup(this.receipGroupPrefix + "_planks_stairs").build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_SLAB, (material, config, id) -> GridRecipe.make(id, (class_1935)this.getBlock(BLOCK_SLAB)).checkConfig((PathConfig)config).setOutputCount(6).setShape("###").addMaterial('#', new class_1935[]{planks}).setGroup(this.receipGroupPrefix + "_planks_slabs").build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_FENCE, (material, config, id) -> GridRecipe.make(id, (class_1935)this.getBlock(BLOCK_FENCE)).checkConfig((PathConfig)config).setOutputCount(3).setShape("#I#", "#I#").addMaterial('#', new class_1935[]{planks}).addMaterial('I', new class_1935[]{class_1802.field_8600}).setGroup(this.receipGroupPrefix + "_planks_fences").build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_GATE, (material, config, id) -> GridRecipe.make(id, (class_1935)this.getBlock(BLOCK_GATE)).checkConfig((PathConfig)config).setShape("I#I", "I#I").addMaterial('#', new class_1935[]{planks}).addMaterial('I', new class_1935[]{class_1802.field_8600}).setGroup(this.receipGroupPrefix + "_planks_gates").build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_BUTTON, (material, config, id) -> GridRecipe.make(id, (class_1935)this.getBlock(BLOCK_BUTTON)).checkConfig((PathConfig)config).setList("#").addMaterial('#', new class_1935[]{planks}).setGroup(this.receipGroupPrefix + "_planks_buttons").build()));
        this.addRecipeEntry(new RecipeEntry("pressure_plate", (material, config, id) -> GridRecipe.make(id, (class_1935)this.getBlock(BLOCK_PRESSURE_PLATE)).checkConfig((PathConfig)config).setShape("##").addMaterial('#', new class_1935[]{planks}).setGroup(this.receipGroupPrefix + "_planks_plates").build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_TRAPDOOR, (material, config, id) -> GridRecipe.make(id, (class_1935)this.getBlock(BLOCK_TRAPDOOR)).checkConfig((PathConfig)config).setOutputCount(2).setShape("###", "###").addMaterial('#', new class_1935[]{planks}).setGroup(this.receipGroupPrefix + "_trapdoors").build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_DOOR, (material, config, id) -> GridRecipe.make(id, (class_1935)this.getBlock(BLOCK_DOOR)).checkConfig((PathConfig)config).setOutputCount(3).setShape("##", "##", "##").addMaterial('#', new class_1935[]{planks}).setGroup(this.receipGroupPrefix + "_doors").build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_CRAFTING_TABLE, (material, config, id) -> GridRecipe.make(id, (class_1935)this.getBlock(BLOCK_CRAFTING_TABLE)).checkConfig((PathConfig)config).setShape("##", "##").addMaterial('#', new class_1935[]{planks}).setGroup(this.receipGroupPrefix + "_tables").build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_LADDER, (material, config, id) -> GridRecipe.make(id, (class_1935)this.getBlock(BLOCK_LADDER)).checkConfig((PathConfig)config).setOutputCount(3).setShape("I I", "I#I", "I I").addMaterial('#', new class_1935[]{planks}).addMaterial('I', new class_1935[]{class_1802.field_8600}).setGroup(this.receipGroupPrefix + "_ladders").build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_SIGN, (material, config, id) -> GridRecipe.make(id, (class_1935)this.getBlock(BLOCK_SIGN)).checkConfig((PathConfig)config).setOutputCount(3).setShape("###", "###", " I ").addMaterial('#', new class_1935[]{planks}).addMaterial('I', new class_1935[]{class_1802.field_8600}).setGroup(this.receipGroupPrefix + "_signs").build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_CHEST, (material, config, id) -> GridRecipe.make(id, (class_1935)this.getBlock(BLOCK_CHEST)).checkConfig((PathConfig)config).setShape("###", "# #", "###").addMaterial('#', new class_1935[]{planks}).setGroup(this.receipGroupPrefix + "_chests").build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_BARREL, (material, config, id) -> GridRecipe.make(id, (class_1935)this.getBlock(BLOCK_BARREL)).checkConfig((PathConfig)config).setShape("#S#", "# #", "#S#").addMaterial('#', new class_1935[]{planks}).addMaterial('S', new class_1935[]{this.getBlock(BLOCK_SLAB)}).setGroup(this.receipGroupPrefix + "_barrels").build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_BOOKSHELF, (material, config, id) -> GridRecipe.make(id, (class_1935)this.getBlock(BLOCK_BOOKSHELF)).checkConfig((PathConfig)config).setShape("###", "PPP", "###").addMaterial('#', new class_1935[]{planks}).addMaterial('P', new class_1935[]{class_1802.field_8529}).setGroup(this.receipGroupPrefix + "_bookshelves").build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_BARK, (material, config, id) -> GridRecipe.make(id, (class_1935)this.getBlock(BLOCK_BARK)).checkConfig((PathConfig)config).setShape("##", "##").addMaterial('#', new class_1935[]{this.getBlock(BLOCK_LOG)}).setOutputCount(3).build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_LOG, (material, config, id) -> GridRecipe.make(id, (class_1935)this.getBlock(BLOCK_LOG)).checkConfig((PathConfig)config).setShape("##", "##").addMaterial('#', new class_1935[]{this.getBlock(BLOCK_BARK)}).setOutputCount(3).build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_STRIPPED_BARK, (material, config, id) -> GridRecipe.make(id, (class_1935)this.getBlock(BLOCK_STRIPPED_BARK)).checkConfig((PathConfig)config).setShape("##", "##").addMaterial('#', new class_1935[]{this.getBlock(BLOCK_STRIPPED_LOG)}).setOutputCount(3).build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_STRIPPED_LOG, (material, config, id) -> GridRecipe.make(id, (class_1935)this.getBlock(BLOCK_STRIPPED_LOG)).checkConfig((PathConfig)config).setShape("##", "##").addMaterial('#', new class_1935[]{this.getBlock(BLOCK_STRIPPED_BARK)}).setOutputCount(3).build()));
        this.addRecipeEntry(new RecipeEntry(BLOCK_COMPOSTER, (material, config, id) -> GridRecipe.make(id, (class_1935)this.getBlock(BLOCK_COMPOSTER)).checkConfig((PathConfig)config).setShape("# #", "# #", "###").addMaterial('#', new class_1935[]{this.getBlock(BLOCK_SLAB)}).build()));
        this.addRecipeEntry(new RecipeEntry("shulker", (material, config, id) -> GridRecipe.make(id, (class_1935)class_2246.field_10603).checkConfig((PathConfig)config).setShape("S", "#", "S").addMaterial('S', new class_1935[]{class_1802.field_8815}).addMaterial('#', new class_1935[]{this.getBlock(BLOCK_CHEST)}).build()));
    }
}

