/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.client.models;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_1160;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;
import ru.bclib.client.models.UnbakedQuad;
import ru.bclib.util.BlocksHelper;
import ru.bclib.util.MHelper;

@Environment(value=EnvType.CLIENT)
public class OBJBlockModel
implements class_1100,
class_1087 {
    private static final class_1160[] POSITIONS = new class_1160[]{new class_1160(), new class_1160(), new class_1160()};
    protected final Map<class_2350, List<UnbakedQuad>> quadsUnbakedMap = Maps.newEnumMap(class_2350.class);
    protected final Map<class_2350, List<class_777>> quadsBakedMap = Maps.newEnumMap(class_2350.class);
    protected final List<UnbakedQuad> quadsUnbaked = Lists.newArrayList();
    protected final List<class_777> quadsBaked = Lists.newArrayList();
    protected class_1058[] sprites;
    protected class_809 transforms;
    protected class_806 overrides;
    protected List<class_4730> materials;
    protected boolean useCulling;
    protected boolean useShading;
    protected byte particleIndex;

    public OBJBlockModel(class_2960 location, class_1160 offset, boolean useCulling, boolean useShading, byte particleIndex, class_2960 ... textureIDs) {
        for (class_2350 dir : BlocksHelper.DIRECTIONS) {
            this.quadsUnbakedMap.put(dir, Lists.newArrayList());
            this.quadsBakedMap.put(dir, Lists.newArrayList());
        }
        this.transforms = class_809.field_4301;
        this.overrides = class_806.field_4292;
        this.materials = new ArrayList<class_4730>(textureIDs.length);
        this.sprites = new class_1058[textureIDs.length];
        this.particleIndex = particleIndex;
        this.useCulling = useCulling;
        this.useShading = useShading;
        this.loadModel(location, offset, (byte)(textureIDs.length - 1));
        for (int i = 0; i < textureIDs.length; ++i) {
            this.materials.add(new class_4730(class_1059.field_5275, textureIDs[i]));
        }
    }

    public Collection<class_2960> method_4755() {
        return Collections.emptyList();
    }

    public Collection<class_4730> method_4754(Function<class_2960, class_1100> function, Set<Pair<String, String>> set) {
        return this.materials;
    }

    @Nullable
    public class_1087 method_4753(class_1088 modelBakery, Function<class_4730, class_1058> textureGetter, class_3665 modelState, class_2960 resourceLocation) {
        for (int i = 0; i < this.sprites.length; ++i) {
            this.sprites[i] = textureGetter.apply(this.materials.get(i));
        }
        this.quadsBaked.clear();
        this.quadsUnbaked.forEach(quad -> this.quadsBaked.add(quad.bake(this.sprites, modelState)));
        for (class_2350 dir : BlocksHelper.DIRECTIONS) {
            List<UnbakedQuad> unbaked = this.quadsUnbakedMap.get(dir);
            List<class_777> baked = this.quadsBakedMap.get(dir);
            baked.clear();
            unbaked.forEach(quad -> baked.add(quad.bake(this.sprites, modelState)));
        }
        return this;
    }

    public List<class_777> method_4707(@Nullable class_2680 blockState, @Nullable class_2350 direction, Random random) {
        return direction == null ? this.quadsBaked : this.quadsBakedMap.get(direction);
    }

    public boolean method_4708() {
        return true;
    }

    public boolean method_4712() {
        return true;
    }

    public boolean method_24304() {
        return true;
    }

    public boolean method_4713() {
        return false;
    }

    public class_1058 method_4711() {
        return this.sprites[this.particleIndex];
    }

    public class_809 method_4709() {
        return this.transforms;
    }

    public class_806 method_4710() {
        return this.overrides;
    }

    private class_3298 getResource(class_2960 location) {
        class_3298 resource;
        block4: {
            resource = null;
            try {
                resource = class_310.method_1551().method_1478().method_14486(location);
            }
            catch (IOException e) {
                e.printStackTrace();
                if (resource == null) break block4;
                try {
                    resource.close();
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
                resource = null;
            }
        }
        return resource;
    }

    private void loadModel(class_2960 location, class_1160 offset, byte maxIndex) {
        class_3298 resource = this.getResource(location);
        if (resource == null) {
            return;
        }
        InputStream input = resource.method_14482();
        ArrayList<Float> vertecies = new ArrayList<Float>(12);
        ArrayList<Float> uvs = new ArrayList<Float>(8);
        ArrayList<Integer> vertexIndex = new ArrayList<Integer>(4);
        ArrayList<Integer> uvIndex = new ArrayList<Integer>(4);
        byte materialIndex = -1;
        try {
            String string;
            InputStreamReader streamReader = new InputStreamReader(input);
            BufferedReader reader = new BufferedReader(streamReader);
            while ((string = reader.readLine()) != null) {
                int i;
                if (string.startsWith("usemtl")) {
                    if ((materialIndex = (byte)((byte)(materialIndex + 1))) <= maxIndex) continue;
                    materialIndex = maxIndex;
                    continue;
                }
                if (string.startsWith("vt")) {
                    String[] uv = string.split(" ");
                    uvs.add(Float.valueOf(Float.parseFloat(uv[1])));
                    uvs.add(Float.valueOf(Float.parseFloat(uv[2])));
                    continue;
                }
                if (string.startsWith("v")) {
                    String[] vert = string.split(" ");
                    for (i = 1; i < 4; ++i) {
                        vertecies.add(Float.valueOf(Float.parseFloat(vert[i])));
                    }
                    continue;
                }
                if (!string.startsWith("f")) continue;
                String[] members = string.split(" ");
                if (members.length != 5) {
                    System.out.println("Only quads in OBJ are supported! Model [" + location + "] has n-gons or triangles!");
                    continue;
                }
                vertexIndex.clear();
                uvIndex.clear();
                for (i = 1; i < members.length; ++i) {
                    String member = members[i];
                    if (member.contains("/")) {
                        String[] sub = member.split("/");
                        vertexIndex.add(Integer.parseInt(sub[0]) - 1);
                        uvIndex.add(Integer.parseInt(sub[1]) - 1);
                        continue;
                    }
                    vertexIndex.add(Integer.parseInt(member) - 1);
                }
                boolean hasUV = !uvIndex.isEmpty();
                UnbakedQuad quad2 = new UnbakedQuad();
                for (int i2 = 0; i2 < 4; ++i2) {
                    int index = (Integer)vertexIndex.get(i2) * 3;
                    int quadIndex = i2 * 5;
                    quad2.addData(quadIndex++, ((Float)vertecies.get(index++)).floatValue() + offset.method_4943());
                    quad2.addData(quadIndex++, ((Float)vertecies.get(index++)).floatValue() + offset.method_4945());
                    quad2.addData(quadIndex++, ((Float)vertecies.get(index)).floatValue() + offset.method_4947());
                    if (!hasUV) continue;
                    index = (Integer)uvIndex.get(i2) * 2;
                    quad2.addData(quadIndex++, ((Float)uvs.get(index++)).floatValue() * 16.0f);
                    quad2.addData(quadIndex, (1.0f - ((Float)uvs.get(index)).floatValue()) * 16.0f);
                }
                quad2.setSpriteIndex(materialIndex);
                if (this.useShading) {
                    class_2350 dir = this.getNormalDirection(quad2);
                    quad2.setDirection(dir);
                    quad2.setShading(true);
                }
                if (this.useCulling) {
                    class_2350 dir = this.getCullingDirection(quad2);
                    if (dir == null) {
                        this.quadsUnbaked.add(quad2);
                        continue;
                    }
                    this.quadsUnbakedMap.get(dir).add(quad2);
                    continue;
                }
                this.quadsUnbaked.add(quad2);
            }
            reader.close();
            streamReader.close();
            input.close();
            resource.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (materialIndex < 0) {
            this.quadsUnbaked.forEach(quad -> quad.setSpriteIndex(0));
            this.quadsUnbakedMap.values().forEach(list -> list.forEach(quad -> quad.setSpriteIndex(0)));
        }
    }

    private class_2350 getNormalDirection(UnbakedQuad quad) {
        class_1160 pos = quad.getPos(0, POSITIONS[0]);
        class_1160 dirA = quad.getPos(1, POSITIONS[1]);
        class_1160 dirB = quad.getPos(2, POSITIONS[2]);
        dirA.method_4944(pos);
        dirB.method_4944(pos);
        pos = MHelper.cross(dirA, dirB);
        return class_2350.method_10147((float)pos.method_4943(), (float)pos.method_4945(), (float)pos.method_4947());
    }

    @Nullable
    private class_2350 getCullingDirection(UnbakedQuad quad) {
        class_2350 dir = null;
        for (int i = 0; i < 4; ++i) {
            class_1160 pos = quad.getPos(i, POSITIONS[0]);
            if (pos.method_4943() < 1.0f && pos.method_4943() > 0.0f && pos.method_4945() < 1.0f && pos.method_4945() > 0.0f && pos.method_4947() < 1.0f && pos.method_4947() > 0.0f) {
                return null;
            }
            class_2350 newDir = class_2350.method_10147((float)(pos.method_4943() - 0.5f), (float)(pos.method_4945() - 0.5f), (float)(pos.method_4947() - 0.5f));
            if (dir == null) {
                dir = newDir;
                continue;
            }
            if (newDir == dir) continue;
            return null;
        }
        return dir;
    }
}

