/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.blocks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_1100;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1810;
import net.minecraft.class_1935;
import net.minecraft.class_2199;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_47;
import net.minecraft.class_4970;
import net.minecraft.class_793;
import org.jetbrains.annotations.Nullable;
import ru.bclib.blocks.BlockProperties;
import ru.bclib.client.models.BasePatterns;
import ru.bclib.client.models.ModelsHelper;
import ru.bclib.client.models.PatternsHelper;
import ru.bclib.interfaces.BlockModelProvider;
import ru.bclib.interfaces.CustomItemProvider;
import ru.bclib.items.BaseAnvilItem;

public abstract class BaseAnvilBlock
extends class_2199
implements BlockModelProvider,
CustomItemProvider {
    public static final class_2758 DESTRUCTION = BlockProperties.DESTRUCTION;
    public class_2758 durability;

    public BaseAnvilBlock(class_3620 color) {
        this(FabricBlockSettings.copyOf((class_4970)class_2246.field_10535).method_31710(color));
    }

    public BaseAnvilBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        this.durability = this.getMaxDurability() != 3 ? class_2758.method_11867((String)"durability", (int)0, (int)this.getMaxDurability()) : BlockProperties.DEFAULT_ANVIL_DURABILITY;
        builder.method_11667(new class_2769[]{DESTRUCTION, this.durability});
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_793 getItemModel(class_2960 blockId) {
        return this.getBlockModel(blockId, this.method_9564());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @Nullable
    public class_793 getBlockModel(class_2960 blockId, class_2680 blockState) {
        int destruction = (Integer)blockState.method_11654((class_2769)DESTRUCTION);
        String name = blockId.method_12832();
        HashMap textures = Maps.newHashMap();
        textures.put("%modid%", blockId.method_12836());
        textures.put("%anvil%", name);
        textures.put("%top%", name + "_top_" + destruction);
        Optional<String> pattern = PatternsHelper.createJson(BasePatterns.BLOCK_ANVIL, textures);
        return ModelsHelper.fromPattern(pattern);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_1100 getModelVariant(class_2960 stateId, class_2680 blockState, Map<class_2960, class_1100> modelCache) {
        int destruction = (Integer)blockState.method_11654((class_2769)DESTRUCTION);
        String modId = stateId.method_12836();
        String modelId = "block/" + stateId.method_12832() + "_top_" + destruction;
        class_2960 modelLocation = new class_2960(modId, modelId);
        this.registerBlockModel(stateId, modelLocation, blockState, modelCache);
        return ModelsHelper.createFacingModel(modelLocation, (class_2350)blockState.method_11654((class_2769)field_9883), false, false);
    }

    @Override
    public class_1747 getCustomItem(class_2960 blockID, FabricItemSettings settings) {
        return new BaseAnvilItem((class_2248)this, (class_1792.class_1793)settings);
    }

    public List<class_1799> method_9560(class_2680 state, class_47.class_48 builder) {
        int destruction = (Integer)state.method_11654((class_2769)DESTRUCTION);
        int durability = (Integer)state.method_11654((class_2769)this.getDurabilityProp());
        int value = destruction * this.getMaxDurability() + durability;
        class_1799 tool = (class_1799)builder.method_308(class_181.field_1229);
        if (tool != null && tool.method_7909() instanceof class_1810) {
            class_1799 itemStack = new class_1799((class_1935)this);
            itemStack.method_7948().method_10569("destruction", value);
            return Lists.newArrayList((Object[])new class_1799[]{itemStack});
        }
        return Collections.emptyList();
    }

    public class_2758 getDurabilityProp() {
        return this.durability;
    }

    public int getMaxDurability() {
        return 3;
    }

    public class_2680 damageAnvilUse(class_2680 state, Random random) {
        class_2758 durability = this.getDurabilityProp();
        int value = (Integer)state.method_11654((class_2769)durability);
        if (value < this.getMaxDurability() && random.nextInt(8) == 0) {
            return (class_2680)state.method_11657((class_2769)durability, (Comparable)Integer.valueOf(value + 1));
        }
        value = (Integer)state.method_11654((class_2769)DESTRUCTION);
        return value < 2 ? (class_2680)((class_2680)state.method_11657((class_2769)DESTRUCTION, (Comparable)Integer.valueOf(value + 1))).method_11657((class_2769)durability, (Comparable)Integer.valueOf(0)) : null;
    }

    public class_2680 damageAnvilFall(class_2680 state) {
        int destruction = (Integer)state.method_11654((class_2769)DESTRUCTION);
        return destruction < 2 ? (class_2680)state.method_11657((class_2769)DESTRUCTION, (Comparable)Integer.valueOf(destruction + 1)) : null;
    }
}

