/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.api.tag;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.tag.TagFactory;
import net.fabricmc.fabric.impl.tag.extension.TagDelegate;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_3494;
import net.minecraft.class_5414;
import ru.bclib.api.tag.CommonBlockTags;
import ru.bclib.api.tag.CommonItemTags;

public class TagAPI {
    private static final Map<class_2960, Set<class_2960>> TAGS_BLOCK = Maps.newConcurrentMap();
    private static final Map<class_2960, Set<class_2960>> TAGS_ITEM = Maps.newConcurrentMap();

    public static <T> TagNamed<T> makeTag(Supplier<class_5414<T>> containerSupplier, TagLocation<T> id) {
        class_3494 tag = containerSupplier.get().method_30210(id);
        return tag == null ? new Delegate<T>(id, containerSupplier) : CommonDelegate.proxy((class_3494.class_5123)tag);
    }

    public static TagNamed<class_2248> makeBlockTag(String modID, String name) {
        return TagAPI.makeTag(class_3481::method_15073, new TagLocation(modID, name));
    }

    public static TagNamed<class_1792> makeItemTag(String modID, String name) {
        return TagAPI.makeTag(class_3489::method_15106, new TagLocation(modID, name));
    }

    public static TagNamed<class_2248> makeCommonBlockTag(String name) {
        return TagAPI.makeTag(class_3481::method_15073, new TagLocation("c", name));
    }

    public static TagNamed<class_1792> makeCommonItemTag(String name) {
        return TagAPI.makeTag(class_3489::method_15106, new TagLocation("c", name));
    }

    @Deprecated(forRemoval=true)
    public static TagNamed<class_2248> getMCBlockTag(String name) {
        class_2960 id = new class_2960(name);
        class_3494 tag = class_3481.method_15073().method_30210(id);
        return CommonDelegate.proxy(tag == null ? TagFactory.BLOCK.create(id) : (class_3494.class_5123)tag);
    }

    public static void init() {
        TagAPI.addBlockTag(CommonBlockTags.BOOKSHELVES.getName(), class_2246.field_10504);
        TagAPI.addBlockTag(CommonBlockTags.CHEST.getName(), class_2246.field_10034);
        TagAPI.addItemTag(CommonItemTags.CHEST.getName(), new class_1935[]{class_1802.field_8106});
        TagAPI.addItemTag(CommonItemTags.IRON_INGOTS.getName(), new class_1935[]{class_1802.field_8620});
        TagAPI.addItemTag(CommonItemTags.FURNACES.getName(), new class_1935[]{class_2246.field_10181});
    }

    @SafeVarargs
    public static void addBlockTags(class_2248 block, TagLocation<class_2248> ... tagIDs) {
        for (TagLocation<class_2248> tagID : tagIDs) {
            TagAPI.addBlockTagUntyped(tagID, block);
        }
    }

    public static void addBlockTag(TagLocation<class_2248> tagID, class_2248 ... blocks) {
        TagAPI.addBlockTagUntyped(tagID, blocks);
    }

    protected static void addBlockTagUntyped(class_2960 tagID, class_2248 ... blocks) {
        Set set = TAGS_BLOCK.computeIfAbsent(tagID, k -> Sets.newHashSet());
        for (class_2248 block : blocks) {
            class_2960 id = class_2378.field_11146.method_10221((Object)block);
            if (id == class_2378.field_11146.method_10137()) continue;
            set.add(id);
        }
    }

    @SafeVarargs
    public static void addItemTags(class_1935 item, TagLocation<class_1792> ... tagIDs) {
        for (TagLocation<class_1792> tagID : tagIDs) {
            TagAPI.addItemTagUntyped(tagID, item);
        }
    }

    public static void addItemTag(TagLocation<class_1792> tagID, class_1935 ... items) {
        TagAPI.addItemTagUntyped(tagID, items);
    }

    protected static void addItemTagUntyped(class_2960 tagID, class_1935 ... items) {
        Set set = TAGS_ITEM.computeIfAbsent(tagID, k -> Sets.newHashSet());
        for (class_1935 item : items) {
            class_2960 id = class_2378.field_11142.method_10221((Object)item.method_8389());
            if (id == class_2378.field_11142.method_10137()) continue;
            set.add(id);
        }
    }

    public static Map<class_2960, class_3494.class_3495> apply(String directory, Map<class_2960, class_3494.class_3495> tagsMap) {
        Map<class_2960, Set<class_2960>> tagMap = null;
        if ("tags/blocks".equals(directory)) {
            tagMap = TAGS_BLOCK;
        } else if ("tags/items".equals(directory)) {
            tagMap = TAGS_ITEM;
        }
        if (tagMap != null) {
            tagMap.forEach((id, ids) -> TagAPI.apply(tagsMap.computeIfAbsent((class_2960)id, key -> class_3494.class_3495.method_26778()), ids));
        }
        return tagsMap;
    }

    public static class_3494.class_3495 apply(class_3494.class_3495 builder, Set<class_2960> ids) {
        ids.forEach(value -> builder.method_26784(value, "BCLib Code"));
        return builder;
    }

    private static final class Delegate<T>
    extends CommonDelegate<T> {
        public Delegate(TagLocation<T> id, Supplier<class_5414<T>> containerSupplier) {
            super(new TagDelegate(id, containerSupplier));
        }

        @Override
        public TagLocation<T> getName() {
            return (TagLocation)this.delegate.method_26791();
        }
    }

    public static class TagLocation<T>
    extends class_2960 {
        public TagLocation(String string) {
            super(string);
        }

        public TagLocation(String string, String string2) {
            super(string, string2);
        }

        public TagLocation(class_2960 location) {
            super(location.method_12836(), location.method_12832());
        }

        public static <R> TagLocation<R> of(class_3494.class_5123<R> tag) {
            return new TagLocation(tag.method_26791());
        }
    }

    private static abstract class CommonDelegate<T>
    implements TagNamed<T> {
        protected final class_3494.class_5123<T> delegate;

        protected CommonDelegate(class_3494.class_5123<T> source) {
            this.delegate = source;
        }

        public static <T> TagNamed<T> proxy(class_3494.class_5123<T> source) {
            if (source instanceof TagNamed) {
                TagNamed typed = (TagNamed)source;
                return typed;
            }
            return new ProxyDelegate<T>(source);
        }

        public boolean method_15141(T object) {
            return this.delegate.method_15141(object);
        }

        public List<T> method_15138() {
            return this.delegate.method_15138();
        }

        public T method_15142(Random random) {
            return (T)this.delegate.method_15142(random);
        }
    }

    public static interface TagNamed<T>
    extends class_3494.class_5123<T> {
        public TagLocation<T> getName();
    }

    private static final class ProxyDelegate<T>
    extends CommonDelegate<T> {
        private final TagLocation<T> id;

        private ProxyDelegate(class_3494.class_5123<T> source) {
            super(source);
            this.id = new TagLocation(source.method_26791().method_12836(), source.method_26791().method_12832());
        }

        @Override
        public TagLocation<T> getName() {
            return this.id;
        }
    }
}

