/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.api.surface;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1959;
import net.minecraft.class_2680;
import net.minecraft.class_5321;
import net.minecraft.class_5932;
import net.minecraft.class_6686;
import ru.bclib.api.biomes.BiomeAPI;
import ru.bclib.api.surface.SurfaceRuleEntry;
import ru.bclib.api.surface.rules.NoiseCondition;
import ru.bclib.world.surface.DoubleBlockSurfaceNoiseCondition;

public class SurfaceRuleBuilder {
    private static final Map<String, SurfaceRuleEntry> RULES_CACHE = Maps.newHashMap();
    private static final SurfaceRuleBuilder INSTANCE = new SurfaceRuleBuilder();
    private List<SurfaceRuleEntry> rules = Lists.newArrayList();
    private SurfaceRuleEntry entryInstance;
    private class_5321<class_1959> biomeKey;

    private SurfaceRuleBuilder() {
    }

    public static SurfaceRuleBuilder start() {
        SurfaceRuleBuilder.INSTANCE.biomeKey = null;
        SurfaceRuleBuilder.INSTANCE.rules.clear();
        return INSTANCE;
    }

    public SurfaceRuleBuilder biome(class_5321<class_1959> biomeKey) {
        this.biomeKey = biomeKey;
        return this;
    }

    public SurfaceRuleBuilder biome(class_1959 biome) {
        return this.biome((class_5321<class_1959>)BiomeAPI.getBiomeKey(biome));
    }

    public SurfaceRuleBuilder surface(class_2680 state) {
        this.entryInstance = SurfaceRuleBuilder.getFromCache("surface_" + state.toString(), () -> {
            class_6686.class_6708 rule = class_6686.method_39047((class_2680)state);
            rule = class_6686.method_39049((class_6686.class_6693)class_6686.field_35222, (class_6686.class_6708)rule);
            return new SurfaceRuleEntry(2, rule);
        });
        this.rules.add(this.entryInstance);
        return this;
    }

    public SurfaceRuleBuilder subsurface(class_2680 state, int depth) {
        this.entryInstance = SurfaceRuleBuilder.getFromCache("subsurface_" + depth + "_" + state.toString(), () -> {
            class_6686.class_6708 rule = class_6686.method_39047((class_2680)state);
            rule = class_6686.method_39049((class_6686.class_6693)class_6686.method_39549((int)depth, (boolean)false, (boolean)false, (class_5932)class_5932.field_29314), (class_6686.class_6708)rule);
            return new SurfaceRuleEntry(3, rule);
        });
        this.rules.add(this.entryInstance);
        return this;
    }

    public SurfaceRuleBuilder filler(class_2680 state) {
        this.entryInstance = SurfaceRuleBuilder.getFromCache("fill_" + state.toString(), () -> new SurfaceRuleEntry(10, class_6686.method_39047((class_2680)state)));
        this.rules.add(this.entryInstance);
        return this;
    }

    public SurfaceRuleBuilder floor(class_2680 state) {
        this.entryInstance = SurfaceRuleBuilder.getFromCache("floor_" + state.toString(), () -> {
            class_6686.class_6708 rule = class_6686.method_39047((class_2680)state);
            return new SurfaceRuleEntry(3, class_6686.method_39049((class_6686.class_6693)class_6686.field_35222, (class_6686.class_6708)rule));
        });
        this.rules.add(this.entryInstance);
        return this;
    }

    public SurfaceRuleBuilder belowFloor(class_2680 state, int height, NoiseCondition noise) {
        this.entryInstance = SurfaceRuleBuilder.getFromCache("below_floor_" + height + "_" + state.toString() + "_" + noise.getClass().getSimpleName(), () -> {
            class_6686.class_6708 rule = class_6686.method_39047((class_2680)state);
            rule = class_6686.method_39049((class_6686.class_6693)class_6686.method_39549((int)height, (boolean)false, (boolean)false, (class_5932)class_5932.field_29314), (class_6686.class_6708)class_6686.method_39049((class_6686.class_6693)noise, (class_6686.class_6708)rule));
            return new SurfaceRuleEntry(3, rule);
        });
        this.rules.add(this.entryInstance);
        return this;
    }

    public SurfaceRuleBuilder belowFloor(class_2680 state, int height) {
        this.entryInstance = SurfaceRuleBuilder.getFromCache("below_floor_" + height + "_" + state.toString(), () -> {
            class_6686.class_6708 rule = class_6686.method_39047((class_2680)state);
            rule = class_6686.method_39049((class_6686.class_6693)class_6686.method_39549((int)height, (boolean)false, (boolean)false, (class_5932)class_5932.field_29314), (class_6686.class_6708)rule);
            return new SurfaceRuleEntry(3, rule);
        });
        this.rules.add(this.entryInstance);
        return this;
    }

    public SurfaceRuleBuilder ceil(class_2680 state) {
        this.entryInstance = SurfaceRuleBuilder.getFromCache("ceil_" + state.toString(), () -> {
            class_6686.class_6708 rule = class_6686.method_39047((class_2680)state);
            return new SurfaceRuleEntry(3, class_6686.method_39049((class_6686.class_6693)class_6686.field_35494, (class_6686.class_6708)rule));
        });
        this.rules.add(this.entryInstance);
        return this;
    }

    public SurfaceRuleBuilder aboveCeil(class_2680 state, int height) {
        this.entryInstance = SurfaceRuleBuilder.getFromCache("above_ceil_" + height + "_" + state.toString(), () -> {
            class_6686.class_6708 rule = class_6686.method_39047((class_2680)state);
            rule = class_6686.method_39049((class_6686.class_6693)class_6686.method_39549((int)height, (boolean)false, (boolean)false, (class_5932)class_5932.field_29313), (class_6686.class_6708)rule);
            return new SurfaceRuleEntry(3, rule);
        });
        this.rules.add(this.entryInstance);
        return this;
    }

    public SurfaceRuleBuilder steep(class_2680 state, int depth) {
        this.entryInstance = SurfaceRuleBuilder.getFromCache("steep_" + depth + "_" + state.toString(), () -> {
            class_6686.class_6708 rule = class_6686.method_39047((class_2680)state);
            rule = class_6686.method_39049((class_6686.class_6693)class_6686.method_39549((int)depth, (boolean)false, (boolean)false, (class_5932)class_5932.field_29314), (class_6686.class_6708)rule);
            rule = class_6686.method_39049((class_6686.class_6693)class_6686.method_39045(), (class_6686.class_6708)rule);
            int priority = depth < 1 ? 0 : 1;
            return new SurfaceRuleEntry(priority, rule);
        });
        this.rules.add(this.entryInstance);
        return this;
    }

    public SurfaceRuleBuilder rule(int priority, class_6686.class_6708 rule) {
        this.rules.add(new SurfaceRuleEntry(priority, rule));
        return this;
    }

    public SurfaceRuleBuilder rule(class_6686.class_6708 rule) {
        return this.rule(7, rule);
    }

    public SurfaceRuleBuilder chancedFloor(class_2680 surfaceBlockA, class_2680 surfaceBlockB) {
        return this.chancedFloor(surfaceBlockA, surfaceBlockB, DoubleBlockSurfaceNoiseCondition.CONDITION);
    }

    public SurfaceRuleBuilder chancedFloor(class_2680 surfaceBlockA, class_2680 surfaceBlockB, NoiseCondition noise) {
        this.entryInstance = SurfaceRuleBuilder.getFromCache("chancedFloor_" + surfaceBlockA + "_" + surfaceBlockB + "_" + noise.getClass().getSimpleName(), () -> {
            class_6686.class_6708 rule = class_6686.method_39049((class_6686.class_6693)class_6686.field_35222, (class_6686.class_6708)class_6686.method_39050((class_6686.class_6708[])new class_6686.class_6708[]{class_6686.method_39049((class_6686.class_6693)noise, (class_6686.class_6708)class_6686.method_39047((class_2680)surfaceBlockA)), class_6686.method_39047((class_2680)surfaceBlockB)}));
            return new SurfaceRuleEntry(4, rule);
        });
        this.rules.add(this.entryInstance);
        return this;
    }

    public class_6686.class_6708 build() {
        Collections.sort(this.rules);
        List<class_6686.class_6708> ruleList = this.rules.stream().map(entry -> entry.getRule()).toList();
        class_6686.class_6708[] ruleArray = ruleList.toArray(new class_6686.class_6708[ruleList.size()]);
        class_6686.class_6708 rule = class_6686.method_39050((class_6686.class_6708[])ruleArray);
        if (this.biomeKey != null) {
            rule = class_6686.method_39049((class_6686.class_6693)class_6686.method_39055((class_5321[])new class_5321[]{this.biomeKey}), (class_6686.class_6708)rule);
        }
        return rule;
    }

    private static SurfaceRuleEntry getFromCache(String name, Supplier<SurfaceRuleEntry> supplier) {
        SurfaceRuleEntry entry = RULES_CACHE.get(name);
        if (entry == null) {
            entry = supplier.get();
            RULES_CACHE.put(name, entry);
        }
        return entry;
    }
}

