/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.api.dataexchange.handler.autosync;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3536;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.bclib.BCLib;
import ru.bclib.api.dataexchange.BaseDataHandler;
import ru.bclib.api.dataexchange.DataHandler;
import ru.bclib.api.dataexchange.DataHandlerDescriptor;
import ru.bclib.api.dataexchange.handler.DataExchange;
import ru.bclib.api.dataexchange.handler.autosync.ChunkerProgress;

public class Chunker
extends DataHandler.FromServer {
    private static final int HEADER_SIZE = 25;
    public static final int MAX_PACKET_SIZE = 0x100000;
    private static final int MAX_PAYLOAD_SIZE = 1048551;
    public static final DataHandlerDescriptor DESCRIPTOR = new DataHandlerDescriptor(new class_2960("bclib", "chunker"), Chunker::new, false, false);
    private int serialNo;
    private UUID uuid;
    private int chunkCount;
    private class_2540 networkedBuf;
    private class_2960 origin;
    private PacketChunkReceiver receiver;

    protected Chunker(int serialNo, UUID uuid, class_2540 networkedBuf, int chunkCount, class_2960 origin) {
        super(Chunker.DESCRIPTOR.IDENTIFIER);
        this.serialNo = serialNo;
        this.uuid = uuid;
        this.networkedBuf = networkedBuf;
        this.chunkCount = chunkCount;
        this.origin = origin;
    }

    protected Chunker() {
        super(Chunker.DESCRIPTOR.IDENTIFIER);
    }

    @Override
    protected void serializeDataOnServer(class_2540 buf) {
        buf.writeByte(0);
        buf.writeLong(this.uuid.getMostSignificantBits());
        buf.writeLong(this.uuid.getLeastSignificantBits());
        buf.writeInt(this.serialNo);
        if (this.serialNo == -1) {
            buf.writeInt(this.chunkCount);
            Chunker.writeString(buf, this.origin.method_12836());
            Chunker.writeString(buf, this.origin.method_12832());
        } else {
            buf.capacity(0x100000);
            int size = Math.min(1048551, this.networkedBuf.readableBytes());
            buf.writeInt(size);
            this.networkedBuf.readBytes((ByteBuf)buf, size);
        }
    }

    @Override
    protected void deserializeIncomingDataOnClient(class_2540 buf, PacketSender responseSender) {
        byte version = buf.readByte();
        this.uuid = new UUID(buf.readLong(), buf.readLong());
        this.serialNo = buf.readInt();
        if (this.serialNo == -1) {
            this.chunkCount = buf.readInt();
            String namespace = Chunker.readString(buf);
            String path = Chunker.readString(buf);
            class_2960 ident = new class_2960(namespace, path);
            BCLib.LOGGER.info("Receiving " + this.chunkCount + " + Packet-Chunks for " + ident);
            this.receiver = PacketChunkReceiver.getOrCreate(this.uuid, this.chunkCount, ident);
        } else {
            this.receiver = PacketChunkReceiver.get(this.uuid);
            if (this.receiver != null) {
                int size = buf.readInt();
                this.receiver.processReceived(buf, this.serialNo, size);
            } else {
                BCLib.LOGGER.error("Unknown Packet-Chunk Transfer for " + this.uuid);
            }
        }
    }

    @Override
    protected void runOnClientGameThread(class_310 client) {
        if (this.receiver != null) {
            this.receiver.testFinished();
        }
    }

    static class PacketChunkReceiver {
        @NotNull
        public final UUID uuid;
        public final int chunkCount;
        @NotNull
        private final class_2540 networkedBuf;
        @Nullable
        private final DataHandlerDescriptor descriptor;
        private static List<PacketChunkReceiver> active = new ArrayList<PacketChunkReceiver>(1);
        Map<Integer, class_2540> incomingBuffer = new HashMap<Integer, class_2540>();
        int lastReadSerial = -1;
        int receivedCount = 0;

        private static PacketChunkReceiver newReceiver(@NotNull UUID uuid, int chunkCount, class_2960 origin) {
            DataHandlerDescriptor desc = DataExchange.getDescriptor(origin);
            PacketChunkReceiver r = new PacketChunkReceiver(uuid, chunkCount, desc);
            active.add(r);
            return r;
        }

        private static PacketChunkReceiver getOrCreate(@NotNull UUID uuid, int chunkCount, class_2960 origin) {
            return active.stream().filter(r -> r.uuid.equals(uuid)).findFirst().orElse(PacketChunkReceiver.newReceiver(uuid, chunkCount, origin));
        }

        public static PacketChunkReceiver get(@NotNull UUID uuid) {
            return active.stream().filter(r -> r.uuid.equals(uuid)).findFirst().orElse(null);
        }

        private PacketChunkReceiver(@NotNull UUID uuid, int chunkCount, @Nullable DataHandlerDescriptor descriptor) {
            this.uuid = uuid;
            this.chunkCount = chunkCount;
            this.networkedBuf = PacketByteBufs.create();
            this.descriptor = descriptor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PacketChunkReceiver)) {
                return false;
            }
            PacketChunkReceiver that = (PacketChunkReceiver)o;
            return this.uuid.equals(that.uuid);
        }

        public int hashCode() {
            return Objects.hash(this.uuid);
        }

        public boolean testFinished() {
            class_3536 listener = ChunkerProgress.getProgressListener();
            if (listener != null) {
                listener.method_15410(100 * this.receivedCount / this.chunkCount);
            }
            if (this.incomingBuffer == null) {
                return true;
            }
            if (this.lastReadSerial >= this.chunkCount - 1) {
                this.onFinish();
                return true;
            }
            return false;
        }

        private void addBuffer(class_2540 input) {
            int size = input.readableBytes();
            int cap = this.networkedBuf.capacity() - this.networkedBuf.writerIndex();
            if (cap < size) {
                this.networkedBuf.capacity(this.networkedBuf.writerIndex() + size);
            }
            input.readBytes((ByteBuf)this.networkedBuf, size);
            input.clear();
        }

        protected void onFinish() {
            this.incomingBuffer.clear();
            this.incomingBuffer = null;
            BaseDataHandler baseHandler = this.descriptor.INSTANCE.get();
            if (baseHandler instanceof DataHandler.FromServer) {
                DataHandler.FromServer handler = (DataHandler.FromServer)baseHandler;
                handler.receiveFromMemory(this.networkedBuf);
            }
        }

        public void processReceived(class_2540 buf, int serialNo, int size) {
            ++this.receivedCount;
            if (this.lastReadSerial == serialNo - 1) {
                this.addBuffer(buf);
                this.lastReadSerial = serialNo;
            } else {
                int nr;
                boolean haveAll = true;
                for (nr = this.lastReadSerial + 1; nr < serialNo - 1; ++nr) {
                    if (this.incomingBuffer.get(nr) != null) continue;
                    haveAll = false;
                    break;
                }
                if (haveAll) {
                    for (nr = this.lastReadSerial + 1; nr < serialNo - 1; ++nr) {
                        this.addBuffer(this.incomingBuffer.get(nr));
                        this.incomingBuffer.put(nr, null);
                    }
                    this.addBuffer(buf);
                    this.lastReadSerial = serialNo;
                } else {
                    this.incomingBuffer.put(serialNo, buf);
                }
            }
        }
    }

    public static class PacketChunkSender {
        private final class_2540 networkedBuf;
        public final UUID uuid;
        public final int chunkCount;
        public final int size;
        public final class_2960 origin;

        public PacketChunkSender(class_2540 buf, class_2960 origin) {
            this.networkedBuf = buf;
            this.size = buf.readableBytes();
            this.chunkCount = (int)Math.ceil((double)this.size / 1048551.0);
            this.uuid = UUID.randomUUID();
            this.origin = origin;
        }

        public void sendChunks(Collection<class_3222> players) {
            BCLib.LOGGER.info("Sending Request in " + this.chunkCount + " Packet-Chunks");
            for (int i = -1; i < this.chunkCount; ++i) {
                Chunker c = new Chunker(i, this.uuid, this.networkedBuf, this.chunkCount, this.origin);
                class_2540 buf = PacketByteBufs.create();
                c.serializeDataOnServer(buf);
                for (class_3222 player : players) {
                    ServerPlayNetworking.send((class_3222)player, (class_2960)Chunker.DESCRIPTOR.IDENTIFIER, (class_2540)buf);
                }
            }
        }
    }
}

