/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.api.dataexchange.handler;

import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2960;
import ru.bclib.api.dataexchange.BaseDataHandler;
import ru.bclib.api.dataexchange.ConnectorClientside;
import ru.bclib.api.dataexchange.ConnectorServerside;
import ru.bclib.api.dataexchange.DataExchangeAPI;
import ru.bclib.api.dataexchange.DataHandlerDescriptor;

public abstract class DataExchange {
    private static DataExchangeAPI instance;
    protected ConnectorServerside server;
    protected ConnectorClientside client;
    protected final Set<DataHandlerDescriptor> descriptors = new HashSet<DataHandlerDescriptor>();
    private boolean didLoadSyncFolder = false;

    protected static DataExchangeAPI getInstance() {
        if (instance == null) {
            instance = new DataExchangeAPI();
        }
        return instance;
    }

    protected abstract ConnectorClientside clientSupplier(DataExchange var1);

    protected abstract ConnectorServerside serverSupplier(DataExchange var1);

    protected DataExchange() {
    }

    public Set<DataHandlerDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public static DataHandlerDescriptor getDescriptor(class_2960 identifier) {
        return DataExchange.getInstance().descriptors.stream().filter(d -> d.equals(identifier)).findFirst().orElse(null);
    }

    @Environment(value=EnvType.CLIENT)
    protected void initClientside() {
        if (this.client != null) {
            return;
        }
        this.client = this.clientSupplier(this);
        ClientPlayConnectionEvents.INIT.register(this.client::onPlayInit);
        ClientPlayConnectionEvents.JOIN.register(this.client::onPlayReady);
        ClientPlayConnectionEvents.DISCONNECT.register(this.client::onPlayDisconnect);
    }

    protected void initServerSide() {
        if (this.server != null) {
            return;
        }
        this.server = this.serverSupplier(this);
        ServerPlayConnectionEvents.INIT.register(this.server::onPlayInit);
        ServerPlayConnectionEvents.JOIN.register(this.server::onPlayReady);
        ServerPlayConnectionEvents.DISCONNECT.register(this.server::onPlayDisconnect);
    }

    @Environment(value=EnvType.CLIENT)
    public static void prepareClientside() {
        DataExchangeAPI api = DataExchange.getInstance();
        api.initClientside();
    }

    public static void prepareServerside() {
        DataExchangeAPI api = DataExchange.getInstance();
        api.initServerSide();
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendOnEnter() {
        DataExchange.getInstance().descriptors.forEach(desc -> {
            BaseDataHandler h;
            if (desc.sendBeforeEnter && !(h = desc.JOIN_INSTANCE.get()).getOriginatesOnServer()) {
                DataExchange.getInstance().client.sendToServer(h);
            }
        });
    }
}

