/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.api.biomes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_2893;
import net.minecraft.class_2922;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3864;
import net.minecraft.class_4761;
import net.minecraft.class_4763;
import net.minecraft.class_4967;
import net.minecraft.class_4968;
import net.minecraft.class_5195;
import net.minecraft.class_5312;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_5483;
import net.minecraft.class_5485;
import net.minecraft.class_6686;
import net.minecraft.class_6731;
import net.minecraft.class_6796;
import ru.bclib.api.surface.SurfaceRuleBuilder;
import ru.bclib.entity.BCLEntityWrapper;
import ru.bclib.mixin.common.BiomeGenerationSettingsAccessor;
import ru.bclib.util.ColorUtil;
import ru.bclib.util.TriFunction;
import ru.bclib.world.biomes.BCLBiome;
import ru.bclib.world.biomes.BCLBiomeSettings;
import ru.bclib.world.features.BCLFeature;
import ru.bclib.world.structures.BCLStructureFeature;

public class BCLBiomeBuilder {
    private static final BCLBiomeBuilder INSTANCE = new BCLBiomeBuilder();
    private static final class_6686.class_6693 SURFACE_NOISE = class_6686.method_39052((class_5321)class_6731.field_35383, (double)-0.012);
    private List<class_5312> structures = new ArrayList<class_5312>(16);
    private class_5485.class_5495 generationSettings;
    private class_4763.class_4764 effectsBuilder;
    private class_5483.class_5496 spawnSettings;
    private class_6686.class_6708 surfaceRule;
    private class_1959.class_1963 precipitation;
    private class_2960 biomeID;
    private class_1959.class_1961 category;
    private float temperature;
    private float fogDensity;
    private float genChance;
    private float downfall;
    private float height;
    private int edgeSize;
    private BCLBiome edge;
    private boolean vertical;

    public static BCLBiomeBuilder start(class_2960 biomeID) {
        BCLBiomeBuilder.INSTANCE.biomeID = biomeID;
        BCLBiomeBuilder.INSTANCE.precipitation = class_1959.class_1963.field_9384;
        BCLBiomeBuilder.INSTANCE.category = class_1959.class_1961.field_9371;
        BCLBiomeBuilder.INSTANCE.generationSettings = null;
        BCLBiomeBuilder.INSTANCE.effectsBuilder = null;
        BCLBiomeBuilder.INSTANCE.spawnSettings = null;
        BCLBiomeBuilder.INSTANCE.structures.clear();
        BCLBiomeBuilder.INSTANCE.temperature = 1.0f;
        BCLBiomeBuilder.INSTANCE.fogDensity = 1.0f;
        BCLBiomeBuilder.INSTANCE.edgeSize = 0;
        BCLBiomeBuilder.INSTANCE.downfall = 1.0f;
        BCLBiomeBuilder.INSTANCE.genChance = 1.0f;
        BCLBiomeBuilder.INSTANCE.height = 0.1f;
        BCLBiomeBuilder.INSTANCE.vertical = false;
        BCLBiomeBuilder.INSTANCE.edge = null;
        return INSTANCE;
    }

    public BCLBiomeBuilder precipitation(class_1959.class_1963 precipitation) {
        this.precipitation = precipitation;
        return this;
    }

    public BCLBiomeBuilder category(class_1959.class_1961 category) {
        this.category = category;
        return this;
    }

    public BCLBiomeBuilder temperature(float temperature) {
        this.temperature = temperature;
        return this;
    }

    public BCLBiomeBuilder wetness(float wetness) {
        this.downfall = wetness;
        return this;
    }

    public <M extends class_1308> BCLBiomeBuilder spawn(class_1299<M> entityType, int weight, int minGroupCount, int maxGroupCount) {
        this.getSpawns().method_31011(entityType.method_5891(), new class_5483.class_1964(entityType, weight, minGroupCount, maxGroupCount));
        return this;
    }

    public <M extends class_1308> BCLBiomeBuilder spawn(BCLEntityWrapper<M> wrapper, int weight, int minGroupCount, int maxGroupCount) {
        if (wrapper.canSpawn()) {
            return this.spawn(wrapper.type(), weight, minGroupCount, maxGroupCount);
        }
        return this;
    }

    public BCLBiomeBuilder particles(class_2394 particle, float probability) {
        this.getEffects().method_24393(new class_4761(particle, probability));
        return this;
    }

    public BCLBiomeBuilder skyColor(int color) {
        this.getEffects().method_30820(color);
        return this;
    }

    public BCLBiomeBuilder skyColor(int red, int green, int blue) {
        red = class_3532.method_15340((int)red, (int)0, (int)255);
        green = class_3532.method_15340((int)green, (int)0, (int)255);
        blue = class_3532.method_15340((int)blue, (int)0, (int)255);
        return this.skyColor(ColorUtil.color(red, green, blue));
    }

    public BCLBiomeBuilder fogColor(int color) {
        this.getEffects().method_24392(color);
        return this;
    }

    public BCLBiomeBuilder fogColor(int red, int green, int blue) {
        red = class_3532.method_15340((int)red, (int)0, (int)255);
        green = class_3532.method_15340((int)green, (int)0, (int)255);
        blue = class_3532.method_15340((int)blue, (int)0, (int)255);
        return this.fogColor(ColorUtil.color(red, green, blue));
    }

    public BCLBiomeBuilder fogDensity(float density) {
        this.fogDensity = density;
        return this;
    }

    public BCLBiomeBuilder genChance(float genChance) {
        this.genChance = genChance;
        return this;
    }

    public BCLBiomeBuilder edgeSize(int edgeSize) {
        this.edgeSize = edgeSize;
        return this;
    }

    public BCLBiomeBuilder edge(BCLBiome edge) {
        this.edge = edge;
        return this;
    }

    public BCLBiomeBuilder edge(BCLBiome edge, int edgeSize) {
        this.edge(edge);
        this.edgeSize(edgeSize);
        return this;
    }

    public BCLBiomeBuilder waterColor(int color) {
        this.getEffects().method_24395(color);
        return this;
    }

    public BCLBiomeBuilder waterColor(int red, int green, int blue) {
        red = class_3532.method_15340((int)red, (int)0, (int)255);
        green = class_3532.method_15340((int)green, (int)0, (int)255);
        blue = class_3532.method_15340((int)blue, (int)0, (int)255);
        return this.waterColor(ColorUtil.color(red, green, blue));
    }

    public BCLBiomeBuilder waterFogColor(int color) {
        this.getEffects().method_24397(color);
        return this;
    }

    public BCLBiomeBuilder waterFogColor(int red, int green, int blue) {
        red = class_3532.method_15340((int)red, (int)0, (int)255);
        green = class_3532.method_15340((int)green, (int)0, (int)255);
        blue = class_3532.method_15340((int)blue, (int)0, (int)255);
        return this.waterFogColor(ColorUtil.color(red, green, blue));
    }

    public BCLBiomeBuilder waterAndFogColor(int color) {
        return this.waterColor(color).waterFogColor(color);
    }

    public BCLBiomeBuilder waterAndFogColor(int red, int green, int blue) {
        red = class_3532.method_15340((int)red, (int)0, (int)255);
        green = class_3532.method_15340((int)green, (int)0, (int)255);
        blue = class_3532.method_15340((int)blue, (int)0, (int)255);
        return this.waterAndFogColor(ColorUtil.color(red, green, blue));
    }

    public BCLBiomeBuilder grassColor(int color) {
        this.getEffects().method_30822(color);
        return this;
    }

    public BCLBiomeBuilder grassColor(int red, int green, int blue) {
        red = class_3532.method_15340((int)red, (int)0, (int)255);
        green = class_3532.method_15340((int)green, (int)0, (int)255);
        blue = class_3532.method_15340((int)blue, (int)0, (int)255);
        return this.grassColor(ColorUtil.color(red, green, blue));
    }

    public BCLBiomeBuilder foliageColor(int color) {
        this.getEffects().method_30821(color);
        return this;
    }

    public BCLBiomeBuilder foliageColor(int red, int green, int blue) {
        red = class_3532.method_15340((int)red, (int)0, (int)255);
        green = class_3532.method_15340((int)green, (int)0, (int)255);
        blue = class_3532.method_15340((int)blue, (int)0, (int)255);
        return this.foliageColor(ColorUtil.color(red, green, blue));
    }

    public BCLBiomeBuilder plantsColor(int color) {
        return this.grassColor(color).foliageColor(color);
    }

    public BCLBiomeBuilder plantsColor(int red, int green, int blue) {
        red = class_3532.method_15340((int)red, (int)0, (int)255);
        green = class_3532.method_15340((int)green, (int)0, (int)255);
        blue = class_3532.method_15340((int)blue, (int)0, (int)255);
        return this.plantsColor(ColorUtil.color(red, green, blue));
    }

    public BCLBiomeBuilder music(class_5195 music) {
        this.getEffects().method_27346(music);
        return this;
    }

    public BCLBiomeBuilder music(class_3414 music) {
        return this.music(new class_5195(music, 600, 2400, true));
    }

    public BCLBiomeBuilder loop(class_3414 loopSound) {
        this.getEffects().method_24942(loopSound);
        return this;
    }

    public BCLBiomeBuilder mood(class_3414 mood, int tickDelay, int blockSearchExtent, float soundPositionOffset) {
        this.getEffects().method_24943(new class_4968(mood, tickDelay, blockSearchExtent, (double)soundPositionOffset));
        return this;
    }

    public BCLBiomeBuilder mood(class_3414 mood) {
        return this.mood(mood, 6000, 8, 2.0f);
    }

    public BCLBiomeBuilder additions(class_3414 additions, float intensity) {
        this.getEffects().method_24944(new class_4967(additions, (double)intensity));
        return this;
    }

    public BCLBiomeBuilder additions(class_3414 additions) {
        return this.additions(additions, 0.0111f);
    }

    public BCLBiomeBuilder feature(class_2893.class_2895 decoration, class_6796 feature) {
        this.getGeneration().method_30992(decoration, feature);
        return this;
    }

    public BCLBiomeBuilder defaultMushrooms() {
        return this.feature(class_3864::method_16982);
    }

    public BCLBiomeBuilder netherDefaultOres() {
        return this.feature(class_3864::method_24382);
    }

    public BCLBiomeBuilder feature(Consumer<class_5485.class_5495> featureAdd) {
        featureAdd.accept(this.getGeneration());
        return this;
    }

    public BCLBiomeBuilder feature(BCLFeature feature) {
        return this.feature(feature.getDecoration(), feature.getPlacedFeature());
    }

    public BCLBiomeBuilder structure(class_5312<?, ?> structure) {
        this.structures.add(structure);
        return this;
    }

    public BCLBiomeBuilder structure(BCLStructureFeature structure) {
        structure.addInternalBiome(this.biomeID);
        return this.structure(structure.getFeatureConfigured());
    }

    public BCLBiomeBuilder carver(class_2893.class_2894 step, class_2922<?> carver) {
        class_2960 immutableID = this.biomeID;
        class_5458.field_25928.method_29113(carver).ifPresent(key -> BiomeModifications.addCarver(ctx -> ctx.getBiomeKey().method_29177().equals((Object)immutableID), (class_2893.class_2894)step, (class_5321)key));
        return this;
    }

    public BCLBiomeBuilder surface(class_2248 surfaceBlock) {
        return this.surface(surfaceBlock.method_9564());
    }

    public BCLBiomeBuilder surface(class_2680 surfaceBlock) {
        return this.surface(SurfaceRuleBuilder.start().surface(surfaceBlock).build());
    }

    public BCLBiomeBuilder surface(class_2248 surfaceBlock, class_2248 subterrainBlock, int depth) {
        return this.surface(SurfaceRuleBuilder.start().surface(surfaceBlock.method_9564()).subsurface(subterrainBlock.method_9564(), depth).build());
    }

    public BCLBiomeBuilder surface(class_6686.class_6708 newSurfaceRule) {
        this.surfaceRule = newSurfaceRule;
        return this;
    }

    public BCLBiomeBuilder terrainHeight(float height) {
        this.height = height;
        return this;
    }

    public BCLBiomeBuilder vertical() {
        this.vertical = this.vertical;
        return this;
    }

    public BCLBiome build() {
        return this.build(BCLBiome::new);
    }

    @Deprecated(forRemoval=true)
    public <T extends BCLBiome> T build(BiFunction<class_2960, class_1959, T> biomeConstructor) {
        return this.build((id, biome, settings) -> (BCLBiome)biomeConstructor.apply((class_2960)id, (class_1959)biome));
    }

    public <T extends BCLBiome> T build(BiomeSupplier<T> biomeConstructor) {
        class_1959.class_1960 builder = new class_1959.class_1960().method_8735(this.precipitation).method_8738(this.category).method_8747(this.temperature).method_8727(this.downfall);
        builder.method_30974(this.getSpawns().method_31007());
        builder.method_24379(this.getEffects().method_24391());
        HashMap<class_2893.class_2895, List<Supplier<class_6796>>> defferedFeatures = new HashMap<class_2893.class_2895, List<Supplier<class_6796>>>();
        BiomeGenerationSettingsAccessor acc = (BiomeGenerationSettingsAccessor)BiomeGenerationSettingsAccessor.class.cast(this.getGeneration().method_30987());
        if (acc != null) {
            builder.method_30973(new class_5485.class_5495().method_30987());
            List<List<Supplier<class_6796>>> decorations = acc.bclib_getFeatures();
            for (class_2893.class_2895 d : class_2893.class_2895.values()) {
                int i = d.ordinal();
                if (i >= 0 && i < decorations.size()) {
                    List<Supplier<class_6796>> features = decorations.get(i);
                    defferedFeatures.put(d, features.stream().collect(Collectors.toList()));
                    continue;
                }
                defferedFeatures.put(d, new ArrayList(0));
            }
        } else {
            builder.method_30973(this.getGeneration().method_30987());
        }
        Object settings = ((BCLBiomeSettings.Builder)((BCLBiomeSettings.Builder)((BCLBiomeSettings.Builder)((BCLBiomeSettings.Builder)((BCLBiomeSettings.Builder)((BCLBiomeSettings.Builder)BCLBiomeSettings.createBCL().setTerrainHeight(this.height)).setFogDensity(this.fogDensity)).setGenChance(this.genChance)).setEdgeSize(this.edgeSize)).setEdge(this.edge)).setVertical(this.vertical)).build();
        BCLBiome res = (BCLBiome)biomeConstructor.apply(this.biomeID, builder.method_30972(), settings);
        res.attachStructures(this.structures);
        res.setSurface(this.surfaceRule);
        res.setFeatures(defferedFeatures);
        return (T)res;
    }

    private class_4763.class_4764 getEffects() {
        if (this.effectsBuilder == null) {
            this.effectsBuilder = new class_4763.class_4764();
        }
        return this.effectsBuilder;
    }

    private class_5483.class_5496 getSpawns() {
        if (this.spawnSettings == null) {
            this.spawnSettings = new class_5483.class_5496();
        }
        return this.spawnSettings;
    }

    private class_5485.class_5495 getGeneration() {
        if (this.generationSettings == null) {
            this.generationSettings = new class_5485.class_5495();
        }
        return this.generationSettings;
    }

    @FunctionalInterface
    public static interface BiomeSupplier<T>
    extends TriFunction<class_2960, class_1959, BCLBiomeSettings, T> {
    }
}

