/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.api;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import ru.bclib.api.biomes.BiomeAPI;
import ru.bclib.api.tag.TagAPI;
import ru.bclib.blocks.BaseBarrelBlock;
import ru.bclib.blocks.BaseChestBlock;
import ru.bclib.blocks.BaseFurnaceBlock;
import ru.bclib.blocks.BaseSignBlock;
import ru.bclib.client.render.BCLRenderLayer;
import ru.bclib.client.render.BaseChestBlockEntityRenderer;
import ru.bclib.client.render.BaseSignBlockEntityRenderer;
import ru.bclib.config.Configs;
import ru.bclib.interfaces.PostInitable;
import ru.bclib.interfaces.RenderLayerProvider;
import ru.bclib.interfaces.TagProvider;
import ru.bclib.registry.BaseBlockEntities;

public class PostInitAPI {
    private static List<Consumer<Boolean>> postInitFunctions = Lists.newArrayList();
    private static List<TagAPI.TagLocation<class_2248>> blockTags = Lists.newArrayList();
    private static List<TagAPI.TagLocation<class_1792>> itemTags = Lists.newArrayList();

    public static void register(Consumer<Boolean> function) {
        postInitFunctions.add(function);
    }

    public static void postInit(boolean isClient) {
        if (postInitFunctions == null) {
            return;
        }
        postInitFunctions.forEach(function -> function.accept(isClient));
        class_2378.field_11146.forEach(block -> {
            PostInitAPI.processBlockCommon(block);
            if (isClient) {
                PostInitAPI.processBlockClient(block);
            }
        });
        postInitFunctions = null;
        blockTags = null;
        itemTags = null;
        BiomeAPI.loadFabricAPIBiomes();
        Configs.BIOMES_CONFIG.saveChanges();
    }

    @Environment(value=EnvType.CLIENT)
    private static void processBlockClient(class_2248 block) {
        if (block instanceof RenderLayerProvider) {
            BCLRenderLayer layer = ((RenderLayerProvider)block).getRenderLayer();
            if (layer == BCLRenderLayer.CUTOUT) {
                BlockRenderLayerMap.INSTANCE.putBlock(block, class_1921.method_23581());
            } else if (layer == BCLRenderLayer.TRANSLUCENT) {
                BlockRenderLayerMap.INSTANCE.putBlock(block, class_1921.method_23583());
            }
        }
        if (block instanceof BaseChestBlock) {
            BaseChestBlockEntityRenderer.registerRenderLayer(block);
        } else if (block instanceof BaseSignBlock) {
            BaseSignBlockEntityRenderer.registerRenderLayer(block);
        }
    }

    private static void processBlockCommon(class_2248 block) {
        if (block instanceof PostInitable) {
            ((PostInitable)block).postInit();
        }
        if (block instanceof BaseChestBlock) {
            BaseBlockEntities.CHEST.registerBlock(block);
        } else if (block instanceof BaseSignBlock) {
            BaseBlockEntities.SIGN.registerBlock(block);
        } else if (block instanceof BaseBarrelBlock) {
            BaseBlockEntities.BARREL.registerBlock(block);
        } else if (block instanceof BaseFurnaceBlock) {
            BaseBlockEntities.FURNACE.registerBlock(block);
        }
        if (block instanceof TagProvider) {
            ((TagProvider)TagProvider.class.cast(block)).addTags(blockTags, itemTags);
            blockTags.forEach(tag -> TagAPI.addBlockTag(tag, block));
            itemTags.forEach(tag -> TagAPI.addItemTag(tag, new class_1935[]{block}));
            blockTags.clear();
            itemTags.clear();
        }
    }
}

