/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.api;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import ru.bclib.util.WeightedList;

public class BonemealAPI {
    private static final Map<class_2960, Map<class_2248, WeightedList<class_2248>>> WATER_GRASS_BIOMES = Maps.newHashMap();
    private static final Map<class_2960, Map<class_2248, WeightedList<class_2248>>> LAND_GRASS_BIOMES = Maps.newHashMap();
    private static final Map<class_2248, WeightedList<class_2248>> WATER_GRASS_TYPES = Maps.newHashMap();
    private static final Map<class_2248, WeightedList<class_2248>> LAND_GRASS_TYPES = Maps.newHashMap();
    private static final Map<class_2248, class_2248> SPREADABLE_BLOCKS = Maps.newHashMap();
    private static final Set<class_2248> TERRAIN_TO_SPREAD = Sets.newHashSet();
    private static final Set<class_2248> TERRAIN = Sets.newHashSet();

    public static void addSpreadableBlock(class_2248 spreadableBlock, class_2248 surfaceForSpread) {
        SPREADABLE_BLOCKS.put(spreadableBlock, surfaceForSpread);
        TERRAIN_TO_SPREAD.add(surfaceForSpread);
        TERRAIN.add(surfaceForSpread);
    }

    public static boolean isTerrain(class_2248 block) {
        return TERRAIN.contains(block);
    }

    public static boolean isSpreadableTerrain(class_2248 block) {
        return TERRAIN_TO_SPREAD.contains(block);
    }

    public static class_2248 getSpreadable(class_2248 block) {
        return SPREADABLE_BLOCKS.get(block);
    }

    public static void addLandGrass(class_2248 plant, class_2248 ... terrain) {
        for (class_2248 block : terrain) {
            BonemealAPI.addLandGrass(plant, block, 1.0f);
        }
    }

    public static void addLandGrass(class_2960 biome, class_2248 plant, class_2248 ... terrain) {
        for (class_2248 block : terrain) {
            BonemealAPI.addLandGrass(biome, plant, block, 1.0f);
        }
    }

    public static void addLandGrass(class_2248 plant, class_2248 terrain, float chance) {
        WeightedList<Object> list = LAND_GRASS_TYPES.get(terrain);
        if (list == null) {
            list = new WeightedList();
            LAND_GRASS_TYPES.put(terrain, list);
        }
        TERRAIN.add(terrain);
        list.add(plant, chance);
    }

    public static void addLandGrass(class_2960 biome, class_2248 plant, class_2248 terrain, float chance) {
        WeightedList<class_2248> list;
        HashMap map = LAND_GRASS_BIOMES.get(biome);
        if (map == null) {
            map = Maps.newHashMap();
            LAND_GRASS_BIOMES.put(biome, map);
        }
        if ((list = (WeightedList<class_2248>)map.get(terrain)) == null) {
            list = new WeightedList<class_2248>();
            map.put(terrain, list);
        }
        TERRAIN.add(terrain);
        list.add(plant, chance);
    }

    public static void addWaterGrass(class_2248 plant, class_2248 ... terrain) {
        for (class_2248 block : terrain) {
            BonemealAPI.addWaterGrass(plant, block, 1.0f);
        }
    }

    public static void addWaterGrass(class_2960 biome, class_2248 plant, class_2248 ... terrain) {
        for (class_2248 block : terrain) {
            BonemealAPI.addWaterGrass(biome, plant, block, 1.0f);
        }
    }

    public static void addWaterGrass(class_2248 plant, class_2248 terrain, float chance) {
        WeightedList<Object> list = WATER_GRASS_TYPES.get(terrain);
        if (list == null) {
            list = new WeightedList();
            WATER_GRASS_TYPES.put(terrain, list);
        }
        TERRAIN.add(terrain);
        list.add(plant, chance);
    }

    public static void addWaterGrass(class_2960 biome, class_2248 plant, class_2248 terrain, float chance) {
        WeightedList<class_2248> list;
        HashMap map = WATER_GRASS_BIOMES.get(biome);
        if (map == null) {
            map = Maps.newHashMap();
            WATER_GRASS_BIOMES.put(biome, map);
        }
        if ((list = (WeightedList<class_2248>)map.get(terrain)) == null) {
            list = new WeightedList<class_2248>();
            map.put(terrain, list);
        }
        TERRAIN.add(terrain);
        list.add(plant, chance);
    }

    public static class_2248 getLandGrass(class_2960 biomeID, class_2248 terrain, Random random) {
        Map<class_2248, WeightedList<class_2248>> map = LAND_GRASS_BIOMES.get(biomeID);
        WeightedList<class_2248> list = null;
        if (map != null) {
            list = map.get(terrain);
            if (list == null) {
                list = LAND_GRASS_TYPES.get(terrain);
            }
        } else {
            list = LAND_GRASS_TYPES.get(terrain);
        }
        return list == null ? null : list.get(random);
    }

    public static class_2248 getWaterGrass(class_2960 biomeID, class_2248 terrain, Random random) {
        Map<class_2248, WeightedList<class_2248>> map = WATER_GRASS_BIOMES.get(biomeID);
        WeightedList<class_2248> list = null;
        if (map != null) {
            list = map.get(terrain);
            if (list == null) {
                list = WATER_GRASS_TYPES.get(terrain);
            }
        } else {
            list = WATER_GRASS_TYPES.get(terrain);
        }
        return list == null ? null : list.get(random);
    }
}

