/*
 * Decompiled with CFR 0.152.
 */
package techreborn.packets;

import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import reborncore.common.network.IdentifiedPacket;
import reborncore.common.network.NetworkManager;
import techreborn.blockentity.machine.iron.IronFurnaceBlockEntity;
import techreborn.blockentity.machine.multiblock.FusionControlComputerBlockEntity;
import techreborn.blockentity.machine.tier1.AutoCraftingTableBlockEntity;
import techreborn.blockentity.machine.tier1.PlayerDetectorBlockEntity;
import techreborn.blockentity.machine.tier1.RollingMachineBlockEntity;
import techreborn.blockentity.machine.tier3.ChunkLoaderBlockEntity;
import techreborn.blockentity.storage.energy.AdjustableSUBlockEntity;
import techreborn.blockentity.storage.item.StorageUnitBaseBlockEntity;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRContent;

public class ServerboundPackets {
    public static final class_2960 AESU = new class_2960("techreborn", "aesu");
    public static final class_2960 AUTO_CRAFTING_LOCK = new class_2960("techreborn", "auto_crafting_lock");
    public static final class_2960 ROLLING_MACHINE_LOCK = new class_2960("techreborn", "rolling_machine_lock");
    public static final class_2960 STORAGE_UNIT_LOCK = new class_2960("techreborn", "storage_unit_lock");
    public static final class_2960 FUSION_CONTROL_SIZE = new class_2960("techreborn", "fusion_control_size");
    public static final class_2960 REFUND = new class_2960("techreborn", "refund");
    public static final class_2960 CHUNKLOADER = new class_2960("techreborn", "chunkloader");
    public static final class_2960 EXPERIENCE = new class_2960("techreborn", "experience");
    public static final class_2960 DETECTOR_RADIUS = new class_2960("techreborn", "detector_radius");

    public static void init() {
        NetworkManager.registerServerBoundHandler((class_2960)AESU, (server, player, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            int buttonID = buf.readInt();
            boolean shift = buf.readBoolean();
            boolean ctrl = buf.readBoolean();
            server.execute(() -> {
                class_2586 blockEntity = player.field_6002.method_8321(pos);
                if (blockEntity instanceof AdjustableSUBlockEntity) {
                    ((AdjustableSUBlockEntity)blockEntity).handleGuiInputFromClient(buttonID, shift, ctrl);
                }
            });
        });
        NetworkManager.registerServerBoundHandler((class_2960)AUTO_CRAFTING_LOCK, (server, player, handler, buf, responseSender) -> {
            class_2338 machinePos = buf.method_10811();
            boolean locked = buf.readBoolean();
            server.execute(() -> {
                class_2586 BlockEntity = player.field_6002.method_8321(machinePos);
                if (BlockEntity instanceof AutoCraftingTableBlockEntity) {
                    ((AutoCraftingTableBlockEntity)BlockEntity).locked = locked;
                }
            });
        });
        NetworkManager.registerServerBoundHandler((class_2960)FUSION_CONTROL_SIZE, (server, player, handler, buf, responseSender) -> {
            int sizeDelta = buf.readInt();
            class_2338 pos = buf.method_10811();
            server.execute(() -> {
                class_2586 blockEntity = player.field_6002.method_8321(pos);
                if (blockEntity instanceof FusionControlComputerBlockEntity) {
                    ((FusionControlComputerBlockEntity)blockEntity).changeSize(sizeDelta);
                }
            });
        });
        NetworkManager.registerServerBoundHandler((class_2960)ROLLING_MACHINE_LOCK, (server, player, handler, buf, responseSender) -> {
            class_2338 machinePos = buf.method_10811();
            boolean locked = buf.readBoolean();
            server.execute(() -> {
                class_2586 BlockEntity = player.field_6002.method_8321(machinePos);
                if (BlockEntity instanceof RollingMachineBlockEntity) {
                    ((RollingMachineBlockEntity)BlockEntity).locked = locked;
                }
            });
        });
        NetworkManager.registerServerBoundHandler((class_2960)STORAGE_UNIT_LOCK, (server, player, handler, buf, responseSender) -> {
            class_2338 machinePos = buf.method_10811();
            boolean locked = buf.readBoolean();
            server.execute(() -> {
                class_2586 BlockEntity = player.field_6002.method_8321(machinePos);
                if (BlockEntity instanceof StorageUnitBaseBlockEntity) {
                    ((StorageUnitBaseBlockEntity)BlockEntity).setLocked(locked);
                }
            });
        });
        NetworkManager.registerServerBoundHandler((class_2960)REFUND, (server, player, handler, buf, responseSender) -> {
            if (!TechRebornConfig.allowManualRefund) {
                return;
            }
            server.execute(() -> {
                for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                    class_1799 stack = player.method_31548().method_5438(i);
                    if (stack.method_7909() != TRContent.MANUAL) continue;
                    player.method_31548().method_5441(i);
                    player.method_31548().method_7394(new class_1799((class_1935)class_1802.field_8529));
                    player.method_31548().method_7394(TRContent.Ingots.REFINED_IRON.getStack());
                    return;
                }
            });
        });
        NetworkManager.registerServerBoundHandler((class_2960)CHUNKLOADER, (server, player, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            int buttonID = buf.readInt();
            boolean sync = buf.readBoolean();
            server.execute(() -> {
                class_2586 blockEntity = player.field_6002.method_8321(pos);
                if (blockEntity instanceof ChunkLoaderBlockEntity) {
                    ((ChunkLoaderBlockEntity)blockEntity).handleGuiInputFromClient(buttonID, (class_1657)(sync ? player : null));
                }
            });
        });
        NetworkManager.registerServerBoundHandler((class_2960)EXPERIENCE, (server, player, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            server.execute(() -> {
                class_2586 blockEntity = player.field_6002.method_8321(pos);
                if (blockEntity instanceof IronFurnaceBlockEntity) {
                    ((IronFurnaceBlockEntity)blockEntity).handleGuiInputFromClient((class_1657)player);
                }
            });
        });
        NetworkManager.registerServerBoundHandler((class_2960)DETECTOR_RADIUS, (server, player, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            int buttonAmount = buf.readInt();
            server.execute(() -> {
                class_2586 blockEntity = player.field_6002.method_8321(pos);
                if (blockEntity instanceof PlayerDetectorBlockEntity) {
                    ((PlayerDetectorBlockEntity)blockEntity).handleGuiInputFromClient(buttonAmount);
                }
            });
        });
    }

    public static IdentifiedPacket createPacketAesu(int buttonID, boolean shift, boolean ctrl, AdjustableSUBlockEntity blockEntity) {
        return NetworkManager.createServerBoundPacket((class_2960)AESU, buf -> {
            buf.method_10807(blockEntity.method_11016());
            buf.writeInt(buttonID);
            buf.writeBoolean(shift);
            buf.writeBoolean(ctrl);
        });
    }

    public static IdentifiedPacket createPacketAutoCraftingTableLock(AutoCraftingTableBlockEntity machine, boolean locked) {
        return NetworkManager.createServerBoundPacket((class_2960)AUTO_CRAFTING_LOCK, buf -> {
            buf.method_10807(machine.method_11016());
            buf.writeBoolean(locked);
        });
    }

    public static IdentifiedPacket createPacketFusionControlSize(int sizeDelta, class_2338 pos) {
        return NetworkManager.createServerBoundPacket((class_2960)FUSION_CONTROL_SIZE, buf -> {
            buf.writeInt(sizeDelta);
            buf.method_10807(pos);
        });
    }

    public static IdentifiedPacket createPacketRollingMachineLock(RollingMachineBlockEntity machine, boolean locked) {
        return NetworkManager.createServerBoundPacket((class_2960)ROLLING_MACHINE_LOCK, buf -> {
            buf.method_10807(machine.method_11016());
            buf.writeBoolean(locked);
        });
    }

    public static IdentifiedPacket createPacketStorageUnitLock(StorageUnitBaseBlockEntity machine, boolean locked) {
        return NetworkManager.createServerBoundPacket((class_2960)STORAGE_UNIT_LOCK, buf -> {
            buf.method_10807(machine.method_11016());
            buf.writeBoolean(locked);
        });
    }

    public static IdentifiedPacket createRefundPacket() {
        return NetworkManager.createServerBoundPacket((class_2960)REFUND, extendedPacketBuffer -> {});
    }

    public static IdentifiedPacket createPacketChunkloader(int buttonID, ChunkLoaderBlockEntity blockEntity, boolean sync) {
        return NetworkManager.createServerBoundPacket((class_2960)CHUNKLOADER, buf -> {
            buf.method_10807(blockEntity.method_11016());
            buf.writeInt(buttonID);
            buf.writeBoolean(sync);
        });
    }

    public static IdentifiedPacket createPacketExperience(IronFurnaceBlockEntity blockEntity) {
        return NetworkManager.createServerBoundPacket((class_2960)EXPERIENCE, extendedPacketBuffer -> extendedPacketBuffer.method_10807(blockEntity.method_11016()));
    }

    public static IdentifiedPacket createPacketPlayerDetector(int buttonAmount, PlayerDetectorBlockEntity blockEntity) {
        return NetworkManager.createServerBoundPacket((class_2960)DETECTOR_RADIUS, buf -> {
            buf.method_10807(blockEntity.method_11016());
            buf.writeInt(buttonAmount);
        });
    }
}

