/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.tool.industrial;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import reborncore.common.misc.MultiBlockBreakingTool;
import reborncore.common.powerSystem.RcEnergyTier;
import reborncore.common.util.ChatUtils;
import reborncore.common.util.ItemUtils;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRToolMaterials;
import techreborn.items.tool.JackhammerItem;
import techreborn.utils.MessageIDs;
import techreborn.utils.ToolsUtil;

public class IndustrialJackhammerItem
extends JackhammerItem
implements MultiBlockBreakingTool {
    public IndustrialJackhammerItem() {
        super(TRToolMaterials.INDUSTRIAL_JACKHAMMER, TechRebornConfig.industrialJackhammerCharge, RcEnergyTier.INSANE, TechRebornConfig.industrialJackhammerCost);
    }

    private void switchAOE(class_1799 stack, int cost, boolean isClient, int messageId) {
        ItemUtils.checkActive((class_1799)stack, (int)cost, (boolean)isClient, (int)messageId);
        if (!ItemUtils.isActive((class_1799)stack)) {
            ItemUtils.switchActive((class_1799)stack, (int)cost, (boolean)isClient, (int)messageId);
            stack.method_7948().method_10556("AOE5", false);
            if (isClient) {
                ChatUtils.sendNoSpamMessages((int)messageId, (class_2561)new class_2588("techreborn.message.setTo").method_27692(class_124.field_1080).method_27693(" ").method_10852((class_2561)new class_2585("3*3").method_27692(class_124.field_1065)));
            }
        } else if (this.isAOE5(stack)) {
            ItemUtils.switchActive((class_1799)stack, (int)cost, (boolean)isClient, (int)messageId);
            stack.method_7948().method_10556("AOE5", false);
        } else {
            stack.method_7948().method_10556("AOE5", true);
            if (isClient) {
                ChatUtils.sendNoSpamMessages((int)messageId, (class_2561)new class_2588("techreborn.message.setTo").method_27692(class_124.field_1080).method_27693(" ").method_10852((class_2561)new class_2585("5*5").method_27692(class_124.field_1065)));
            }
        }
    }

    private boolean shouldBreak(class_1937 worldIn, class_2338 originalPos, class_2338 pos, class_1799 stack) {
        if (originalPos.equals((Object)pos)) {
            return false;
        }
        class_2680 blockState = worldIn.method_8320(pos);
        if (ToolsUtil.JackHammerSkippedBlocks(blockState)) {
            return false;
        }
        return stack.method_7909().method_7856(blockState);
    }

    private boolean isAOE5(class_1799 stack) {
        return !stack.method_7960() && stack.method_7948().method_10577("AOE5");
    }

    @Override
    public boolean method_7879(class_1799 stack, class_1937 worldIn, class_2680 stateIn, class_2338 pos, class_1309 entityLiving) {
        if (!ItemUtils.isActive((class_1799)stack) || !stack.method_7909().method_7856(stateIn)) {
            return super.method_7879(stack, worldIn, stateIn, pos, entityLiving);
        }
        int radius = this.isAOE5(stack) ? 2 : 1;
        for (class_2338 additionalPos : ToolsUtil.getAOEMiningBlocks(worldIn, pos, entityLiving, radius)) {
            if (!this.shouldBreak(worldIn, pos, additionalPos, stack)) continue;
            ToolsUtil.breakBlock(stack, worldIn, additionalPos, entityLiving, this.cost);
        }
        return super.method_7879(stack, worldIn, stateIn, pos, entityLiving);
    }

    @Override
    public float method_7865(class_1799 stack, class_2680 state) {
        float speed = super.method_7865(stack, state);
        if (speed > 0.5f) {
            return this.field_7940 * 4.0f;
        }
        return speed;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (player.method_5715()) {
            this.switchAOE(stack, this.cost, world.field_9236, MessageIDs.poweredToolID);
            return new class_1271(class_1269.field_5812, (Object)stack);
        }
        return new class_1271(class_1269.field_5811, (Object)stack);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        ItemUtils.checkActive((class_1799)stack, (int)this.cost, (boolean)entity.field_6002.field_9236, (int)MessageIDs.poweredToolID);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        ItemUtils.buildActiveTooltip((class_1799)stack, tooltip);
        if (ItemUtils.isActive((class_1799)stack)) {
            if (this.isAOE5(stack)) {
                tooltip.add((class_2561)new class_2585("5*5").method_27692(class_124.field_1061));
            } else {
                tooltip.add((class_2561)new class_2585("3*3").method_27692(class_124.field_1061));
            }
        }
    }

    public Set<class_2338> getBlocksToBreak(class_1799 stack, class_1937 worldIn, class_2338 pos, @Nullable class_1309 entityLiving) {
        if (!stack.method_7909().method_7856(worldIn.method_8320(pos))) {
            return Collections.emptySet();
        }
        int radius = this.isAOE5(stack) ? 2 : 1;
        return ToolsUtil.getAOEMiningBlocks(worldIn, pos, entityLiving, radius, false).stream().filter(blockPos -> this.shouldBreak(worldIn, pos, (class_2338)blockPos, stack)).collect(Collectors.toSet());
    }
}

