/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.storage.fluid;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IListInfoProvider;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.client.screen.BuiltScreenHandlerProvider;
import reborncore.client.screen.builder.BuiltScreenHandler;
import reborncore.client.screen.builder.ScreenHandlerBuilder;
import reborncore.client.screen.builder.Syncable;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.fluid.FluidUtils;
import reborncore.common.fluid.FluidValue;
import reborncore.common.fluid.container.FluidInstance;
import reborncore.common.util.RebornInventory;
import reborncore.common.util.Tank;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class TankUnitBaseBlockEntity
extends MachineBaseBlockEntity
implements InventoryProvider,
IToolDrop,
IListInfoProvider,
BuiltScreenHandlerProvider {
    protected Tank tank;
    private long serverMaxCapacity = -1L;
    protected RebornInventory<TankUnitBaseBlockEntity> inventory = new RebornInventory(2, "TankInventory", 64, (MachineBaseBlockEntity)this);
    private TRContent.TankUnit type;

    public TankUnitBaseBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.TANK_UNIT, pos, state);
    }

    public TankUnitBaseBlockEntity(class_2338 pos, class_2680 state, TRContent.TankUnit type) {
        super(TRBlockEntities.TANK_UNIT, pos, state);
        this.configureEntity(type);
    }

    private void configureEntity(TRContent.TankUnit type) {
        this.type = type;
        this.tank = new Tank("TankStorage", this.serverMaxCapacity == -1L ? type.capacity : FluidValue.fromRaw((long)this.serverMaxCapacity), (MachineBaseBlockEntity)this);
    }

    public class_1799 getDropWithNBT() {
        class_1799 dropStack = new class_1799((class_1935)this.getBlockType(), 1);
        class_2487 blockEntity = new class_2487();
        this.method_11007(blockEntity);
        dropStack.method_7980(new class_2487());
        dropStack.method_7948().method_10566("blockEntity", (class_2520)blockEntity);
        return dropStack;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        if (world == null || world.method_8608()) {
            return;
        }
        if (FluidUtils.drainContainers((Tank)this.tank, this.inventory, (int)0, (int)1) || FluidUtils.fillContainers((Tank)this.tank, this.inventory, (int)0, (int)1)) {
            if (this.type == TRContent.TankUnit.CREATIVE && !this.tank.isEmpty() && !this.tank.isFull()) {
                this.tank.setFluidAmount(this.tank.getFluidValueCapacity());
            }
            this.syncWithAll();
        }
        if (this.type == TRContent.TankUnit.CREATIVE && this.tank.isFull()) {
            FluidUtils.drainContainers((Tank)this.tank, this.inventory, (int)0, (int)1, (boolean)true);
        }
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public void method_11014(class_2487 tagCompound) {
        super.method_11014(tagCompound);
        if (tagCompound.method_10545("unitType")) {
            this.type = TRContent.TankUnit.valueOf(tagCompound.method_10558("unitType"));
            this.configureEntity(this.type);
            this.tank.read(tagCompound);
        }
    }

    public void method_11007(class_2487 tagCompound) {
        super.method_11007(tagCompound);
        tagCompound.method_10582("unitType", this.type.name());
        this.tank.write(tagCompound);
    }

    public FluidValue fluidTransferAmount() {
        return this.type.capacity.fraction(1200L);
    }

    public RebornInventory<TankUnitBaseBlockEntity> getInventory() {
        return this.inventory;
    }

    public class_1799 getToolDrop(class_1657 playerEntity) {
        return this.getDropWithNBT();
    }

    public void addInfo(List<class_2561> info, boolean isReal, boolean hasData) {
        if (isReal || hasData) {
            if (!this.tank.getFluidInstance().isEmpty()) {
                info.add((class_2561)new class_2585(String.valueOf(this.tank.getFluidAmount())).method_10852((class_2561)new class_2588("techreborn.tooltip.unit.divider")).method_27693(WordUtils.capitalize((String)FluidUtils.getFluidName((class_3611)this.tank.getFluid()))));
            } else {
                info.add((class_2561)new class_2588("techreborn.tooltip.unit.empty"));
            }
        }
        info.add((class_2561)new class_2588("techreborn.tooltip.unit.capacity").method_27692(class_124.field_1080).method_10852((class_2561)new class_2585(String.valueOf(this.tank.getFluidValueCapacity())).method_27692(class_124.field_1065)));
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("tank").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).fluidSlot(0, 100, 53).outputSlot(1, 140, 53).sync((Syncable)this.tank).sync(this::getMaxCapacity, this::setMaxCapacity).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    public long getMaxCapacity() {
        return this.tank.getFluidValueCapacity().getRawValue();
    }

    public void setMaxCapacity(long maxCapacity) {
        FluidInstance instance = this.tank.getFluidInstance();
        this.tank = new Tank("TankStorage", FluidValue.fromRaw((long)maxCapacity), (MachineBaseBlockEntity)this);
        this.tank.setFluidInstance(instance);
        this.serverMaxCapacity = maxCapacity;
    }

    @Nullable
    public Tank getTank() {
        return this.tank;
    }
}

