/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import org.jetbrains.annotations.Nullable;

public interface IVariantConversion<V extends TransferVariant<?>> {
    public static final IVariantConversion<ItemVariant> ITEM = new Item();
    public static final IVariantConversion<FluidVariant> FLUID = new Fluid();

    public AEKeyType getKeyType();

    public V getVariant(@javax.annotation.Nullable AEKey var1);

    @javax.annotation.Nullable
    public AEKey getKey(V var1);

    default public boolean variantMatches(AEKey key, V variant) {
        return this.getVariant(key).equals(variant);
    }

    public long getBaseSlotSize(V var1);

    public static class Item
    implements IVariantConversion<ItemVariant> {
        @Override
        public AEKeyType getKeyType() {
            return AEKeyType.items();
        }

        @Override
        public ItemVariant getVariant(AEKey key) {
            ItemVariant itemVariant;
            if (key instanceof AEItemKey) {
                AEItemKey itemKey = (AEItemKey)key;
                itemVariant = itemKey.toVariant();
            } else {
                itemVariant = ItemVariant.blank();
            }
            return itemVariant;
        }

        @Nullable
        public AEItemKey getKey(ItemVariant variant) {
            return AEItemKey.of(variant);
        }

        @Override
        public long getBaseSlotSize(ItemVariant variant) {
            return Math.min(64, variant.getItem().method_7882());
        }
    }

    public static class Fluid
    implements IVariantConversion<FluidVariant> {
        @Override
        public AEKeyType getKeyType() {
            return AEKeyType.fluids();
        }

        @Override
        public FluidVariant getVariant(AEKey key) {
            FluidVariant fluidVariant;
            if (key instanceof AEFluidKey) {
                AEFluidKey fluidKey = (AEFluidKey)key;
                fluidVariant = fluidKey.toVariant();
            } else {
                fluidVariant = FluidVariant.blank();
            }
            return fluidVariant;
        }

        @Override
        public AEKey getKey(FluidVariant variant) {
            return AEFluidKey.of(variant);
        }

        @Override
        public long getBaseSlotSize(FluidVariant variant) {
            return 324000L;
        }
    }
}

