/*
 * Decompiled with CFR 0.152.
 */
package appeng.spatial;

import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.definitions.AEBlocks;
import appeng.spatial.SpatialStorageDimensionIds;
import appeng.spatial.SpatialStoragePlot;
import appeng.spatial.SpatialStorageWorldData;
import appeng.spatial.TransitionInfo;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public final class SpatialStoragePlotManager {
    public static final SpatialStoragePlotManager INSTANCE = new SpatialStoragePlotManager();

    private SpatialStoragePlotManager() {
    }

    public class_3218 getLevel() {
        MinecraftServer server = AppEng.instance().getCurrentServer();
        if (server == null) {
            throw new IllegalStateException("No server is currently running.");
        }
        class_3218 level = server.method_3847(SpatialStorageDimensionIds.WORLD_ID);
        if (level == null) {
            throw new IllegalStateException("The storage cell level is missing.");
        }
        return level;
    }

    private SpatialStorageWorldData getWorldData() {
        return (SpatialStorageWorldData)this.getLevel().method_14178().method_17981().method_17924(SpatialStorageWorldData::load, SpatialStorageWorldData::new, "ae2_spatial_storage");
    }

    @Nullable
    public SpatialStoragePlot getPlot(int plotId) {
        if (plotId == -1) {
            return null;
        }
        return this.getWorldData().getPlotById(plotId);
    }

    public SpatialStoragePlot allocatePlot(class_2338 size, int ownerId) {
        SpatialStoragePlot plot = this.getWorldData().allocatePlot(size, ownerId);
        AELog.info("Allocating storage cell plot %d with size %s for %d", plot.getId(), size, ownerId);
        return plot;
    }

    public void setLastTransition(int plotId, TransitionInfo info) {
        this.getWorldData().setLastTransition(plotId, info);
    }

    public List<SpatialStoragePlot> getPlots() {
        return this.getWorldData().getPlots();
    }

    public void freePlot(int plotId, boolean resetBlocks) {
        SpatialStoragePlot plot = this.getPlot(plotId);
        if (plot == null) {
            return;
        }
        if (resetBlocks) {
            class_2338 from = plot.getOrigin();
            class_2338 to = from.method_10081((class_2382)plot.getSize()).method_10069(-1, -1, -1);
            AELog.info("Clearing spatial storage plot %s (%s -> %s)", plotId, from, to);
            class_3218 level = this.getLevel();
            class_2680 matrixFrame = AEBlocks.MATRIX_FRAME.block().method_9564();
            for (class_2338 blockPos : class_2338.method_10097((class_2338)from, (class_2338)to)) {
                level.method_8501(blockPos, matrixFrame);
            }
        }
        this.getWorldData().removePlot(plotId);
    }
}

