/*
 * Decompiled with CFR 0.152.
 */
package appeng.siteexport;

import appeng.recipes.handlers.InscriberProcessType;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.siteexport.ModVersion;
import appeng.siteexport.model.CraftingRecipeJson;
import appeng.siteexport.model.InscriberRecipeJson;
import appeng.siteexport.model.ItemInfoJson;
import appeng.siteexport.model.P2PTypeInfo;
import appeng.siteexport.model.SiteExportJson;
import appeng.siteexport.model.SmeltingRecipeJson;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1869;
import net.minecraft.class_1874;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3797;
import net.minecraft.class_3955;
import org.jetbrains.annotations.NotNull;

public class SiteExportWriter {
    private final SiteExportJson siteExport = new SiteExportJson();

    public SiteExportWriter() {
        this.siteExport.modVersion = ModVersion.get();
        this.siteExport.generated = Instant.now().toString();
        this.siteExport.gameVersion = class_3797.method_16672().getName();
    }

    public void addItem(String id, class_1799 stack, String iconPath) {
        ItemInfoJson itemInfo = new ItemInfoJson();
        itemInfo.id = id;
        itemInfo.icon = iconPath;
        itemInfo.displayName = stack.method_7964().getString();
        itemInfo.rarity = stack.method_7932().name().toLowerCase(Locale.ROOT);
        this.siteExport.items.put(itemInfo.id, itemInfo);
    }

    public void addRecipe(class_3955 recipe) {
        CraftingRecipeJson json = new CraftingRecipeJson();
        json.id = recipe.method_8114().toString();
        json.shapeless = true;
        if (recipe instanceof class_1869) {
            class_1869 shapedRecipe = (class_1869)recipe;
            json.shapeless = false;
            json.width = shapedRecipe.method_8150();
            json.height = shapedRecipe.method_8158();
        }
        json.resultItem = class_2378.field_11142.method_10221((Object)recipe.method_8110().method_7909()).toString();
        json.resultCount = recipe.method_8110().method_7947();
        class_2371 ingredients = recipe.method_8117();
        json.ingredients = new String[ingredients.size()][];
        for (int i = 0; i < json.ingredients.length; ++i) {
            json.ingredients[i] = this.convertIngredient((class_1856)ingredients.get(i));
        }
        this.siteExport.craftingRecipes.put(json.id, json);
    }

    public void addRecipe(InscriberRecipe recipe) {
        InscriberRecipeJson json = new InscriberRecipeJson();
        json.id = recipe.method_8114().toString();
        json.top = this.convertIngredient(recipe.getTopOptional());
        json.middle = this.convertIngredient(recipe.getMiddleInput());
        json.bottom = this.convertIngredient(recipe.getBottomOptional());
        json.resultItem = class_2378.field_11142.method_10221((Object)recipe.method_8110().method_7909()).toString();
        json.resultCount = recipe.method_8110().method_7947();
        json.consumesTopAndBottom = recipe.getProcessType() == InscriberProcessType.PRESS;
        this.siteExport.inscriberRecipes.put(json.id, json);
    }

    public void addRecipe(class_1874 recipe) {
        SmeltingRecipeJson json = new SmeltingRecipeJson();
        json.id = recipe.method_8114().toString();
        json.resultItem = class_2378.field_11142.method_10221((Object)recipe.method_8110().method_7909()).toString();
        class_2371 ingredients = recipe.method_8117();
        json.ingredient = this.convertIngredient((class_1856)ingredients.get(0));
        this.siteExport.smeltingRecipes.put(json.id, json);
    }

    @NotNull
    private String[] convertIngredient(class_1856 ingredient) {
        return (String[])Arrays.stream(ingredient.method_8105()).map(is -> class_2378.field_11142.method_10221((Object)is.method_7909())).filter(k -> k.method_12836().equals("ae2") || k.method_12836().equals("minecraft")).map(class_2960::toString).toArray(String[]::new);
    }

    public void write(Path file) throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            gson.toJson((Object)this.siteExport, (Appendable)writer);
        }
    }

    public void addP2PType(P2PTypeInfo typeInfo) {
        this.siteExport.p2pTunnelTypes.add(typeInfo);
    }

    public void addColoredVersion(class_1792 baseItem, class_1767 color, class_1792 coloredItem) {
        String baseItemId = class_2378.field_11142.method_10221((Object)baseItem).toString();
        String coloredItemId = class_2378.field_11142.method_10221((Object)coloredItem).toString();
        Map coloredVersions = this.siteExport.coloredVersions.computeIfAbsent(baseItemId, key -> new HashMap());
        coloredVersions.put(color, coloredItemId);
    }
}

