/*
 * Decompiled with CFR 0.152.
 */
package appeng.siteexport;

import appeng.api.parts.IPartItem;
import appeng.api.util.AEColor;
import appeng.block.crafting.CraftingStorageBlock;
import appeng.block.misc.QuartzFixtureBlock;
import appeng.block.misc.VibrationChamberBlock;
import appeng.core.AppEng;
import appeng.core.definitions.AEBlockEntities;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.core.definitions.BlockDefinition;
import appeng.items.parts.ColoredPartItem;
import appeng.parts.networking.CoveredCablePart;
import appeng.server.testworld.Plot;
import appeng.server.testworld.PlotBuilder;
import appeng.server.testworld.TestPlots;
import appeng.siteexport.PlotScene;
import appeng.siteexport.Scene;
import appeng.siteexport.SceneRenderSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1160;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

final class SiteExportScenes {
    private SiteExportScenes() {
    }

    public static List<Scene> createScenes() {
        ArrayList<Scene> scenes = new ArrayList<Scene>();
        Function<class_2680, class_2680> craftingStorageState = s -> (class_2680)s.method_11657((class_2769)CraftingStorageBlock.FORMED, (Comparable)Boolean.valueOf(true));
        Collections.addAll(scenes, SiteExportScenes.singleBlock(AEBlocks.CONTROLLER), SiteExportScenes.singleBlock(AEBlocks.CRAFTING_STORAGE_1K, craftingStorageState), SiteExportScenes.singleBlock(AEBlocks.CRAFTING_STORAGE_4K, craftingStorageState), SiteExportScenes.singleBlock(AEBlocks.CRAFTING_STORAGE_16K, craftingStorageState), SiteExportScenes.singleBlock(AEBlocks.CRAFTING_STORAGE_64K, craftingStorageState), SiteExportScenes.singleBlock(AEBlocks.CELL_WORKBENCH), SiteExportScenes.singleBlock(AEBlocks.QUARTZ_ORE), SiteExportScenes.singleBlock(AEBlocks.QUARTZ_BLOCK), SiteExportScenes.singleBlock(AEBlocks.QUARTZ_FIXTURE, b -> (class_2680)b.method_11657((class_2769)QuartzFixtureBlock.FACING, (Comparable)class_2350.field_11036)), SiteExportScenes.singleBlock(AEBlocks.QUARTZ_FIXTURE, b -> (class_2680)b.method_11657((class_2769)QuartzFixtureBlock.FACING, (Comparable)class_2350.field_11034)), SiteExportScenes.singleBlock(AEBlocks.CHISELED_QUARTZ_BLOCK), SiteExportScenes.singleBlock(AEBlocks.FLUIX_BLOCK), SiteExportScenes.createInscriberScene(), SiteExportScenes.singleBlock(AEBlocks.INTERFACE), SiteExportScenes.singleBlock(AEBlocks.IO_PORT), SiteExportScenes.singleBlock(AEBlocks.CONDENSER), SiteExportScenes.singleBlock(AEBlocks.CHEST), SiteExportScenes.singleBlock(AEBlocks.DRIVE), SiteExportScenes.singleBlock(AEBlocks.QUANTUM_LINK), SiteExportScenes.singleBlock(AEBlocks.QUANTUM_RING), SiteExportScenes.singleBlock(AEBlocks.QUARTZ_GLASS), SiteExportScenes.singleBlock(AEBlocks.SECURITY_STATION), SiteExportScenes.singleBlock(AEBlocks.SKY_STONE_BLOCK), SiteExportScenes.singleBlock(AEBlocks.SMOOTH_SKY_STONE_CHEST), SiteExportScenes.singleBlock(AEBlocks.SKY_STONE_BRICK), SiteExportScenes.singleBlock(AEBlocks.SKY_STONE_SMALL_BRICK), SiteExportScenes.singleBlock(AEBlocks.SPATIAL_IO_PORT), SiteExportScenes.singleBlock(AEBlocks.VIBRATION_CHAMBER, b -> (class_2680)b.method_11657((class_2769)VibrationChamberBlock.ACTIVE, (Comparable)Boolean.valueOf(true))));
        scenes.add(SiteExportScenes.createQnbScene());
        scenes.add(SiteExportScenes.createColoredCablesScene());
        scenes.add(SiteExportScenes.plotScene("inscriber_hoppers", TestPlots::inscriber));
        return scenes;
    }

    private static Scene createInscriberScene() {
        Scene scene = SiteExportScenes.singleBlock(AEBlocks.INSCRIBER);
        scene.postSetup = serverLevel -> serverLevel.method_35230(class_2338.field_10980, AEBlockEntities.INSCRIBER).ifPresent(be -> be.getInternalInventory().setItemDirect(1, AEItems.LOGIC_PROCESSOR_PRESS.stack()));
        scene.waitTicks = 2;
        return scene;
    }

    private static Scene createColoredCablesScene() {
        Scene coloredCables = new Scene(SiteExportScenes.blockArea(), "large/colored_cables.png");
        for (int x = 0; x < 4; ++x) {
            ColoredPartItem<CoveredCablePart> item = AEParts.COVERED_CABLE.item(switch (x) {
                default -> AEColor.PURPLE;
                case 1 -> AEColor.BLACK;
                case 2 -> AEColor.ORANGE;
                case 3 -> AEColor.CYAN;
            });
            for (int z = 0; z < 3; ++z) {
                coloredCables.putCable(new class_2338(x, 0, z), item);
            }
            coloredCables.putCable(new class_2338(x, 0, 0), (IPartItem)AEParts.COVERED_CABLE.item(AEColor.TRANSPARENT));
        }
        coloredCables.waitTicks = 3;
        coloredCables.centerOn = new class_1160(2.5f, 0.0f, 1.5f);
        return coloredCables;
    }

    private static Scene createQnbScene() {
        Scene qnbScenes = new Scene(SiteExportScenes.blockArea(), "large/qnb.png");
        qnbScenes.blocks.put(new class_2338(-1, 0, 0), AEBlocks.QUANTUM_RING.block().method_9564());
        qnbScenes.blocks.put(new class_2338(0, 0, 0), AEBlocks.QUANTUM_RING.block().method_9564());
        qnbScenes.blocks.put(new class_2338(1, 0, 0), AEBlocks.QUANTUM_RING.block().method_9564());
        qnbScenes.blocks.put(new class_2338(-1, 1, 0), AEBlocks.QUANTUM_RING.block().method_9564());
        qnbScenes.blocks.put(new class_2338(0, 1, 0), AEBlocks.QUANTUM_LINK.block().method_9564());
        qnbScenes.blocks.put(new class_2338(1, 1, 0), AEBlocks.QUANTUM_RING.block().method_9564());
        qnbScenes.blocks.put(new class_2338(-1, 2, 0), AEBlocks.QUANTUM_RING.block().method_9564());
        qnbScenes.blocks.put(new class_2338(0, 2, 0), AEBlocks.QUANTUM_RING.block().method_9564());
        qnbScenes.blocks.put(new class_2338(1, 2, 0), AEBlocks.QUANTUM_RING.block().method_9564());
        qnbScenes.centerOn = new class_1160(0.5f, 1.5f, 0.5f);
        return qnbScenes;
    }

    private static Scene singleBlock(BlockDefinition<?> block) {
        return SiteExportScenes.singleBlock(block.id().method_12832(), block.block(), Function.identity());
    }

    private static Scene singleBlock(BlockDefinition<?> block, Function<class_2680, class_2680> stateCustomizer) {
        return SiteExportScenes.singleBlock(block.id().method_12832(), block.block(), stateCustomizer);
    }

    private static Scene singleBlock(String filename, class_2248 block, Function<class_2680, class_2680> stateCustomizer) {
        String fullPath = "large/" + filename + ".png";
        Scene scene = new Scene(SiteExportScenes.bigBlockSettings(), fullPath);
        class_2680 state = block.method_9564();
        state = stateCustomizer.apply(state);
        scene.blocks.put(class_2338.field_10980, state);
        return scene;
    }

    private static Scene plotScene(String filename, Consumer<PlotBuilder> plotFactory) {
        Plot plot = new Plot(AppEng.makeId(filename));
        plotFactory.accept(plot);
        return SiteExportScenes.plotScene(filename, plot);
    }

    private static Scene plotScene(String filename, Plot plot) {
        String fullPath = "large/" + filename + ".png";
        SceneRenderSettings renderSettings = SiteExportScenes.blockArea();
        PlotScene scene = new PlotScene(renderSettings, fullPath, plot);
        scene.waitTicks = 22;
        return scene;
    }

    private static SceneRenderSettings bigBlockSettings() {
        SceneRenderSettings settings = new SceneRenderSettings();
        settings.ortographic = false;
        settings.width = 512;
        settings.height = 512;
        return settings;
    }

    private static SceneRenderSettings blockArea() {
        SceneRenderSettings settings = new SceneRenderSettings();
        settings.ortographic = true;
        settings.width = 512;
        settings.height = 512;
        return settings;
    }
}

