/*
 * Decompiled with CFR 0.152.
 */
package appeng.siteexport;

import appeng.siteexport.OffScreenRenderer;
import appeng.siteexport.Scene;
import appeng.siteexport.SceneRenderSettings;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Random;
import net.fabricmc.fabric.api.client.command.v1.FabricClientCommandSource;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1642;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_638;
import net.minecraft.class_776;
import net.minecraft.class_824;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SceneExportJob {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Path assetFolder;
    private final List<Scene> scenes;
    private final FabricClientCommandSource source;
    private final class_310 client;
    private final class_638 clientLevel;
    private final class_3218 serverLevel;
    private int currentScene = -1;
    private int waitTicks = 0;
    private SceneRenderingState state;

    public SceneExportJob(List<Scene> scenes, FabricClientCommandSource source, Path assetFolder) {
        this.scenes = scenes;
        this.source = source;
        this.assetFolder = assetFolder;
        this.client = class_310.method_1551();
        this.clientLevel = this.client.field_1687;
        this.serverLevel = this.client.method_1576().method_3847(this.clientLevel.method_27983());
    }

    public void tick() {
        if (this.state == null) {
            ++this.currentScene;
            this.state = SceneRenderingState.BEFORE_SERVER_SETUP;
        }
        if (this.isAtEnd()) {
            return;
        }
        if (this.state == SceneRenderingState.BEFORE_SERVER_SETUP) {
            Scene scene = this.scenes.get(this.currentScene);
            scene.clearArea((class_1937)this.serverLevel);
            scene.setUp(this.serverLevel);
            this.state = SceneRenderingState.AFTER_SERVER_SETUP;
            this.waitTicks = scene.waitTicks;
        } else if (this.state == SceneRenderingState.AFTER_SERVER_SETUP) {
            if (--this.waitTicks > 0) {
                return;
            }
            this.state = SceneRenderingState.RENDER;
        }
    }

    public void render() throws Exception {
        if (this.state == SceneRenderingState.RENDER) {
            Scene scene = this.scenes.get(this.currentScene);
            Path sceneOutput = this.assetFolder.resolve(scene.filename);
            Files.createDirectories(sceneOutput.getParent(), new FileAttribute[0]);
            this.renderScene(sceneOutput, scene);
            ++this.currentScene;
            this.state = SceneRenderingState.BEFORE_SERVER_SETUP;
        }
    }

    public boolean isAtEnd() {
        return this.currentScene >= this.scenes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderScene(Path outputPath, Scene scene) throws Exception {
        class_776 blockRenderer = this.client.method_1541();
        Random rand = new Random(0L);
        scene.clearLighting(this.clientLevel);
        class_824 beRenderer = this.client.method_31975();
        SceneRenderSettings settings = scene.settings;
        try (OffScreenRenderer renderer = new OffScreenRenderer(settings.width, settings.height);){
            if (settings.ortographic) {
                renderer.setupOrtographicRendering();
            } else {
                renderer.setupPerspectiveRendering(3.3f, 65.0f, new class_1160(2.0f, 2.5f, -3.0f), new class_1160(0.5f, 0.5f, 0.5f));
            }
            Random random = new Random(12345L);
            class_2338 min = scene.getMin();
            if (!settings.ortographic) {
                class_1642 cameraEntity = new class_1642((class_1937)this.clientLevel);
                cameraEntity.method_5814((double)min.method_10263(), (double)min.method_10264(), (double)min.method_10260());
                beRenderer.field_4344.method_19321((class_1922)this.clientLevel, (class_1297)cameraEntity, false, false, 0.0f);
            }
            try {
                renderer.captureAsPng(() -> {
                    class_4587 worldMat = new class_4587();
                    worldMat.method_22907(class_1158.method_35821((float)((float)Math.toRadians(scene.rotationY)), (float)0.0f, (float)0.0f));
                    worldMat.method_22904((double)(-scene.centerOn.method_4943()), (double)(-scene.centerOn.method_4945()), (double)(-scene.centerOn.method_4947()));
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    class_4597.class_4598 buffers = this.client.method_22940().method_23000();
                    for (class_1921 rt : class_1921.method_22720()) {
                        class_4588 buffer = buffers.getBuffer(rt);
                        for (class_2338 pos : class_2338.method_10097((class_2338)scene.getMin(), (class_2338)scene.getMax())) {
                            class_2680 state = this.clientLevel.method_8320(pos);
                            if (class_4696.method_23679((class_2680)state) != rt) continue;
                            worldMat.method_22903();
                            worldMat.method_22904((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                            state.method_26204().method_9496(state, (class_1937)this.clientLevel, pos, random);
                            if (state.method_26217() == class_2464.field_11458) {
                                blockRenderer.method_3355(state, pos, (class_1920)this.clientLevel, worldMat, buffer, false, rand);
                            }
                            worldMat.method_22909();
                        }
                        buffers.method_22993();
                    }
                    for (class_2338 pos : class_2338.method_10097((class_2338)scene.getMin(), (class_2338)scene.getMax())) {
                        class_2586 be;
                        class_2680 state = this.clientLevel.method_8320(pos);
                        worldMat.method_22903();
                        worldMat.method_22904((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                        if (state.method_26217() != class_2464.field_11455 && (be = this.clientLevel.method_8321(pos)) != null) {
                            RenderSystem.runAsFancy(() -> beRenderer.method_3555(be, 0.0f, worldMat, (class_4597)buffers));
                            buffers.method_22993();
                        }
                        worldMat.method_22909();
                    }
                }, outputPath);
            }
            finally {
                this.client.method_1504((class_1297)this.client.field_1724);
            }
        }
    }

    public void sendFeedback(class_2561 text) {
        this.source.sendFeedback(text);
    }

    public void sendError(class_2561 text) {
        this.source.sendError(text);
    }

    static enum SceneRenderingState {
        BEFORE_SERVER_SETUP,
        AFTER_SERVER_SETUP,
        RENDER;

    }
}

