/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.services.compass;

import appeng.core.AELog;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_3218;

final class CompassRegion
extends class_18 {
    private static final int CHUNKS_PER_REGION = 1024;
    private static final int BITMAP_LENGTH = 0x100000;
    private final Map<Integer, BitSet> sections = new HashMap<Integer, BitSet>();

    CompassRegion() {
    }

    private static String getRegionSaveName(int regionX, int regionZ) {
        return "ae2_compass_" + regionX + "_" + regionZ;
    }

    public static CompassRegion get(class_3218 level, class_1923 chunkPos) {
        Objects.requireNonNull(level, "level");
        Objects.requireNonNull(chunkPos, "chunkPos");
        int regionX = chunkPos.field_9181 / 1024;
        int regionZ = chunkPos.field_9180 / 1024;
        return (CompassRegion)level.method_17983().method_17924(CompassRegion::load, CompassRegion::new, CompassRegion.getRegionSaveName(regionX, regionZ));
    }

    public static CompassRegion load(class_2487 nbt) {
        CompassRegion result = new CompassRegion();
        for (String key : nbt.method_10541()) {
            if (key.startsWith("section")) {
                try {
                    int sectionIndex = Integer.parseInt(key.substring("section".length()));
                    result.sections.put(sectionIndex, BitSet.valueOf(nbt.method_10547(key)));
                }
                catch (NumberFormatException e) {
                    AELog.warn("Compass region contains invalid NBT tag %s", key);
                }
                continue;
            }
            AELog.warn("Compass region contains unknown NBT tag %s", key);
        }
        return result;
    }

    public class_2487 method_75(class_2487 compound) {
        for (Map.Entry<Integer, BitSet> entry : this.sections.entrySet()) {
            String key = "section" + entry.getKey();
            if (entry.getValue().isEmpty()) continue;
            compound.method_10570(key, entry.getValue().toByteArray());
        }
        return compound;
    }

    boolean hasSkyStone(int cx, int cz) {
        int bitmapIndex = CompassRegion.getBitmapIndex(cx, cz);
        for (BitSet bitmap : this.sections.values()) {
            if (!bitmap.get(bitmapIndex)) continue;
            return true;
        }
        return false;
    }

    boolean hasSkyStone(int cx, int cz, int sectionIndex) {
        int bitmapIndex = CompassRegion.getBitmapIndex(cx, cz);
        BitSet section = this.sections.get(sectionIndex);
        if (section != null) {
            return section.get(bitmapIndex);
        }
        return false;
    }

    void setHasSkyStone(int cx, int cz, int sectionIndex, boolean hasSkyStone) {
        int bitmapIndex = CompassRegion.getBitmapIndex(cx, cz);
        BitSet section = this.sections.get(sectionIndex);
        if (section == null) {
            if (hasSkyStone) {
                section = new BitSet(0x100000);
                section.set(bitmapIndex);
                this.sections.put(sectionIndex, section);
                this.method_80();
            }
        } else {
            if (section.get(bitmapIndex) != hasSkyStone) {
                this.method_80();
            }
            if (!hasSkyStone) {
                section.clear(bitmapIndex);
                if (section.isEmpty()) {
                    this.sections.remove(sectionIndex);
                }
                this.method_80();
            } else {
                section.set(bitmapIndex);
            }
        }
    }

    private static int getBitmapIndex(int cx, int cz) {
        return (cx &= 0x3FF) + (cz &= 0x3FF) * 1024;
    }
}

