/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.networking.energy.IEnergyService;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.items.parts.PartModels;
import appeng.me.helpers.PlayerSource;
import appeng.parts.PartModel;
import appeng.parts.reporting.AbstractMonitorPart;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import appeng.util.inv.PlayerInternalInventory;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2960;

public class ConversionMonitorPart
extends AbstractMonitorPart {
    @PartModels
    public static final class_2960 MODEL_OFF = new class_2960("ae2", "part/conversion_monitor_off");
    @PartModels
    public static final class_2960 MODEL_ON = new class_2960("ae2", "part/conversion_monitor_on");
    @PartModels
    public static final class_2960 MODEL_LOCKED_OFF = new class_2960("ae2", "part/conversion_monitor_locked_off");
    @PartModels
    public static final class_2960 MODEL_LOCKED_ON = new class_2960("ae2", "part/conversion_monitor_locked_on");
    public static final IPartModel MODELS_OFF = new PartModel(MODEL_BASE, MODEL_OFF, MODEL_STATUS_OFF);
    public static final IPartModel MODELS_ON = new PartModel(MODEL_BASE, MODEL_ON, MODEL_STATUS_ON);
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(MODEL_BASE, MODEL_ON, MODEL_STATUS_HAS_CHANNEL);
    public static final IPartModel MODELS_LOCKED_OFF = new PartModel(MODEL_BASE, MODEL_LOCKED_OFF, MODEL_STATUS_OFF);
    public static final IPartModel MODELS_LOCKED_ON = new PartModel(MODEL_BASE, MODEL_LOCKED_ON, MODEL_STATUS_ON);
    public static final IPartModel MODELS_LOCKED_HAS_CHANNEL = new PartModel(MODEL_BASE, MODEL_LOCKED_ON, MODEL_STATUS_HAS_CHANNEL);

    public ConversionMonitorPart(IPartItem<?> partItem) {
        super(partItem, true);
    }

    @Override
    public boolean onPartActivate(class_1657 player, class_1268 hand, class_243 pos) {
        if (this.isClientSide()) {
            return true;
        }
        if (!this.getMainNode().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions(this.getHost().getLocation(), player)) {
            return false;
        }
        class_1799 eq = player.method_5998(hand);
        if (this.isLocked()) {
            if (eq.method_7960()) {
                this.insertItem(player, hand, true);
            } else {
                if (InteractionUtil.canWrenchRotate(eq) && (this.getDisplayed() == null || !AEItemKey.matches(this.getDisplayed(), eq))) {
                    return super.onPartActivate(player, hand, pos);
                }
                this.insertItem(player, hand, false);
            }
        } else if (this.getDisplayed() != null && AEItemKey.matches(this.getDisplayed(), eq)) {
            this.insertItem(player, hand, false);
        } else {
            return super.onPartActivate(player, hand, pos);
        }
        return true;
    }

    @Override
    public boolean onClicked(class_1657 player, class_243 pos) {
        if (this.isClientSide()) {
            return true;
        }
        if (!this.getMainNode().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions(this.getHost().getLocation(), player)) {
            return false;
        }
        AEKey aEKey = this.getDisplayed();
        if (aEKey instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)aEKey;
            this.extractItem(player, itemKey.getItem().method_7882());
        }
        return true;
    }

    @Override
    public boolean onShiftClicked(class_1657 player, class_243 pos) {
        if (this.isClientSide()) {
            return true;
        }
        if (!this.getMainNode().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions(this.getHost().getLocation(), player)) {
            return false;
        }
        if (this.getDisplayed() != null) {
            this.extractItem(player, 1);
        }
        return true;
    }

    private void insertItem(class_1657 player, class_1268 hand, boolean allItems) {
        this.getMainNode().ifPresent(grid -> {
            IEnergyService energy = grid.getEnergyService();
            MEStorage cell = grid.getStorageService().getInventory();
            if (allItems) {
                AEKey patt5374$temp = this.getDisplayed();
                if (patt5374$temp instanceof AEItemKey) {
                    AEItemKey itemKey = (AEItemKey)patt5374$temp;
                    PlayerInternalInventory inv = new PlayerInternalInventory(player.method_31548());
                    for (int x = 0; x < inv.size(); ++x) {
                        class_1799 canExtract;
                        class_1799 targetStack = inv.getStackInSlot(x);
                        if (!itemKey.matches(targetStack) || (canExtract = inv.extractItem(x, targetStack.method_7947(), true)).method_7960()) continue;
                        long inserted = StorageHelper.poweredInsert(energy, cell, itemKey, canExtract.method_7947(), new PlayerSource(player, this));
                        inv.extractItem(x, (int)inserted, false);
                    }
                }
            } else {
                class_1799 input = player.method_5998(hand);
                if (!input.method_7960()) {
                    long inserted = StorageHelper.poweredInsert(energy, cell, AEItemKey.of(input), input.method_7947(), new PlayerSource(player, this));
                    input.method_7934((int)inserted);
                }
            }
        });
    }

    private void extractItem(class_1657 player, int count) {
        AEKey aEKey = this.getDisplayed();
        if (!(aEKey instanceof AEItemKey)) {
            return;
        }
        AEItemKey itemKey = (AEItemKey)aEKey;
        if (!this.getMainNode().isActive()) {
            return;
        }
        this.getMainNode().ifPresent(grid -> {
            MEStorage cell;
            IEnergyService energy = grid.getEnergyService();
            long retrieved = StorageHelper.poweredExtraction(energy, cell = grid.getStorageService().getInventory(), itemKey, count, new PlayerSource(player, this));
            if (retrieved != 0L) {
                class_1799 newItems = itemKey.toStack((int)retrieved);
                if (!player.method_31548().method_7394(newItems)) {
                    player.method_7328(newItems, false);
                }
                if (player.field_7512 != null) {
                    player.field_7512.method_7623();
                }
            }
        });
    }

    @Override
    public IPartModel getStaticModels() {
        return this.selectModel(MODELS_OFF, MODELS_ON, MODELS_HAS_CHANNEL, MODELS_LOCKED_OFF, MODELS_LOCKED_ON, MODELS_LOCKED_HAS_CHANNEL);
    }
}

